/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import org.postgresql.Driver;
import org.postgresql.PGProperty;
import org.postgresql.ds.common.PGObjectFactory;
import org.postgresql.jdbc.AutoSave;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.util.ExpressionProperties;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;
import org.postgresql.util.URLCoder;

public abstract class BaseDataSource
implements CommonDataSource,
Referenceable {
    private final String LOCALHOST = "localhost";
    private static final int ZERO = 0;
    private String dbName = "";
    private String[] serNames = new String[]{"localhost"};
    private String userName;
    private String pwd;
    private int[] portNumsT = new int[]{0};
    private Properties propes = new Properties();

    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getConnection(this.userName, this.pwd);
    }

    public Connection getConnection(String userT, String passwordT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Connection _con = DriverManager.getConnection(this.getUrl(), userT, passwordT);
            if (LOGGER.isLoggable(Level.FINE)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LOGGER.log(Level.FINE, "Created a {0} for {1} at {2}", this.getDescription(), userT, this.getUrl());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _con;
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "Failed to create a {0} for {1} at {2}: {3}", this.getDescription(), userT, this.getUrl(), sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public PrintWriter getLogWriter() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Deprecated
    public String getServerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serNames[0];
    }

    public String[] getServerNames() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serNames;
    }

    @Deprecated
    public void setServerName(String serName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setServerNames(new String[]{serName});
    }

    public void setServerNames(String[] serNames) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (serNames == null || serNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serNames = new String[]{"localhost"};
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            serNames = Arrays.copyOf(serNames, serNames.length);
            for (int i = 0; i < serNames.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (serNames[i] != null && !serNames[i].equals("")) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                serNames[i] = "localhost";
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serNames = serNames;
        }
    }

    public String getDatabaseName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.dbName;
    }

    public void setDatabaseName(String dbName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dbName = dbName;
    }

    public abstract String getDescription();

    public String getUser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.userName;
    }

    public void setUser(String user) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.userName = user;
    }

    public String getPassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pwd;
    }

    public void setPassword(String password) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pwd = password;
    }

    @Deprecated
    public int getPortNumber() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.portNumsT == null || this.portNumsT.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        return this.portNumsT[0];
    }

    public int[] getPortNumbers() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.portNumsT;
    }

    @Deprecated
    public void setPortNumber(int portNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setPortNumbers(new int[]{portNum});
    }

    public void setPortNumbers(int[] portNums) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (portNums == null || portNums.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            portNums = new int[]{0};
        }
        this.portNumsT = Arrays.copyOf(portNums, portNums.length);
    }

    public String getOptions() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.OPTIONS.get(this.propes);
    }

    public void setOptions(String options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.OPTIONS.set(this.propes, options);
    }

    @Override
    public int getLoginTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOGIN_TIMEOUT.getIntNoCheck(this.propes);
    }

    @Override
    public void setLoginTimeout(int loginTimeoutStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOGIN_TIMEOUT.set(this.propes, loginTimeoutStream);
    }

    public int getConnectTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CONNECT_TIMEOUT.getIntNoCheck(this.propes);
    }

    public void setConnectTimeout(int connectTimeoutStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CONNECT_TIMEOUT.set(this.propes, connectTimeoutStream);
    }

    public int getProtocolVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!PGProperty.PROTOCOL_VERSION.isPresent(this.propes)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.PROTOCOL_VERSION.getIntNoCheck(this.propes);
    }

    public void setProtocolVersion(int protocolVersion) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (protocolVersion == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGProperty.PROTOCOL_VERSION.set(this.propes, null);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGProperty.PROTOCOL_VERSION.set(this.propes, protocolVersion);
        }
    }

    public int getReceiveBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.RECEIVE_BUFFER_SIZE.getIntNoCheck(this.propes);
    }

    public void setReceiveBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.RECEIVE_BUFFER_SIZE.set(this.propes, n_bytes);
    }

    public int getSendBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SEND_BUFFER_SIZE.getIntNoCheck(this.propes);
    }

    public void setSendBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SEND_BUFFER_SIZE.set(this.propes, n_bytes);
    }

    public void setPrepareThreshold(int _count) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.PREPARE_THRESHOLD.set(this.propes, _count);
    }

    public int getPrepareThreshold() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.PREPARE_THRESHOLD.getIntNoCheck(this.propes);
    }

    public int getPreparedStatementCacheQueries() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getIntNoCheck(this.propes);
    }

    public void setPreparedStatementCacheQueries(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.set(this.propes, cacheSize);
    }

    public int getPreparedStatementCacheSizeMiB() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getIntNoCheck(this.propes);
    }

    public void setPreparedStatementCacheSizeMiB(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.set(this.propes, cacheSize);
    }

    public int getDatabaseMetadataCacheFields() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DATABASE_METADATA_CACHE_FIELDS.getIntNoCheck(this.propes);
    }

    public void setDatabaseMetadataCacheFields(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.DATABASE_METADATA_CACHE_FIELDS.set(this.propes, cacheSize);
    }

    public int getDatabaseMetadataCacheFieldsMiB() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getIntNoCheck(this.propes);
    }

    public void setDatabaseMetadataCacheFieldsMiB(int cacheSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.set(this.propes, cacheSize);
    }

    public void setDefaultRowFetchSize(int fetchSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.DEFAULT_ROW_FETCH_SIZE.set(this.propes, fetchSize);
    }

    public int getDefaultRowFetchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DEFAULT_ROW_FETCH_SIZE.getIntNoCheck(this.propes);
    }

    public void setUnknownLength(int unknownLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UNKNOWN_LENGTH.set(this.propes, unknownLength);
    }

    public int getUnknownLength() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UNKNOWN_LENGTH.getIntNoCheck(this.propes);
    }

    public void setSocketTimeout(int seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SOCKET_TIMEOUT.set(this.propes, seconds);
    }

    public int getSocketTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SOCKET_TIMEOUT.getIntNoCheck(this.propes);
    }

    public void setCancelSignalTimeout(int seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CANCEL_SIGNAL_TIMEOUT.set(this.propes, seconds);
    }

    public void setSsl(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean TRUE = true;
        boolean FALSE = false;
        if (enabled) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGProperty.SSL.set(this.propes, true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGProperty.SSL.set(this.propes, false);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    public int getCancelSignalTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CANCEL_SIGNAL_TIMEOUT.getIntNoCheck(this.propes);
    }

    public boolean getSsl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean aBoolean = PGProperty.SSL.getBoolean(this.propes);
        boolean bBoolean = "".equals(PGProperty.SSL.get(this.propes));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return aBoolean || bBoolean;
    }

    public void setSslfactory(String classname) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_FACTORY.set(this.propes, classname);
    }

    public String getSslfactory() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_FACTORY.get(this.propes);
    }

    public String getSslMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_MODE.get(this.propes);
    }

    public void setSslMode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_MODE.set(this.propes, mode);
    }

    public String getSslFactoryArg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_FACTORY_ARG.get(this.propes);
    }

    public void setSslFactoryArg(String arg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_FACTORY_ARG.set(this.propes, arg);
    }

    public String getSslHostnameVerifier() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_HOSTNAME_VERIFIER.get(this.propes);
    }

    public void setSslHostnameVerifier(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_HOSTNAME_VERIFIER.set(this.propes, className);
    }

    public String getSslCert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_CERT.get(this.propes);
    }

    public void setSslCert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_CERT.set(this.propes, file);
    }

    public String getSslKey() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_KEY.get(this.propes);
    }

    public void setSslKey(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_KEY.set(this.propes, file);
    }

    public String getSslRootCert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_ROOT_CERT.get(this.propes);
    }

    public void setSslRootCert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_ROOT_CERT.set(this.propes, file);
    }

    public String getSslPassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_PASSWORD.get(this.propes);
    }

    public void setSslPassword(String password) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_PASSWORD.set(this.propes, password);
    }

    public String getSslPasswordCallback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSL_PASSWORD_CALLBACK.get(this.propes);
    }

    public void setSslPasswordCallback(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSL_PASSWORD_CALLBACK.set(this.propes, className);
    }

    public void setApplicationName(String applicationName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.APPLICATION_NAME.set(this.propes, applicationName);
    }

    public String getApplicationName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.APPLICATION_NAME.get(this.propes);
    }

    public void setTargetServerType(String targetServerType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.TARGET_SERVER_TYPE.set(this.propes, targetServerType);
    }

    public String getTargetServerType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.TARGET_SERVER_TYPE.get(this.propes);
    }

    public void setLoadBalanceHosts(boolean loadBalanceHosts) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOAD_BALANCE_HOSTS.set(this.propes, loadBalanceHosts);
    }

    public boolean getLoadBalanceHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOAD_BALANCE_HOSTS.isPresent(this.propes);
    }

    public void setHostRecheckSeconds(int hostRecheckSeconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.HOST_RECHECK_SECONDS.set(this.propes, hostRecheckSeconds);
    }

    public int getHostRecheckSeconds() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.HOST_RECHECK_SECONDS.getIntNoCheck(this.propes);
    }

    public void setTcpKeepAlive(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.TCP_KEEP_ALIVE.set(this.propes, enabled);
    }

    public boolean getTcpKeepAlive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.TCP_KEEP_ALIVE.getBoolean(this.propes);
    }

    public void setBinaryTransfer(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.BINARY_TRANSFER.set(this.propes, enabled);
    }

    public boolean getBinaryTransfer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.BINARY_TRANSFER.getBoolean(this.propes);
    }

    public void setBinaryTransferEnable(String oidList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.BINARY_TRANSFER_ENABLE.set(this.propes, oidList);
    }

    public String getBinaryTransferEnable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.BINARY_TRANSFER_ENABLE.get(this.propes);
    }

    public void setBinaryTransferDisable(String oidList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.BINARY_TRANSFER_DISABLE.set(this.propes, oidList);
    }

    public String getBinaryTransferDisable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.BINARY_TRANSFER_DISABLE.get(this.propes);
    }

    public String getStringType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.STRING_TYPE.get(this.propes);
    }

    public void setStringType(String stringType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.STRING_TYPE.set(this.propes, stringType);
    }

    public boolean isColumnSanitiserDisabled() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.propes);
    }

    public boolean getDisableColumnSanitiser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.propes);
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.DISABLE_COLUMN_SANITISER.set(this.propes, disableColumnSanitiser);
    }

    public String getCurrentSchema() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CURRENT_SCHEMA.get(this.propes);
    }

    public void setCurrentSchema(String currentSchema) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CURRENT_SCHEMA.set(this.propes, currentSchema);
    }

    public boolean getReadOnly() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.READ_ONLY.getBoolean(this.propes);
    }

    public void setReadOnly(boolean readOnly) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.READ_ONLY.set(this.propes, readOnly);
    }

    public String getReadOnlyMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.READ_ONLY_MODE.get(this.propes);
    }

    public void setReadOnlyMode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.READ_ONLY_MODE.set(this.propes, mode);
    }

    public boolean getLogUnclosedConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(this.propes);
    }

    public void setLogUnclosedConnections(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOG_UNCLOSED_CONNECTIONS.set(this.propes, enabled);
    }

    public boolean getLogServerErrorDetail() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(this.propes);
    }

    public void setLogServerErrorDetail(boolean enabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOG_SERVER_ERROR_DETAIL.set(this.propes, enabled);
    }

    public String getAssumeMinServerVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.ASSUME_MIN_SERVER_VERSION.get(this.propes);
    }

    public void setAssumeMinServerVersion(String minVersion) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(this.propes, minVersion);
    }

    public String getJaasApplicationName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.JAAS_APPLICATION_NAME.get(this.propes);
    }

    public void setJaasApplicationName(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.JAAS_APPLICATION_NAME.set(this.propes, name);
    }

    public boolean getJaasLogin() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.JAAS_LOGIN.getBoolean(this.propes);
    }

    public void setJaasLogin(boolean doLoginStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.JAAS_LOGIN.set(this.propes, doLoginStream);
    }

    public String getKerberosServerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.KERBEROS_SERVER_NAME.get(this.propes);
    }

    public void setKerberosServerName(String serName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.KERBEROS_SERVER_NAME.set(this.propes, serName);
    }

    public boolean getUseSpNego() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.USE_SPNEGO.getBoolean(this.propes);
    }

    public void setUseSpNego(boolean use) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.USE_SPNEGO.set(this.propes, use);
    }

    public String getGssLib() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.GSS_LIB.get(this.propes);
    }

    public void setGssLib(String lib) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.GSS_LIB.set(this.propes, lib);
    }

    public String getSspiServiceClass() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SSPI_SERVICE_CLASS.get(this.propes);
    }

    public void setSspiServiceClass(String serviceClass) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SSPI_SERVICE_CLASS.set(this.propes, serviceClass);
    }

    public boolean getAllowEncodingChanges() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.ALLOW_ENCODING_CHANGES.getBoolean(this.propes);
    }

    public void setAllowEncodingChanges(boolean allow) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.ALLOW_ENCODING_CHANGES.set(this.propes, allow);
    }

    public String getSocketFactory() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SOCKET_FACTORY.get(this.propes);
    }

    public void setSocketFactory(String socketFactoryClassName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SOCKET_FACTORY.set(this.propes, socketFactoryClassName);
    }

    public String getSocketFactoryArg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SOCKET_FACTORY_ARG.get(this.propes);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SOCKET_FACTORY_ARG.set(this.propes, socketFactoryArg);
    }

    public void setReplication(String replication) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.REPLICATION.set(this.propes, replication);
    }

    public String getEscapeSyntaxCallMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.ESCAPE_SYNTAX_CALL_MODE.get(this.propes);
    }

    public String getLoggerFile() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties sysProperties = System.getProperties();
        ExpressionProperties exprPropst = new ExpressionProperties(this.propes, sysProperties);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String logFile = PGProperty.LOGGER_FILE.get(exprPropst);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return logFile;
    }

    public void setEscapeSyntaxCallMode(String callMode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.ESCAPE_SYNTAX_CALL_MODE.set(this.propes, callMode);
    }

    public String getReplication() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.REPLICATION.get(this.propes);
    }

    public String getLoggerLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOGGER_LEVEL.get(this.propes);
    }

    public void setLoggerLevel(String loggerLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOGGER_LEVEL.set(this.propes, loggerLevel);
    }

    public void setLoggerFile(String loggerFile) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOGGER_FILE.set(this.propes, loggerFile);
    }

    public String getUrl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder urlStrBuilder = new StringBuilder(100);
        urlStrBuilder.append("jdbc:postgresql://");
        for (int i = 0; i < this.serNames.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String str = ",";
                urlStrBuilder.append(",");
            }
            urlStrBuilder.append(this.serNames[i]);
            if (null == this.portNumsT || this.portNumsT.length < i || this.portNumsT[i] == 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str2 = ":";
            urlStrBuilder.append(":").append(this.portNumsT[i]);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        urlStrBuilder.append("/").append(URLCoder.encode(this.dbName));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder query = new StringBuilder(100);
        for (PGProperty prop : PGProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!prop.isPresent(this.propes)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (query.length() != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                query.append("&");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            query.append(prop.getName());
            query.append("=");
            query.append(URLCoder.encode(prop.get(this.propes)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlStrBuilder.append("?");
            urlStrBuilder.append((CharSequence)query);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return urlStrBuilder.toString();
    }

    public String getProperty(String name) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty pgProperty = PGProperty.forName(name);
        if (pgProperty != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getProperty(pgProperty);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String info = "Unsupported prop name: {0}";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PSQLState invalidParameterValue = PSQLState.INVALID_PARAMETER_VALUE;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Unsupported prop name: {0}", name), invalidParameterValue);
    }

    public String getURL() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getUrl();
    }

    public void setUrl(String _url) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties p = Driver.parseURL(_url, null);
        if (p == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("URL invalid " + _url);
        }
        for (PGProperty prop : PGProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.propes.containsKey(prop.getName())) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setProperty(prop, prop.get(p));
        }
    }

    public void setURL(String _url) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setUrl(_url);
    }

    public void setProperty(String name, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty pgProperty = PGProperty.forName(name);
        if (pgProperty == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Unsupported prop name: {0}", name), PSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setProperty(pgProperty, _value);
    }

    public String getProperty(PGProperty prop) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return prop.get(this.propes);
    }

    public void setProperty(PGProperty prop, String _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_value == null) {
            return;
        }
        switch (prop) {
            case PG_HOST: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setServerNames(_value.split(","));
                break;
            }
            case PG_PORT: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String str = ",";
                String[] pst = _value.split(",");
                int length = pst.length;
                int[] portsT = new int[length];
                for (int index = 0; index < pst.length; ++index) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        portsT[index] = Integer.parseInt(pst[index]);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        portsT[index] = 0;
                    }
                }
                this.setPortNumbers(portsT);
                break;
            }
            case PG_DBNAME: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setDatabaseName(_value);
                break;
            }
            case USER: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setUser(_value);
                break;
            }
            case PASSWORD: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setPassword(_value);
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.propes.setProperty(prop.getName(), _value);
            }
        }
    }

    protected Reference createReference() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new Reference(this.getClass().getName(), PGObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reference reference = this.createReference();
        StringBuilder serverString = new StringBuilder();
        for (int i = 0; i < this.serNames.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                serverString.append(",");
            }
            String serName = this.serNames[i];
            serverString.append(serName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        reference.add(new StringRefAddr("serName", serverString.toString()));
        StringBuilder portStrSB = new StringBuilder();
        for (int i = 0; i < this.portNumsT.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                portStrSB.append(",");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int p = this.portNumsT[i];
            portStrSB.append(Integer.toString(p));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        reference.add(new StringRefAddr("portNum", portStrSB.toString()));
        reference.add(new StringRefAddr("dbName", this.dbName));
        if (this.userName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("user", this.userName));
        }
        if (this.pwd != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr("password", this.pwd));
        }
        for (PGProperty prop : PGProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!prop.isPresent(this.propes)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reference.add(new StringRefAddr(prop.getName(), prop.get(this.propes)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return reference;
    }

    private static String getReferenceProperty(Reference reference, String propertyName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RefAddr addr = reference.get(propertyName);
        if (addr == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object content = addr.getContent();
        String prop = (String)content;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return prop;
    }

    public void setFromReference(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.dbName = BaseDataSource.getReferenceProperty(reference, "dbName");
        String portNumString = BaseDataSource.getReferenceProperty(reference, "portNum");
        if (portNumString != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String[] pst = portNumString.split(",");
            int[] portsT = new int[pst.length];
            for (int j = 0; j < pst.length; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    portsT[j] = Integer.parseInt(pst[j]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    portsT[j] = 0;
                }
            }
            this.setPortNumbers(portsT);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setPortNumbers(null);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String[] serNames = BaseDataSource.getReferenceProperty(reference, "serName").split(",");
        this.setServerNames(serNames);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (PGProperty prop : PGProperty.values()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String referenceProperty = BaseDataSource.getReferenceProperty(reference, prop.getName());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setProperty(prop, referenceProperty);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    protected void writeBaseObject(ObjectOutputStream outStream) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.serNames);
        outStream.writeObject(this.dbName);
        outStream.writeObject(this.userName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.pwd);
        outStream.writeObject(this.portNumsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        outStream.writeObject(this.propes);
    }

    protected void readBaseObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.serNames = (String[])inStream.readObject();
        this.dbName = (String)inStream.readObject();
        this.userName = (String)inStream.readObject();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pwd = (String)inStream.readObject();
        this.portNumsT = (int[])inStream.readObject();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.propes = (Properties)inStream.readObject();
    }

    public void initializeFrom(BaseDataSource baseDataSource) throws IOException, ClassNotFoundException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        baseDataSource.writeBaseObject(objectOutputStream);
        objectOutputStream.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.readBaseObject(objectInputStream);
    }

    public PreferQueryMode getPreferQueryMode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PreferQueryMode.of(PGProperty.PREFER_QUERY_MODE.get(this.propes));
    }

    public void setPreferQueryMode(PreferQueryMode preferenceerQueryMode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.PREFER_QUERY_MODE.set(this.propes, preferenceerQueryMode.value());
    }

    public AutoSave getAutosave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return AutoSave.of(PGProperty.AUTOSAVE.get(this.propes));
    }

    public void setAutosave(AutoSave autoSave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.AUTOSAVE.set(this.propes, autoSave.value());
    }

    public boolean getCleanupSavepoints() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CLEANUP_SAVEPOINTS.getBoolean(this.propes);
    }

    public void setCleanupSavepoints(boolean cleanupSavepoints) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CLEANUP_SAVEPOINTS.set(this.propes, cleanupSavepoints);
    }

    public boolean getReWriteBatchedInserts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(this.propes);
    }

    public void setReWriteBatchedInserts(boolean reWrite) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.REWRITE_BATCHED_INSERTS.set(this.propes, reWrite);
    }

    public boolean getHideUnprivilegedObjects() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(this.propes);
    }

    public void setHideUnprivilegedObjects(boolean hideUnprivileged) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.HIDE_UNPRIVILEGED_OBJECTS.set(this.propes, hideUnprivileged);
    }

    public String getSslfactoryarg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslFactoryArg();
    }

    public boolean isSsl() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSsl();
    }

    public String getSslcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslCert();
    }

    public void setSslfactoryarg(String arg) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslFactoryArg(arg);
    }

    public String getSslmode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslMode();
    }

    public void setSslcert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslCert(file);
    }

    public String getSsl_hostnameverifier() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslHostnameVerifier();
    }

    public void setSslmode(String mode) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslMode(mode);
    }

    public String getSsl_key() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslKey();
    }

    public void setSsl_hostnameverifier(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslHostnameVerifier(className);
    }

    public String getSslrootcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslRootCert();
    }

    public void setSsl_key(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslKey(file);
    }

    public String getSslpassword_callback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslPasswordCallback();
    }

    public void setSslrootcert(String file) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslRootCert(file);
    }

    public String getSslpassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSslPassword();
    }

    public void setSslpassword_callback(String className) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslPasswordCallback(className);
    }

    public int getRecvBufferSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReceiveBufferSize();
    }

    public void setSslpassword(String sslpassword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSslPassword(sslpassword);
    }

    public boolean isAllowEncodingChanges() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getAllowEncodingChanges();
    }

    public void setRecvBufferSize(int n_bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setReceiveBufferSize(n_bytes);
    }

    public boolean isTcpKeepAlive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTcpKeepAlive();
    }

    public boolean isLogUnclosedConnections() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLogUnclosedConnections();
    }

    public boolean isDisableColumnSanitiser() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getDisableColumnSanitiser();
    }

    public boolean isReadOnly() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReadOnly();
    }

    public boolean isCleanupSavePoints() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getCleanupSavepoints();
    }

    public boolean isLoadBalanceHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLoadBalanceHosts();
    }

    public boolean isReWriteBatchedInserts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getReWriteBatchedInserts();
    }

    public void setCleanupSavePoints(boolean cleanupSavepoints) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setCleanupSavepoints(cleanupSavepoints);
    }

    public void setUseDispatch(boolean useDispatch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.USEDISPATCH.set(this.propes, useDispatch);
    }

    public boolean getUseDispatch() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.USEDISPATCH.getBoolean(this.propes);
    }

    public void setHostLoadRate(int _hostLoadRate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.HOSTLOADRATE.set(this.propes, _hostLoadRate);
    }

    public int getHostLoadRate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.HOSTLOADRATE.getIntNoCheck(this.propes);
    }

    public void setSlave_Add(String slaveAdd) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SLAVE_ADD.set(this.propes, slaveAdd);
    }

    public String getSlave_Add() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SLAVE_ADD.get(this.propes);
    }

    public void setSlave_Port(String slavePort) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.SLAVE_PORT.set(this.propes, slavePort);
    }

    public String getSlave_Port() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.SLAVE_PORT.get(this.propes);
    }

    public void setUseConnect_Pool(boolean useConnectPool) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.USECONNECT_POOL.set(this.propes, useConnectPool);
    }

    public boolean getUseConnect_Pool() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.USECONNECT_POOL.getBoolean(this.propes);
    }

    public void setConnect_Poolsize(int _connectPoolsize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CONNECT_POOLSIZE.set(this.propes, _connectPoolsize);
    }

    public int getConnect_Poolsize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CONNECT_POOLSIZE.getIntNoCheck(this.propes);
    }

    public void setMaster_Check(boolean masterCheck) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.MASTER_CHECK.set(this.propes, masterCheck);
    }

    public boolean getMaster_Check() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.MASTER_CHECK.getBoolean(this.propes);
    }

    public void setCluster_Monitor(boolean clusterMonitor) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CLUSTER_MONITOR.set(this.propes, clusterMonitor);
    }

    public int getMonitorInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty monitorinterval = PGProperty.MONITORINTERVAL;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return monitorinterval.getIntNoCheck(this.propes);
    }

    public boolean getCluster_Monitor() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CLUSTER_MONITOR.getBoolean(this.propes);
    }

    public void setMonitorInterval(int monitorInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty monitorinterval = PGProperty.MONITORINTERVAL;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        monitorinterval.set(this.propes, monitorInterval);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void setMonitorSocketTimeout(int monitorSocketTimeout) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty monitorSocketTimeout1 = PGProperty.MONITOR_SOCKET_TIMEOUT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        monitorSocketTimeout1.set(this.propes, monitorSocketTimeout);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void setRetryTimes(int retryTimes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty retrytimes = PGProperty.RETRYTIMES;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        retrytimes.set(this.propes, retryTimes);
    }

    public int getRetryTimes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.RETRYTIMES.getIntNoCheck(this.propes);
    }

    public void setRetryInterval(int retryInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.RETRYINTERVAL.set(this.propes, retryInterval);
    }

    public int getRetryInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.RETRYINTERVAL.getIntNoCheck(this.propes);
    }

    public int getMonitorSocketTimeout() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty monitorSocketTimeout = PGProperty.MONITOR_SOCKET_TIMEOUT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return monitorSocketTimeout.getIntNoCheck(this.propes);
    }

    public void setConfigurePath(String configurePath) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CONFIGUREPATH.set(this.propes, configurePath);
    }

    public String getConfigurePath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CONFIGUREPATH.get(this.propes);
    }

    public void setWhiteList(String whiteList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.WHITELIST.set(this.propes, whiteList);
    }

    public String getAllSendFunctionList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty allSendFunctionList = PGProperty.ALL_SEND_FUNCTION_LIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return allSendFunctionList.get(this.propes);
    }

    public String getWhiteList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.WHITELIST.get(this.propes);
    }

    public void setBlackList(String blackList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.BLACKLIST.set(this.propes, blackList);
    }

    public String getBlackList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.BLACKLIST.get(this.propes);
    }

    public void setMasterFunctionList(String masterFunctionList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty masterfunctionlist = PGProperty.MASTERFUNCTIONLIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        masterfunctionlist.set(this.propes, masterFunctionList);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public String getMasterFunctionList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty masterfunctionlist = PGProperty.MASTERFUNCTIONLIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return masterfunctionlist.get(this.propes);
    }

    public void setAllSendFunctionList(String allSendFunctionList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty allSendFunctionList1 = PGProperty.ALL_SEND_FUNCTION_LIST;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        allSendFunctionList1.set(this.propes, allSendFunctionList);
    }

    public void setBlackSqlList(String blackSqlList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.BLACKSQLLIST.set(this.propes, blackSqlList);
    }

    public String getBlackSqlList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.BLACKSQLLIST.get(this.propes);
    }

    public void setTransactionDispatchStrategy(int transactionDispatchStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.TRANSACTIONDISPATCHSTRATEGY.set(this.propes, transactionDispatchStrategy);
    }

    public int getTransactionDispatchStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.TRANSACTIONDISPATCHSTRATEGY.getIntNoCheck(this.propes);
    }

    public void setReadListStrategy(int readListStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.READ_LIST_STRATEGY.set(this.propes, readListStrategy);
    }

    public int getReadListStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.READ_LIST_STRATEGY.getIntNoCheck(this.propes);
    }

    public void setTempTable(String tempTable) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.TEMPTABLE.set(this.propes, tempTable);
    }

    public void setDifferentLsn(int differentLsn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.DIFFERENT_LSN.set(this.propes, differentLsn);
    }

    public int getDifferentLsn() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.DIFFERENT_LSN.getIntNoCheck(this.propes);
    }

    public void setClientEncoding(String clientEncoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.CLIENT_ENCODING.set(this.propes, clientEncoding);
    }

    public String getTempTable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.TEMPTABLE.get(this.propes);
    }

    public String getClientEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.CLIENT_ENCODING.get(this.propes);
    }

    public void setPasswordEncryption(String passwordEncryption) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.PASSWORD_ENCRYPTION.set(this.propes, passwordEncryption);
    }

    public String getPasswordEncryption() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.PASSWORD_ENCRYPTION.get(this.propes);
    }

    public void setUseFetchSizeInAutoCommit(boolean useFetchSizeInAutoCommit) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.USE_FETCH_SIZE_IN_AUTO_COMMIT.set(this.propes, useFetchSizeInAutoCommit);
    }

    public boolean getUseFetchSizeInAutoCommit() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.USE_FETCH_SIZE_IN_AUTO_COMMIT.getBoolean(this.propes);
    }

    public void setNodeList(String nodeList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.NODE_LIST.set(this.propes, nodeList);
    }

    public String getNodeList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.NODE_LIST.get(this.propes);
    }

    public void setNullConvertEmptyLob(boolean nullConvertEmptyLob) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.NULL_CONVERT_EMPTY_LOB.set(this.propes, nullConvertEmptyLob);
    }

    public boolean getNullConvertEmptyLob() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.NULL_CONVERT_EMPTY_LOB.getBoolean(this.propes);
    }

    public void setMasterKeyword(String masterKeyword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.MASTER_KEYWORD.set(this.propes, masterKeyword);
    }

    public String getMasterKeyword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.MASTER_KEYWORD.get(this.propes);
    }

    public void setInitParams(String initParams) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.INIT_PARAMS.set(this.propes, initParams);
    }

    public String getInitParams() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.INIT_PARAMS.get(this.propes);
    }

    public void setOptimizeBatchedDML(boolean optimizeBatchedDML) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.OPTIMIZE_BATCHED_DML.set(this.propes, optimizeBatchedDML);
    }

    public boolean getOptimizeBatchedDML() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.OPTIMIZE_BATCHED_DML.getBoolean(this.propes);
    }

    public void setStoreCase(String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.STORE_CASE.set(this.propes, storeCase);
    }

    public String getStoreCase() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.STORE_CASE.get(this.propes);
    }

    public void setStructType(String structType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.STRUCT_TYPE.set(this.propes, structType);
    }

    public String getStructType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.STRUCT_TYPE.get(this.propes);
    }

    public void setZipLevel(int zipLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.ZIP_LEVEL.set(this.propes, zipLevel);
    }

    public int getZipLevel() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.ZIP_LEVEL.getIntNoCheck(this.propes);
    }

    public void setRowidType(String rowidType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.ROWID_TYPE.set(this.propes, rowidType);
    }

    public String getRowidType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.ROWID_TYPE.get(this.propes);
    }

    public void setFastFailover(boolean fastFailover) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.FAST_FAILOVER.set(this.propes, fastFailover);
    }

    public boolean getFastFailover() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.FAST_FAILOVER.getBoolean(this.propes);
    }

    public void setStableSlave(boolean StableSlave) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.STABLE_SLAVE.set(this.propes, StableSlave);
    }

    public boolean getStableSlave() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.STABLE_SLAVE.getBoolean(this.propes);
    }

    public void setLoadBalanceStrategy(int loadBalanceStrategy) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.LOADBALANCE_STRATEGY.set(this.propes, loadBalanceStrategy);
    }

    public int getLoadBalanceStrategy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.LOADBALANCE_STRATEGY.getIntNoCheck(this.propes);
    }

    public void setUkpwdcert(String ukpwdcert) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UKPWD_CERT.set(this.propes, ukpwdcert);
    }

    public String getUkpwdcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UKPWD_CERT.get(this.propes);
    }

    public void setUkpwdkey(String ukpwdkey) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UKPWD_KEY.set(this.propes, ukpwdkey);
    }

    public String getUkpwdkey() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UKPWD_KEY.get(this.propes);
    }

    public void setUkpwdrootcert(String ukpwdrootcert) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UKPWD_ROOT_CERT.set(this.propes, ukpwdrootcert);
    }

    public String getUkpwdrootcert() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UKPWD_ROOT_CERT.get(this.propes);
    }

    public void setUkpwdpassword(String ukpwdpassword) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UKPWD_PASSWORD.set(this.propes, ukpwdpassword);
    }

    public String getUkpwdpassword() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UKPWD_PASSWORD.get(this.propes);
    }

    public void setUkpwdpasswordcallback(String ukpwdpasswordcallback) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty.UKPWD_PASSWORD_CALLBACK.set(this.propes, ukpwdpasswordcallback);
    }

    public String getUkpwdpasswordcallback() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGProperty.UKPWD_PASSWORD_CALLBACK.get(this.propes);
    }

    static {
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("BaseDataSource is unable to load org.postgresql.Driver. Please check if you have proper PostgreSQL JDBC Driver jar on the classpath", classNotFoundException);
        }
    }
}

