/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public class Base64 {
    public static final boolean TRUE = true;
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int DONT_BREAK_LINES = 8;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte WHITE_SPACE_ENC = -5;

    private Base64() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static byte[] _encode3to4(byte[] src, int srcOffset, int numSigBytes, byte[] des, int destOffset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int inBuff = (numSigBytes > 0 ? src[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? src[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? src[srcOffset + 2] << 24 >>> 24 : 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (numSigBytes) {
            case 3: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                des[destOffset] = ALPHABET[inBuff >>> 18];
                des[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                des[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                des[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return des;
            }
            case 2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                des[destOffset] = ALPHABET[inBuff >>> 18];
                des[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                des[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                des[destOffset + 3] = 61;
                return des;
            }
            case 1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                des[destOffset] = ALPHABET[inBuff >>> 18];
                des[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                des[destOffset + 2] = 61;
                des[destOffset + 3] = 61;
                return des;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return des;
    }

    public static String _encodeBytes(byte[] src) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Base64._encodeBytes(src, 0, src.length, 0);
    }

    public static String _encodeBytes(byte[] src, int options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Base64._encodeBytes(src, 0, src.length, options);
    }

    public static String _encodeBytes(byte[] src, int off, int leng) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Base64._encodeBytes(src, off, leng, 0);
    }

    public static String _encodeBytes(byte[] srcBytes, int off, int leng, int options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dontBreakLinesT = options & 8;
        boolean breakLinesT = dontBreakLinesT == 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng43 = leng * 4 / 3;
        byte[] outputBuff = new byte[leng43 + (leng % 3 > 0 ? 4 : 0) + (breakLinesT ? leng43 / 76 : 0)];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dT = 0;
        int eT = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng2 = leng - 2;
        int lineLength = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (dT < leng2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Base64._encode3to4(srcBytes, dT + off, 3, outputBuff, eT);
            if (breakLinesT && (lineLength += 4) == 76) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                outputBuff[eT + 4] = 10;
                ++eT;
                lineLength = 0;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            dT += 3;
            eT += 4;
        }
        if (dT < leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Base64._encode3to4(srcBytes, dT + off, leng - dT, outputBuff, eT);
            eT += 4;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new String(outputBuff, 0, eT, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new String(outputBuff, 0, eT);
        }
    }

    private static int decode4to3(byte[] src, int srcOffset, byte[] des, int destOffset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (src[srcOffset + 2] == 61) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int outputBuff = (DECODABET[src[srcOffset]] & 0xFF) << 18 | (DECODABET[src[srcOffset + 1]] & 0xFF) << 12;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            des[destOffset] = (byte)(outputBuff >>> 16);
            return 1;
        }
        if (src[srcOffset + 3] == 61) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int outputBuff = (DECODABET[src[srcOffset]] & 0xFF) << 18 | (DECODABET[src[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[src[srcOffset + 2]] & 0xFF) << 6;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            des[destOffset] = (byte)(outputBuff >>> 16);
            des[destOffset + 1] = (byte)(outputBuff >>> 8);
            return 2;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int outputBuff = (DECODABET[src[srcOffset]] & 0xFF) << 18 | (DECODABET[src[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[src[srcOffset + 2]] & 0xFF) << 6 | DECODABET[src[srcOffset + 3]] & 0xFF;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            des[destOffset] = (byte)(outputBuff >> 16);
            des[destOffset + 1] = (byte)(outputBuff >> 8);
            des[destOffset + 2] = (byte)outputBuff;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 3;
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.out.println("" + src[srcOffset] + ": " + DECODABET[src[srcOffset]]);
            System.out.println("" + src[srcOffset + 1] + ": " + DECODABET[src[srcOffset + 1]]);
            System.out.println("" + src[srcOffset + 2] + ": " + DECODABET[src[srcOffset + 2]]);
            System.out.println("" + src[srcOffset + 3] + ": " + DECODABET[src[srcOffset + 3]]);
            return -1;
        }
    }

    public static byte[] decode(byte[] srcBytes, int off, int leng) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng34 = leng * 3 / 4;
        byte[] outputBuff = new byte[leng34];
        int outputBuffPosn = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbuiCrop = 0;
        byte sbuiDecode = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = off; i < off + leng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbuiCrop = (byte)(srcBytes[i] & 0x7F);
            sbuiDecode = DECODABET[sbuiCrop];
            if (sbuiDecode >= -5) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (sbuiDecode < -1) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                b4[b4Posn++] = sbuiCrop;
                if (b4Posn <= 3) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                outputBuffPosn += Base64.decode4to3(b4, 0, outputBuff, outputBuffPosn);
                b4Posn = 0;
                if (sbuiCrop == 61) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.err.println("Bad Base64 input character at " + i + ": " + srcBytes[i] + "(decimal)");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] output = new byte[outputBuffPosn];
        System.arraycopy(outputBuff, 0, output, 0, outputBuffPosn);
        return output;
    }

    public static byte[] decode(String str) {
        byte[] _bytes;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _bytes = str.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _bytes = str.getBytes();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _bytes = Base64.decode(_bytes, 0, _bytes.length);
        return _bytes;
    }

    static {
        byte[] _bytes;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _bytes = _NATIVE_ALPHABET;
        }
        ALPHABET = _bytes;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    }
}

