/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.CanEstimateSize;
import com.kingbase8.util.Gettable;
import com.kingbase8.util.TraceLogger;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class LruCache<Key, Value extends CanEstimateSize>
implements Gettable<Key, Value> {
    private final EvictAction<Value> onEvictT;
    private final CreateAction<Key, Value> createActionT;
    private final int maxSizeOfEntriesT;
    private final long maxSizeBytesT;
    private long currentSizeT;
    private final Map<Key, Value> cacheMap;
    public static final CreateAction NOOP_CREATE_ACTION_T = new CreateAction(){

        public Object create(Object o) throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
    };
    public static final EvictAction NOOP_EVICT_ACTION_T = new EvictAction(){

        public void evict(Object o) throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    };

    private void evictValue(Value _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.onEvictT.evict(_value);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public LruCache(int maxSizeOfEntries, long maxSizeBytes, boolean accessOrder) {
        this(maxSizeOfEntries, maxSizeBytes, accessOrder, NOOP_CREATE_ACTION_T, NOOP_EVICT_ACTION_T);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public LruCache(int maxSizeOfEntries, long maxSizeBytes, boolean accessOrder, CreateAction<Key, Value> createAction, EvictAction<Value> onEvict) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.maxSizeOfEntriesT = maxSizeOfEntries;
        this.maxSizeBytesT = maxSizeBytes;
        this.createActionT = createAction;
        this.onEvictT = onEvict;
        this.cacheMap = new LimitedMap(16, 0.75f, accessOrder);
    }

    @Override
    public synchronized Value get(Key _key) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Value)((CanEstimateSize)this.cacheMap.get(_key));
    }

    public synchronized Value borrow(Key _key) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CanEstimateSize _value = (CanEstimateSize)this.cacheMap.remove(_key);
        if (_value == null) {
            return (Value)((CanEstimateSize)this.createActionT.create(_key));
        }
        this.currentSizeT -= _value.getSize();
        return (Value)_value;
    }

    public synchronized void put(Key _key, Value _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _valueSize = _value.getSize();
        if (this.maxSizeBytesT == 0L || this.maxSizeOfEntriesT == 0 || _valueSize * 2L > this.maxSizeBytesT) {
            this.evictValue(_value);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.currentSizeT += _valueSize;
        CanEstimateSize prevT = (CanEstimateSize)this.cacheMap.put(_key, _value);
        if (prevT == null) {
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.currentSizeT -= prevT.getSize();
        if (prevT != _value) {
            this.evictValue(prevT);
        }
    }

    public synchronized void putAll(Map<Key, Value> m) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Map.Entry<Key, Value> _entry : m.entrySet()) {
            this.put(_entry.getKey(), (CanEstimateSize)_entry.getValue());
        }
    }

    private class LimitedMap
    extends LinkedHashMap<Key, Value> {
        LimitedMap(int initCapacity, float loadFactor, boolean accessOrder) {
            super(initCapacity, loadFactor, accessOrder);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Value> eldestEntry) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.size() <= LruCache.this.maxSizeOfEntriesT && LruCache.this.currentSizeT <= LruCache.this.maxSizeBytesT) {
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                if (this.size() <= LruCache.this.maxSizeOfEntriesT && LruCache.this.currentSizeT <= LruCache.this.maxSizeBytesT) {
                    return false;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Map.Entry _entry = iterator.next();
                LruCache.this.evictValue((CanEstimateSize)_entry.getValue());
                long _valueSize = ((CanEstimateSize)_entry.getValue()).getSize();
                if (_valueSize > 0L) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    LruCache.this.currentSizeT = LruCache.this.currentSizeT - _valueSize;
                }
                iterator.remove();
            }
            return false;
        }
    }

    public static interface CreateAction<Key, Value> {
        public Value create(Key var1) throws SQLException;
    }

    public static interface EvictAction<Value> {
        public void evict(Value var1) throws SQLException;
    }
}

