/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.ssl.LibKCIFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

public class LazyKeyManager
implements X509KeyManager {
    private String certfileT;
    private PrivateKey _key = null;
    private X509Certificate[] certificates = null;
    private String _keyfile;
    private CallbackHandler callbackHandler;
    private boolean defaultfileT;
    private KSQLException _error = null;

    public LazyKeyManager(String certfile, String _keyfile, CallbackHandler cbh, boolean defaultfile) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.certfileT = certfile;
        this._keyfile = _keyfile;
        this.callbackHandler = cbh;
        this.defaultfileT = defaultfile;
    }

    public void throwKeyManagerException() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._error != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw this._error;
        }
    }

    @Override
    public String chooseClientAlias(String[] _keyType, Principal[] issuers, Socket socket) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.certfileT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (issuers == null || issuers.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "user";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        X509Certificate[] certchainT = this.getCertificateChain("user");
        if (certchainT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        X500Principal ourissuerT = certchainT[certchainT.length - 1].getIssuerX500Principal();
        boolean isFound = false;
        for (Principal issuer : issuers) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!ourissuerT.equals(issuer)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            isFound = true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return isFound ? "user" : null;
    }

    @Override
    public String chooseServerAlias(String _keyType, Principal[] issuers, Socket socket) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String aliasT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.certificates == null && this.certfileT != null) {
            Collection<? extends Certificate> certsColls;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            CertificateFactory certificateFactoryT = null;
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                certificateFactoryT = "BC".equals(aliasT) ? CertificateFactory.getInstance("X.509", "BC") : CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._error = new KSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)certificateException);
                return null;
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                certsColls = certificateFactoryT.generateCertificates(new FileInputStream(this.certfileT));
            }
            catch (FileNotFoundException fileNotFoundException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!this.defaultfileT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._error = new KSQLException(GT.tr("Could not open SSL certificate file {0}.", this.certfileT), KSQLState.CONNECTION_FAILURE, (Throwable)fileNotFoundException);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return null;
            }
            catch (CertificateException certificateException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._error = new KSQLException(GT.tr("Loading the SSL certificate {0} into a KeyManager failed.", this.certfileT), KSQLState.CONNECTION_FAILURE, (Throwable)certificateException);
                return null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.certificates = certsColls.toArray(new X509Certificate[0]);
        }
        return this.certificates;
    }

    @Override
    public String[] getClientAliases(String _keyType, Principal[] issuers) {
        String[] stringArray;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String aliasT = this.chooseClientAlias(new String[]{_keyType}, issuers, null);
        if (aliasT == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = aliasT;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileFully_(String pathT) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RandomAccessFile randomAccessFileT = new RandomAccessFile(pathT, "r");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] retT = new byte[(int)randomAccessFileT.length()];
            randomAccessFileT.readFully(retT);
            byte[] byArray = retT;
            return byArray;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            randomAccessFileT.close();
        }
    }

    private String getAlgorithmName(EncryptedPrivateKeyInfo ePKInfoT) {
        try {
            AlgorithmParameters algorithmParameters = ePKInfoT.getAlgParameters();
            Class<?> clazz = algorithmParameters.getClass();
            Field field = clazz.getDeclaredField("paramSpi");
            field.setAccessible(true);
            Object spi = field.get(algorithmParameters);
            clazz = Class.forName("com.sun.crypto.provider.PBES2Parameters");
            Field field2 = clazz.getDeclaredField("pbes2AlgorithmName");
            field2.setAccessible(true);
            String spiname = (String)field2.get(spi);
            return spiname;
        }
        catch (Exception e) {
            KBLOGGER.log(Level.INFO, "getAlgorithmName failed!!!", e);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String aliasT) {
        block19: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                byte[] _keydata;
                if (this._key != null || this._keyfile == null) break block19;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.certificates == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.getCertificateChain(aliasT) == null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return null;
                    }
                }
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _keydata = LazyKeyManager.readFileFully_(this._keyfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!this.defaultfileT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw fileNotFoundException;
                    }
                    return null;
                }
                KeyFactory keyFactory = KeyFactory.getInstance(this.certificates[0].getPublicKey().getAlgorithm());
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    PKCS8EncodedKeySpec pkcs8KeySpecT = new PKCS8EncodedKeySpec(_keydata);
                    this._key = keyFactory.generatePrivate(pkcs8KeySpecT);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    String name;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    EncryptedPrivateKeyInfo ePKInfoT = new EncryptedPrivateKeyInfo(_keydata);
                    String algName = ePKInfoT.getAlgName();
                    if (("1.2.840.113549.1.5.13".equals(algName) || "PBES2".equals(algName)) && (name = this.getAlgorithmName(ePKInfoT)) != null) {
                        algName = name;
                    }
                    Cipher cipher = null;
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        cipher = Cipher.getInstance(algName);
                    }
                    catch (NoSuchPaddingException npex) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new NoSuchAlgorithmException(npex.getMessage(), npex);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    PasswordCallback pwdcallback = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.callbackHandler.handle(new Callback[]{pwdcallback});
                    }
                    catch (UnsupportedCallbackException ucex) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (this.callbackHandler instanceof LibKCIFactory.ConsoleCallbackHandler && "Console is not available".equals(ucex.getMessage())) {
                            this._error = new KSQLException(GT.tr("Could not read password for SSL _key file, console is not available.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ucex);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this._error = new KSQLException(GT.tr("Could not read password for SSL _key file by _callback_handler {0}.", this.callbackHandler.getClass().getName()), KSQLState.CONNECTION_FAILURE, (Throwable)ucex);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return null;
                    }
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        PBEKeySpec pbeKeySpecT = new PBEKeySpec(pwdcallback.getPassword());
                        pwdcallback.clearPassword();
                        SecretKeyFactory skFac = SecretKeyFactory.getInstance(algName);
                        SecretKey pbeKey = skFac.generateSecret(pbeKeySpecT);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        AlgorithmParameters algParams = ePKInfoT.getAlgParameters();
                        cipher.init(2, (Key)pbeKey, algParams);
                        PKCS8EncodedKeySpec pkcs8KeySpecT = ePKInfoT.getKeySpec(cipher);
                        this._key = keyFactory.generatePrivate(pkcs8KeySpecT);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._error = new KSQLException(GT.tr("Could not decrypt SSL _key file {0}.", this._keyfile), KSQLState.CONNECTION_FAILURE, (Throwable)generalSecurityException);
                        return null;
                    }
                }
            }
            catch (IOException ioException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._error = new KSQLException(GT.tr("Could not read SSL _key file {0}.", this._keyfile), KSQLState.CONNECTION_FAILURE, (Throwable)ioException);
            }
            catch (NoSuchAlgorithmException ex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._error = new KSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
                return null;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._key;
    }

    @Override
    public String[] getServerAliases(String _keyType, Principal[] issuersT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new String[0];
    }
}

