/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.ref.PhantomReference;
import java.util.BitSet;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.core.Field;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.Oid;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.SqlCommand;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.TypeTransferModeRegistry;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.util.LOGGER;
import org.postgresql.util.TraceLogger;

public class SimpleQuery
implements Query {
    private Map<String, Integer> _resultSetColumnNameIndexMap;
    private final NativeQuery _nativeQuery;
    private final TypeTransferModeRegistry transferModeRegistry;
    private String stmtName;
    private byte[] _encodedStatementName;
    private Field[] _fields;
    private boolean needUpdateFieldFormat;
    private boolean hasBinaryField;
    private boolean _portalDescribed;
    private boolean stmtDescribed;
    private final boolean sanitiserDisabled;
    private static final int ZERO = 0;
    private PhantomReference<?> cleanupReference;
    private int[] _preparedTypes;
    private BitSet unspecifiedParams;
    private short deallocateEpoch;
    private Integer cachedMaxResultRowSize;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(SimpleQuery src) {
        this(src._nativeQuery, src.transferModeRegistry, src.sanitiserDisabled);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    SimpleQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, boolean sanitiserDisabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._nativeQuery = query;
        this.transferModeRegistry = transferModeRegistry;
        this.sanitiserDisabled = sanitiserDisabled;
    }

    @Override
    public ParameterList createParameterList() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._nativeQuery._bindPositions.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.getBindCount(), this.transferModeRegistry);
    }

    @Override
    public String toString(ParameterList _parameters) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery.toString(_parameters);
    }

    public SimpleQuery[] getSubqueries() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleQuery[] v = null;
        return v;
    }

    public int getMaxResultRowSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.cachedMaxResultRowSize != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.cachedMaxResultRowSize;
        }
        if (!this.stmtDescribed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot estimate _result row size on a stmt that is not described");
        }
        int _maxResultRowSize = 0;
        if (this._fields != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (Field f : this._fields) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _fieldLength = f.getLength();
                if (_fieldLength < 1 || _fieldLength >= 65535) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _maxResultRowSize = -1;
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _maxResultRowSize += _fieldLength;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.cachedMaxResultRowSize = _maxResultRowSize;
        return _maxResultRowSize;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery.toString(null);
    }

    @Override
    public String getNativeSql() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery.nativeSql;
    }

    void setStatementName(String stmtName, short deallocateEpoch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (stmtName != null) : "stmt name should not be null";
        this.stmtName = stmtName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encodedStatementName = Utils._encodeUTF8(stmtName);
        this.deallocateEpoch = deallocateEpoch;
    }

    @Override
    public void close() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.reset();
    }

    void setPrepareTypes(int[] _paramTypes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < _paramTypes.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _paramType = _paramTypes[i];
            if (_paramType != 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.unspecifiedParams == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.unspecifiedParams = new BitSet();
            }
            this.unspecifiedParams.set(i);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._preparedTypes == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._preparedTypes = (int[])_paramTypes.clone();
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        System.arraycopy(_paramTypes, 0, this._preparedTypes, 0, _paramTypes.length);
    }

    int[] getPrepareTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._preparedTypes;
    }

    String getStatementName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtName;
    }

    boolean isPreparedFor(int[] _paramTypes, short deallocateEpoch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.stmtName == null || this._preparedTypes == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (this.deallocateEpoch != deallocateEpoch) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (_paramTypes.length == this._preparedTypes.length) : String.format("_paramTypes:%1$d _preparedTypes:%2$d", _paramTypes.length, this._preparedTypes.length);
        BitSet unspecified = this.unspecifiedParams;
        for (int i = 0; i < _paramTypes.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _paramType = _paramTypes[i];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int preparedType = this._preparedTypes[i];
            if (_paramType == preparedType || _paramType == 0 && unspecified != null && unspecified.get(i)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (LOGGER.isLoggable(Level.FINER)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LOGGER.log(Level.FINER, "Statement {0} does not match new _parameter types. Will have to un-prepare it and parse once again. To avoid performance issues, use the same data type for the same _bind position. Bind _index (1-based) is {1}, preparedType was {2} (after describe {3}), current _bind type is {4}", this.stmtName, i + 1, Oid.toString(unspecified != null && unspecified.get(i) ? 0 : preparedType), Oid.toString(preparedType), Oid.toString(_paramType));
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    boolean hasUnresolvedTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._preparedTypes == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        return this.unspecifiedParams != null && !this.unspecifiedParams.isEmpty();
    }

    byte[] getEncodedStatementName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._encodedStatementName;
    }

    void setFields(Field[] _fields) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fields = _fields;
        this._resultSetColumnNameIndexMap = null;
        this.cachedMaxResultRowSize = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.needUpdateFieldFormat = _fields != null;
        this.hasBinaryField = false;
    }

    Field[] getFields() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fields;
    }

    boolean needUpdateFieldFormats() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.needUpdateFieldFormat) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.needUpdateFieldFormat = false;
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    public void resetNeedUpdateFieldFormats() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.needUpdateFieldFormat = this._fields != null;
    }

    public boolean hasBinaryFields() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.hasBinaryField;
    }

    public void setHasBinaryFields(boolean hasBinaryField) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.hasBinaryField = hasBinaryField;
    }

    boolean isPortalDescribed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._portalDescribed;
    }

    void setPortalDescribed(boolean _portalDescribed) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._portalDescribed = _portalDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isStatementDescribed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmtDescribed;
    }

    void setStatementDescribed(boolean stmtDescribed) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stmtDescribed = stmtDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isEmpty() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getNativeSql().isEmpty();
    }

    void setCleanupRef(PhantomReference<?> cleanupReference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.cleanupReference != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.cleanupReference.clear();
            this.cleanupReference.enqueue();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.cleanupReference = cleanupReference;
    }

    void reset() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.cleanupReference != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.cleanupReference.clear();
            this.cleanupReference.enqueue();
            this.cleanupReference = null;
        }
        if (this.unspecifiedParams != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.unspecifiedParams.clear();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stmtName = null;
        this._encodedStatementName = null;
        this._fields = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._resultSetColumnNameIndexMap = null;
        this._portalDescribed = false;
        this.stmtDescribed = false;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public int getBatchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 1;
    }

    public NativeQuery getNativeQuery() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery;
    }

    public final int getBindCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery._bindPositions.length * this.getBatchSize();
    }

    @Override
    public Map<String, Integer> getResultSetColumnNameIndexMap() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Integer> _columnPositions = this._resultSetColumnNameIndexMap;
        if (_columnPositions == null && this._fields != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _columnPositions = PgResultSet.createColumnNameIndexMap(this._fields, this.sanitiserDisabled);
            if (this.stmtName != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._resultSetColumnNameIndexMap = _columnPositions;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _columnPositions;
    }

    @Override
    public SqlCommand getSqlCommand() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery.getCommand();
    }

    @Override
    public boolean hasForUpdate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._nativeQuery.forupdate;
    }
}

