/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.postgresql.util.PGobject;
import org.postgresql.util.TraceLogger;

public class DSInterval
extends PGobject {
    private static int dayOffset = Integer.MIN_VALUE;
    private static int maxMinute = 59;
    private static int maxSecond = 59;
    private byte[] bytes;
    private static int maxHour = 23;
    private static int maxLeadPrec = 9;
    private static int DSMaxLength = 11;
    private static int DSOffset = 60;

    public DSInterval() {
        this.setType("dsinterval");
        this.bytes = DSInterval.initDSInterval();
        this._value = DSInterval.toString(this.bytes);
    }

    public DSInterval(byte[] bytes) {
        this.setType("dsinterval");
        this.bytes = bytes;
        this._value = DSInterval.toString(this.bytes);
    }

    public DSInterval(String s) {
        this.setType("dsinterval");
        this.bytes = DSInterval.toBytes(s);
        this._value = DSInterval.toString(this.bytes);
    }

    @Override
    public String toString() {
        return DSInterval.toString(this.bytes);
    }

    @Override
    public void setValue(String s) throws SQLException {
        this.bytes = DSInterval.toBytes(s);
        super.setValue(DSInterval.toString(this.bytes));
    }

    public static boolean isDSInterval(String s) {
        return s.indexOf("days") <= 0 && s.indexOf("day") <= 0;
    }

    public static byte[] toBytes(String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            return null;
        }
        int var6 = 0;
        byte[] var7 = new byte[DSMaxLength];
        String var12 = null;
        String trimValue = s.trim();
        char var14 = trimValue.charAt(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int var1 = var14 != '-' && var14 != '+' ? 0 : 1;
        trimValue = trimValue.substring(var1);
        int var15 = trimValue.indexOf(32);
        String var8 = trimValue.substring(0, var15);
        if (var8.length() > maxLeadPrec) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String var16 = trimValue.substring(var15 + 1);
        StringTokenizer var17 = new StringTokenizer(var16, ":.");
        if (var17.hasMoreTokens()) {
            String var11;
            String var10;
            String var9;
            try {
                var9 = var17.nextToken();
                var10 = var17.nextToken();
                var11 = var17.nextToken();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    var12 = var17.nextToken();
                }
                catch (NoSuchElementException var21) {
                    var12 = null;
                }
            }
            catch (Exception var22) {
                throw new NumberFormatException();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int var23 = Integer.valueOf(var8);
            int var24 = Integer.valueOf(var9);
            int var25 = Integer.valueOf(var10);
            int var26 = Integer.valueOf(var11);
            if (var24 > maxHour) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException();
            }
            if (var25 > maxMinute) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException();
            }
            if (var26 > maxSecond) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (var12 != null) {
                if (var12.length() > maxLeadPrec) {
                    throw new NumberFormatException();
                }
                if (var12.length() < maxLeadPrec) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    char[] var19 = new char[maxLeadPrec];
                    for (int i = 0; i < var12.length(); ++i) {
                        var19[i] = var12.charAt(i);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    for (int var20 = i; var20 < maxLeadPrec; ++var20) {
                        var19[var20] = 48;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String var27 = new String(var19);
                    var6 = Integer.valueOf(var27);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    var6 = Integer.valueOf(var12);
                }
            }
            if (var14 == '-') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                var23 = -var23;
                var24 = -var24;
                var25 = -var25;
                var26 = -var26;
                var6 = -var6;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            var7[0] = (byte)((var23 += dayOffset) >> 24 & 0xFF);
            var7[1] = (byte)(var23 >> 16 & 0xFF);
            var7[2] = (byte)(var23 >> 8 & 0xFF);
            var7[3] = (byte)(var23 & 0xFF);
            var7[4] = (byte)(var24 + DSOffset);
            var7[5] = (byte)(var25 + DSOffset);
            var7[6] = (byte)(var26 + DSOffset);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            var7[7] = (byte)((var6 += dayOffset) >> 24 & 0xFF);
            var7[8] = (byte)(var6 >> 16 & 0xFF);
            var7[9] = (byte)(var6 >> 8 & 0xFF);
            var7[10] = (byte)(var6 & 0xFF);
            return var7;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new NumberFormatException();
    }

    public static String toString(byte[] bytesValue) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bytesValue != null && bytesValue.length != 0) {
            int var10;
            boolean isPositive = true;
            boolean var7 = false;
            int var3 = (bytesValue[0] & 0xFF) << 24;
            var3 |= (bytesValue[1] & 0xFF) << 16;
            var3 |= (bytesValue[2] & 0xFF) << 8;
            var3 |= bytesValue[3] & 0xFF;
            var3 -= dayOffset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int var4 = bytesValue[4] - DSOffset;
            int var5 = bytesValue[5] - DSOffset;
            int var6 = bytesValue[6] - DSOffset;
            int var11 = (bytesValue[7] & 0xFF) << 24;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            var11 |= (bytesValue[8] & 0xFF) << 16;
            var11 |= (bytesValue[9] & 0xFF) << 8;
            var11 |= bytesValue[10] & 0xFF;
            var11 -= dayOffset;
            if (var3 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var3 = -var3;
                var4 = -var4;
                var5 = -var5;
                var6 = -var6;
                var11 = -var11;
            } else if (var4 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var4 = -var4;
                var5 = -var5;
                var6 = -var6;
                var11 = -var11;
            } else if (var5 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var5 = -var5;
                var6 = -var6;
                var11 = -var11;
            } else if (var6 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var6 = -var6;
                var11 = -var11;
            } else if (var11 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var11 = -var11;
            }
            String var8 = String.format("%09d", var11);
            char[] var9 = var8.toCharArray();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (var10 = var9.length; var10 > 1 && var9[var10 - 1] == '0'; --var10) {
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            var8 = var8.substring(0, var10);
            String var1 = var3 + " " + var4 + ":" + var5 + ":" + var6 + "." + var8;
            if (!isPositive) {
                var1 = "-" + var1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return var1;
        }
        return new String();
    }

    private static byte[] initDSInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] bytes = new byte[DSMaxLength];
        int var1 = 0;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int var6 = var1 + dayOffset;
        bytes[0] = (byte)(var6 >> 24 & 0xFF);
        bytes[1] = (byte)(var6 >> 16 & 0xFF);
        bytes[2] = (byte)(var6 >> 8 & 0xFF);
        bytes[3] = (byte)(var6 & 0xFF);
        bytes[4] = (byte)(var2 + DSOffset);
        bytes[5] = (byte)(var3 + DSOffset);
        bytes[6] = (byte)(var4 + DSOffset);
        int var7 = var5 + dayOffset;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        bytes[7] = (byte)(var7 >> 24 & 0xFF);
        bytes[8] = (byte)(var7 >> 16 & 0xFF);
        bytes[9] = (byte)(var7 >> 8 & 0xFF);
        bytes[10] = (byte)(var7 & 0xFF);
        return bytes;
    }
}

