/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.Properties;
import java.util.logging.Level;
import org.postgresql.PGProperty;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public enum SslMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public final String value;
    public static final SslMode[] VALUES;

    private SslMode(String value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.value = value;
    }

    public boolean requireEncryption() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this == VERIFY_FULL || this == VERIFY_CA;
    }

    public boolean verifyPeerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return VERIFY_FULL == this;
    }

    public static SslMode of(Properties infoProps) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslmodeT = PGProperty.SSL_MODE.get(infoProps);
        if (sslmodeT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (PGProperty.SSL.getBoolean(infoProps) || "".equals(PGProperty.SSL.get(infoProps))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return VERIFY_FULL;
            }
            return PREFER;
        }
        for (SslMode sslModeT : VALUES) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!sslModeT.value.equalsIgnoreCase(sslmodeT)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return sslModeT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Invalid sslmode value: {0}", sslmodeT), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = SslMode.values();
    }
}

