/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.PGRefCursorResultSet;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Oid;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandlerBase;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Utils;
import org.postgresql.jdbc.BooleanTypeUtil;
import org.postgresql.jdbc.CompatibleDB;
import org.postgresql.jdbc.DSInterval;
import org.postgresql.jdbc.EsBlob;
import org.postgresql.jdbc.EsClob;
import org.postgresql.jdbc.EsNClob;
import org.postgresql.jdbc.PgArray;
import org.postgresql.jdbc.PgBlob;
import org.postgresql.jdbc.PgClob;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgResultSetMetaData;
import org.postgresql.jdbc.PgRowId;
import org.postgresql.jdbc.PgSQLXML;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.jdbc.PgStruct;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.jdbc.YMInterval;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PgResultSet
implements ResultSet,
PGRefCursorResultSet {
    private static boolean TRUE = true;
    private static boolean FALSE = false;
    private static int ZERO = 0;
    private String refCursorNameT;
    protected final BaseConnection baseConnection;
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    protected final BaseStatement stmt;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final NumberFormatException FAST_NUMBER_FAILED_EXCEPTION = new NumberFormatException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private int fetchdirection = 1002;
    private TimeZone defaultTimeZone;
    protected final Field[] fieldsT;
    private String onlyTableT = "";
    private PreparedStatement updateStatementT = null;
    private boolean usingOIDT = false;
    private static final BigInteger SHORT_MIN_VAL = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private boolean doingUpdatesT = false;
    private static final BigInteger SHORT_MAX_VAL = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger INT_MIN_VAL = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private boolean updateableT = false;
    private static final BigInteger INT_MAX_VAL = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger LONG_MIN_VAL = new BigInteger(Long.toString(Long.MIN_VALUE));
    private HashMap<String, Object> updateValuesMap = null;
    private static final BigInteger LONG_MAX_VAL = new BigInteger(Long.toString(Long.MAX_VALUE));
    protected final int maxFieldSize;
    private static Set<Integer> isColumnTrimmableSet = new HashSet<Integer>();
    protected List<byte[][]> rowsList;
    private ResultSetMetaData resultSetMetaData;
    protected int fetchSize;
    private PreparedStatement insertStatementT = null;
    private List<PrimaryKey> primaryKeysList;
    protected byte[][] _thisRow;
    protected boolean onInsertRowT = false;
    protected int curRowT = -1;
    private List<Map<String, Object>> allPrimaryKeysOfLobList;
    protected int rowOffsetT;
    protected ResultCursor resultCursor;
    private byte[][] rowBufferT = null;
    private PreparedStatement selectStatementT = null;
    protected final int maxRowsT;
    protected final Query originalQuery;
    protected SQLWarning _warnings = null;
    private final int _resultsettype;
    protected boolean wasNullFlagT = false;
    private boolean singleTableT = false;
    private String tablName = null;
    private PreparedStatement deleteStatementT = null;
    private final int _resultsetconcurrency;
    private Map<String, Integer> columnNameIndexMap;

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.resultSetMetaData == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultSetMetaData = this.createMetaData();
        }
        return this.resultSetMetaData;
    }

    @Override
    public URL getURL(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getURL _columnIndex: {0}", _columnIndex);
        this.checkClosed_();
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getURL(int)");
        throw e;
    }

    @Override
    public URL getURL(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getURL(this.findColumn(_columnName));
    }

    protected Object internalGetObject(int _columnIndex, Field _field) throws SQLException {
        String s;
        String decode;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (this.getSQLType(_columnIndex)) {
            case -7: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.oracle(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return _field.getMod() == 1 || _field.getMod() == -1 ? Boolean.valueOf(this.getBoolean(_columnIndex)) : this.getString(_columnIndex);
                }
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return _field.getMod() == 1 || _field.getMod() == -1 ? Boolean.valueOf(this.getBoolean(_columnIndex)) : (Object)this.getBytes(_columnIndex);
                }
            }
            case 16: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getBoolean(_columnIndex);
            }
            case 2009: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getSQLXML(_columnIndex);
            }
            case -6: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.oracle(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return this.getByte(_columnIndex);
                }
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return this.getInt(_columnIndex);
                }
            }
            case 4: 
            case 5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getInt(_columnIndex);
            }
            case -5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getLong(_columnIndex);
            }
            case 2: 
            case 3: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getNumeric_(_columnIndex, _field.getMod() == -1 ? -1 : _field.getMod() - 4 & 0xFFFF, true);
            }
            case 7: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Float.valueOf(this.getFloat(_columnIndex));
            }
            case 6: 
            case 8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getDouble(_columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getString(_columnIndex);
            }
            case 91: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getDate(_columnIndex);
            }
            case 92: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getTime(_columnIndex);
            }
            case 93: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getTimestamp(_columnIndex, null);
            }
            case -4: 
            case -3: 
            case -2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getBytes(_columnIndex);
            }
            case 2003: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getArray(_columnIndex);
            }
            case 2005: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getClob(_columnIndex);
            }
            case 2004: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getBlob(_columnIndex);
            }
            case 2002: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ("struct".equalsIgnoreCase(((PgConnection)this.baseConnection).getStructType())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return new PgStruct(this.baseConnection, this.getPGType(_columnIndex), this.fieldsT[_columnIndex - 1].getOID(), this.getString(_columnIndex));
                }
            }
            case -8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!"rowid".equalsIgnoreCase(((PgConnection)this.baseConnection).getRowIdType())) break;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getRowId(_columnIndex);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String type = this.getPGType(_columnIndex);
        if (type.equalsIgnoreCase("unknown")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getString(_columnIndex);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (type.equalsIgnoreCase("uuid")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.isBinary_(_columnIndex)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getUUID(this._thisRow[_columnIndex - 1]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getUUID(this.getString(_columnIndex));
        }
        if (type.equalsIgnoreCase("refcursor")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String cursorName = this.getString(_columnIndex);
            StringBuilder sbu = new StringBuilder("FETCH ALL IN ");
            Utils.escapeIdentifier(sbu, cursorName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ResultSet resultSet = this.baseConnection.execSQLQuery(sbu.toString(), this._resultsettype, 1007);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.setLength(0);
            sbu.append("CLOSE ");
            Utils.escapeIdentifier(sbu, cursorName);
            this.baseConnection.execSQLUpdate(sbu.toString());
            ((PgResultSet)resultSet).setRefCursor(cursorName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return resultSet;
        }
        if ("hstore".equalsIgnoreCase(type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.isBinary_(_columnIndex)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return HStoreConverter.fromBytes(this._thisRow[_columnIndex - 1], this.baseConnection.getEncoding());
            }
            return HStoreConverter.fromString(this.getString(_columnIndex));
        }
        if ("yminterval".equalsIgnoreCase(type)) {
            if (this.isBinary_(_columnIndex)) {
                try {
                    decode = this.baseConnection.getEncoding().decode(this._thisRow[_columnIndex - 1]);
                    if (YMInterval.isYMInterval(decode)) {
                        return new YMInterval(decode);
                    }
                }
                catch (IOException e) {
                    throw new PSQLException(GT.tr("yminterval decode error.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)e);
                }
            }
            if (YMInterval.isYMInterval(s = this.getString(_columnIndex))) {
                return new YMInterval(s);
            }
        }
        if ("dsinterval".equalsIgnoreCase(type)) {
            if (this.isBinary_(_columnIndex)) {
                try {
                    decode = this.baseConnection.getEncoding().decode(this._thisRow[_columnIndex - 1]);
                    if (DSInterval.isDSInterval(decode)) {
                        return new DSInterval(decode);
                    }
                }
                catch (IOException e) {
                    throw new PSQLException(GT.tr("dsinterval decode error.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)e);
                }
            }
            if (DSInterval.isDSInterval(s = this.getString(_columnIndex))) {
                return new DSInterval(s);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public synchronized void updateTime(String _columnName, Time x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateTime(this.findColumn(_columnName), x);
    }

    private void checkScrollable_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this._resultsettype == 1003) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
    }

    protected ResultSetMetaData createMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PgResultSetMetaData(this.baseConnection, this.fieldsT);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean absolute(int _index) throws SQLException {
        int internalIndexT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.beforeFirst();
            return FALSE;
        }
        int _rows_size = this.rowsList.size();
        if (_index < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_index < -_rows_size) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.beforeFirst();
                return FALSE;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            internalIndexT = _rows_size + _index;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_index > _rows_size) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.afterLast();
                return FALSE;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            internalIndexT = _index - 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.curRowT = internalIndexT;
        this.initRowBuffer_();
        this.onInsertRowT = false;
        return TRUE;
    }

    PgResultSet(Query originalQuery, BaseStatement stmt, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_tuples == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NullPointerException("_tuples must be non-null");
        }
        if (_fields == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NullPointerException("_fields must be non-null");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.stmt = stmt;
        this.originalQuery = originalQuery;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultCursor = cursor;
        this.baseConnection = (BaseConnection)stmt.getConnection();
        this.maxRowsT = maxRows;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.maxFieldSize = maxFieldSize;
        this._resultsettype = resultSetType;
        this._resultsetconcurrency = resultSetConcurrency;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (originalQuery != null && originalQuery.hasForUpdate() && _fields[_fields.length - 1].getColumnLabel().equalsIgnoreCase("xmin") && _fields[_fields.length - 2].getColumnLabel().equalsIgnoreCase("ctid")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Field[] new_fields = new Field[_fields.length - 2];
            for (int i = 0; i < new_fields.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                new_fields[i] = _fields[i];
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ArrayList<byte[][]> new_rows = new ArrayList<byte[][]>();
            this.allPrimaryKeysOfLobList = new ArrayList<Map<String, Object>>();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int ctidIndex = this.findColumnIndex("ctid");
            int xminIndex = this.findColumnIndex("xmin");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < _tuples.size(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] _tuple = _tuples.get(i);
                byte[][] row = new byte[_tuple.length - 2][];
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                Encoding _encoding = this.baseConnection.getEncoding();
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    primaryKeys.put("ctid", this.trimString(ctidIndex, _encoding.decode(_tuple[_tuple.length - 2])));
                    primaryKeys.put("xmin", this.trimString(xminIndex, _encoding.decode(_tuple[_tuple.length - 1])));
                }
                catch (IOException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    e.printStackTrace();
                }
                this.allPrimaryKeysOfLobList.add(primaryKeys);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int j = 0; j < row.length; ++j) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    row[j] = _tuple[j];
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                new_rows.add(row);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.columnNameIndexMap.remove("ctid");
            this.columnNameIndexMap.remove("xmin");
            this.fieldsT = new_fields;
            this.rowsList = new_rows;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.fieldsT = _fields;
            this.rowsList = _tuples;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        int _rows_size = this.rowsList.size();
        if (_rows_size > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.curRowT = _rows_size;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.onInsertRowT = false;
        this._thisRow = null;
        this.rowBufferT = null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        if (!this.rowsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.curRowT = -1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.onInsertRowT = false;
        this._thisRow = null;
        this.rowBufferT = null;
    }

    @Override
    public boolean first() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        if (this.rowsList.size() <= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.curRowT = 0;
        this.initRowBuffer_();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.onInsertRowT = false;
        return TRUE;
    }

    @Override
    public Array getArray(String _colName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getArray(this.findColumn(_colName));
    }

    protected Array makeArray(int oid, byte[] _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PgArray pgArray = new PgArray(this.baseConnection, oid, _value);
        return pgArray;
    }

    protected Array makeArray(int oid, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PgArray(this.baseConnection, oid, _value);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        int oid = this.fieldsT[i - 1].getOID();
        if (this.isBinary_(i)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.makeArray(oid, this._thisRow[i - 1]);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.makeArray(oid, this.getFixedString(i));
    }

    @Override
    public BigDecimal getBigDecimal(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBigDecimal(_columnIndex, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBigDecimal(this.findColumn(_columnName));
    }

    @Override
    public Blob getBlob(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBlob(this.findColumn(_columnName));
    }

    @Override
    public synchronized void updateTimestamp(String _columnName, Timestamp x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateTimestamp(this.findColumn(_columnName), x);
    }

    protected Blob makeBlob(long oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PgBlob(this.baseConnection, oid);
    }

    protected Blob makeBlob(byte[] _buffer, PgResultSet resultSet, int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new EsBlob(_buffer, resultSet, _columnIndex);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] res = this.getBytes(i);
            if (!((PgConnection)this.baseConnection).isNullConvertEmptyLob() && res == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return null;
            }
            return this.makeBlob(res, this, i);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Blob blob = this.makeBlob(this.getLong(i));
        return blob;
    }

    @Override
    public Reader getCharacterStream(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getCharacterStream(this.findColumn(_columnName));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        CharArrayReader charArrayReader = new CharArrayReader(this.getString(i).toCharArray());
        return charArrayReader;
    }

    @Override
    public Clob getClob(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getClob(this.findColumn(_columnName));
    }

    protected Clob makeClob(long oidT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PgClob(this.baseConnection, oidT);
    }

    protected Clob makeClob(char[] _buffer, PgResultSet resultSet, int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new EsClob(_buffer, resultSet, _columnIndex, this.baseConnection.getEncoding().name());
    }

    @Override
    public Clob getClob(int index) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(index);
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str = this.getString(index);
            if (str == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((PgConnection)this.baseConnection).isNullConvertEmptyLob() ? this.makeClob(null, this, index) : null;
            }
            return this.makeClob(str.toCharArray(), this, index);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long l = this.getLong(index);
        return this.makeClob(l);
    }

    @Override
    public int getConcurrency() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this._resultsetconcurrency;
    }

    @Override
    public java.sql.Date getDate(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        if (this.isBinary_(i)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = i - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TimeZone timezone = calendar.getTimeZone();
            if (oid == 1082 || oid == 7944) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.baseConnection.getTimestampUtils().toDateBin(timezone, this._thisRow[_col]);
            }
            if (oid == 1114 || oid == 1184 || oid == 7952 || oid == 7954) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Timestamp timestamp = this.getTimestamp(i, calendar);
                return this.baseConnection.getTimestampUtils().convertToDate(timestamp.getTime(), timezone);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot convert the _column of type {0} to requested type {1}.", Oid.toString(oid), "date"), PSQLState.DATA_TYPE_MISMATCH);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        java.sql.Date date = this.baseConnection.getTimestampUtils().toDate(calendar, this.getString(i));
        return date;
    }

    @Override
    public Time getTime(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        if (this.isBinary_(i)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = i - 1;
            int oidT = this.fieldsT[_col].getOID();
            TimeZone timezone = calendar.getTimeZone();
            if (oidT == 1083 || oidT == 1266 || oidT == 7950) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.baseConnection.getTimestampUtils().toTimeBin(timezone, this._thisRow[_col]);
            }
            if (oidT == 1114 || oidT == 1184 || oidT == 7952 || oidT == 7954) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Timestamp timestampT = this.getTimestamp(i, calendar);
                long timeMillisT = timestampT.getTime();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (oidT == 1184 || oidT == 7954) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return new Time(timeMillisT % TimeUnit.DAYS.toMillis(1L));
                }
                return this.baseConnection.getTimestampUtils().convertToTime(timeMillisT, timezone);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot convert the _column of type {0} to requested type {1}.", Oid.toString(oidT), "time"), PSQLState.DATA_TYPE_MISMATCH);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String str = this.getString(i);
        Time time = this.baseConnection.getTimestampUtils().toTime(calendar, str);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(i);
        if (this.wasNullFlagT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        int _col = i - 1;
        int oid = this.fieldsT[_col].getOID();
        if (this.isBinary_(i)) {
            long millisecs;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (oid == 1184 || oid == 1114 || oid == 7952 || oid == 7954) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                boolean hasTimeZone = 1184 == oid || 7954 == oid;
                TimeZone timezone = calendar.getTimeZone();
                Timestamp timestamp = this.baseConnection.getTimestampUtils().toTimestampBin(timezone, this._thisRow[_col], hasTimeZone);
                return timestamp;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (oid == 1083 || oid == 1266 || oid == 7950) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                millisecs = this.getTime(i, calendar).getTime();
            } else if (oid == 1082 || oid == 7944) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                millisecs = this.getDate(i, calendar).getTime();
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PSQLException ksqlException = new PSQLException(GT.tr("Cannot convert the _column of type {0} to requested type {1}.", Oid.toString(oid), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
                throw ksqlException;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(millisecs);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String str = this.getString(i);
        if (oid == 1083 || oid == 1266 || oid == 7950) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(this.baseConnection.getTimestampUtils().toTime(calendar, str).getTime());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.baseConnection.getTimestampUtils().toTimestamp(calendar, str);
    }

    @Override
    public java.sql.Date getDate(String c, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getDate(this.findColumn(c), calendar);
    }

    @Override
    public Time getTime(String c, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTime(this.findColumn(c), calendar);
    }

    @Override
    public Timestamp getTimestamp(String c, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTimestamp(this.findColumn(c), calendar);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        int fInt = this.fetchdirection;
        return fInt;
    }

    public Object getObjectImpl(String _columnName, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object objectImpl = this.getObjectImpl(this.findColumn(_columnName), map);
        return objectImpl;
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (map == null || map.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getObject(i);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
        throw e;
    }

    @Override
    public Ref getRef(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getRef(this.findColumn(_columnName));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getRef(int)");
        throw e;
    }

    @Override
    public int getRow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ZERO;
        }
        int _rows_size = this.rowsList.size();
        if (this.curRowT < 0 || this.curRowT >= _rows_size) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ZERO;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowOffsetT + this.curRowT + 1;
    }

    @Override
    public Statement getStatement() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this.stmt;
    }

    @Override
    public int getType() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this._resultsettype;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        int _rows_size = this.rowsList.size();
        if (this.rowOffsetT + _rows_size == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        boolean b = this.curRowT >= _rows_size;
        return b;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        boolean b = this.rowOffsetT + this.curRowT < 0 && !this.rowsList.isEmpty();
        return b;
    }

    @Override
    public boolean isFirst() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        int _rows_size = this.rowsList.size();
        if (this.rowOffsetT + _rows_size == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowOffsetT + this.curRowT == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        int _rows_size = this.rowsList.size();
        if (_rows_size == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        if (this.curRowT != _rows_size - 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        if (this.resultCursor == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return TRUE;
        }
        if (this.maxRowsT > 0 && this.rowOffsetT + this.curRowT == this.maxRowsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return TRUE;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowOffsetT += _rows_size - 1;
        int _fetchRows = this.fetchSize;
        if (this.maxRowsT != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_fetchRows == 0 || this.rowOffsetT + _fetchRows > this.maxRowsT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _fetchRows = this.maxRowsT - this.rowOffsetT;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection.getQueryExecutor().fetch(this.resultCursor, new CursorResultHandler(), _fetchRows);
        this.rowsList.add(0, this._thisRow);
        this.curRowT = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowsList.size() == 1;
    }

    @Override
    public boolean last() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        int _rows_size = this.rowsList.size();
        if (_rows_size <= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return FALSE;
        }
        this.curRowT = _rows_size - 1;
        this.initRowBuffer_();
        this.onInsertRowT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return TRUE;
    }

    @Override
    public boolean previous() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Can''t use relative move mtds while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.curRowT - 1 < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.curRowT = -1;
            this._thisRow = null;
            this.rowBufferT = null;
            return FALSE;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        --this.curRowT;
        this.initRowBuffer_();
        return TRUE;
    }

    @Override
    public boolean relative(int _rows) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkScrollable_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Can''t use relative move mtds while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _index = this.curRowT + 1 + _rows;
        if (_index < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.beforeFirst();
            return FALSE;
        }
        boolean absolute = this.absolute(_index);
        return absolute;
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot call cancelRowUpdates() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.doingUpdatesT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.doingUpdatesT = false;
            boolean copyCurrentRow = true;
            this.clearRowBuffer_(copyCurrentRow);
        }
    }

    @Override
    public void setFetchDirection(int directionT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (directionT == 1002 || directionT == 1001) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkScrollable_();
        } else if (directionT == 1000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", directionT), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        this.fetchdirection = directionT;
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot call deleteRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.isBeforeFirst()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Currently posed before the start of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.isAfterLast()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Currently posed after the end of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.rowsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("There are no _rows in this ResultSet.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        int numKeysT = this.primaryKeysList.size();
        if (this.deleteStatementT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String whererStr = " where ";
            StringBuilder deleteSQL_SB = new StringBuilder("DELETE FROM ").append(this.onlyTableT).append(this.tablName).append(" where ");
            for (int j = 0; j < numKeysT; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Utils.escapeIdentifier(deleteSQL_SB, this.primaryKeysList.get((int)j).name);
                deleteSQL_SB.append(" = ?");
                if (j >= numKeysT - 1) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                deleteSQL_SB.append(" and ");
            }
            this.deleteStatementT = this.baseConnection.prepareStatement(deleteSQL_SB.toString());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.deleteStatementT.clearParameters();
        for (int j = 0; j < numKeysT; ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.deleteStatementT.setObject(j + 1, this.primaryKeysList.get(j).getValue());
        }
        this.deleteStatementT.executeUpdate();
        this.rowsList.remove(this.curRowT);
        --this.curRowT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.moveToCurrentRow();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (!this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Not on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.updateValuesMap.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("You must specify at least one _column _value to insert a row.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder insertSQL_SB = new StringBuilder("INSERT INTO ").append(this.tablName).append(" (");
        StringBuilder _paramSQL = new StringBuilder(") values (");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Iterator<String> _columnNames = this.updateValuesMap.keySet().iterator();
        int numColumns = this.updateValuesMap.size();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i = 0;
        while (_columnNames.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _columnName = _columnNames.next();
            Utils.escapeIdentifier(insertSQL_SB, _columnName);
            if (i < numColumns - 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                insertSQL_SB.append(", ");
                _paramSQL.append("?,");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _paramSQL.append("?)");
            }
            ++i;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        insertSQL_SB.append(_paramSQL.toString());
        this.insertStatementT = this.baseConnection.prepareStatement(insertSQL_SB.toString());
        Iterator<Object> valuesIterator = this.updateValuesMap.values().iterator();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i2 = 1;
        while (valuesIterator.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.insertStatementT.setObject(i2, valuesIterator.next());
            ++i2;
        }
        this.insertStatementT.executeUpdate();
        if (this.usingOIDT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long insertedOID = ((PgStatement)((Object)this.insertStatementT)).getLastOID();
            this.updateValuesMap.put("oid", insertedOID);
        }
        this.updateRowBuffer();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowsList.add(this.rowBufferT);
        this._thisRow = this.rowBufferT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.clearRowBuffer_(false);
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (this.curRowT < 0 || this.curRowT >= this.rowsList.size()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._thisRow = null;
            this.rowBufferT = null;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.initRowBuffer_();
        }
        this.doingUpdatesT = false;
        this.onInsertRowT = false;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (this.insertStatementT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.insertStatementT = null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.clearRowBuffer_(false);
        this.doingUpdatesT = false;
        this.onInsertRowT = true;
    }

    private synchronized void clearRowBuffer_(boolean copyCurrentRowT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowBufferT = new byte[this.fieldsT.length][];
        if (copyCurrentRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.arraycopy(this._thisRow, 0, this.rowBufferT, 0, this._thisRow.length);
        }
        this.updateValuesMap.clear();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return FALSE;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return FALSE;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return FALSE;
    }

    @Override
    public synchronized void updateAsciiStream(int _columnIndex, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateNull(_columnIndex);
            return;
        }
        try {
            int numOfRead;
            char[] data;
            block6: {
                int n;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                InputStreamReader reader = new InputStreamReader(x, "ASCII");
                data = new char[length];
                numOfRead = 0;
                do {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    n = reader.read(data, numOfRead, length - numOfRead);
                    if (n == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        break block6;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } while ((numOfRead += n) != length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            this.updateString(_columnIndex, new String(data, 0, numOfRead));
        }
        catch (UnsupportedEncodingException uee) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("The JVM claims not to support the _encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
            throw ksqlException;
        }
        catch (IOException ie) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)ie);
            throw ksqlException;
        }
    }

    @Override
    public synchronized void updateBigDecimal(int _columnIndex, BigDecimal x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int _columnIndex, InputStream x, int length) throws SQLException {
        int numOfRead;
        byte[] data;
        block7: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (x == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.updateNull(_columnIndex);
                return;
            }
            data = new byte[length];
            numOfRead = 0;
            try {
                int n;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                do {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    n = x.read(data, numOfRead, length - numOfRead);
                    if (n == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        break block7;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } while ((numOfRead += n) != length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            catch (IOException ie) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PSQLException ksqlException = new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)ie);
                throw ksqlException;
            }
        }
        if (numOfRead == length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateBytes(_columnIndex, data);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] data2 = new byte[numOfRead];
            System.arraycopy(data, 0, data2, 0, numOfRead);
            this.updateBytes(_columnIndex, data2);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int _columnIndex, Reader x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateNull(_columnIndex);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int numOfRead;
            char[] data;
            block5: {
                int n;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                data = new char[length];
                numOfRead = 0;
                do {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    n = x.read(data, numOfRead, length - numOfRead);
                    if (n == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        break block5;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } while ((numOfRead += n) != length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateString(_columnIndex, new String(data, 0, numOfRead));
        }
        catch (IOException ie) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), null, (Throwable)ie);
            throw ksqlException;
        }
    }

    @Override
    public synchronized void updateObject(int _columnIndex, Object x, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateObject(_columnIndex, x);
    }

    @Override
    public void refreshRow() throws SQLException {
        PreparedStatement tmpPreparedStatement;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Can''t refresh the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rowsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        StringBuilder selectSQL_SB = new StringBuilder("select ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSetMetaData resultSetmd = this.getMetaData();
        PGResultSetMetaData resultSetMetaData2 = (PGResultSetMetaData)((Object)resultSetmd);
        for (int i = 1; i <= resultSetmd.getColumnCount(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                selectSQL_SB.append(", ");
            }
            Utils.escapeIdentifier(selectSQL_SB, resultSetMetaData2.getBaseColumnName(i));
        }
        selectSQL_SB.append(" from ").append(this.onlyTableT).append(this.tablName).append(" where ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numKeysT = this.primaryKeysList.size();
        for (int j = 0; j < numKeysT; ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PrimaryKey primaryKeyT = this.primaryKeysList.get(j);
            Utils.escapeIdentifier(selectSQL_SB, primaryKeyT.name);
            selectSQL_SB.append("= ?");
            if (j >= numKeysT - 1) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectSQL_SB.append(" and ");
        }
        String _sqlText = selectSQL_SB.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "selecting {0}", _sqlText);
        }
        this.selectStatementT = tmpPreparedStatement = this.baseConnection.prepareStatement(_sqlText, 1004, 1008);
        int j = 0;
        int i = 1;
        while (j < numKeysT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.selectStatementT.setObject(i, this.primaryKeysList.get(j).getValue());
            ++j;
            ++i;
        }
        PgResultSet resultSet = (PgResultSet)this.selectStatementT.executeQuery();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rowBufferT = resultSet._thisRow;
        }
        this.rowsList.set(this.curRowT, this.rowBufferT);
        this._thisRow = this.rowBufferT;
        LOGGER.log(Level.FINE, "done updates", new Object[0]);
        resultSet.close();
        this.selectStatementT.close();
        Object p = null;
        this.selectStatementT = p;
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        PreparedStatement tmpPreparedStatement;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (this.onInsertRowT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot call updateRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rowsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the _results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (!this.doingUpdatesT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        StringBuilder updateSQL_SB = new StringBuilder("UPDATE " + this.onlyTableT + this.tablName + " SET  ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numColumns = this.updateValuesMap.size();
        Iterator<String> _columns = this.updateValuesMap.keySet().iterator();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i = 0;
        while (_columns.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _column = _columns.next();
            Utils.escapeIdentifier(updateSQL_SB, _column);
            updateSQL_SB.append(" = ?");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i < numColumns - 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                updateSQL_SB.append(", ");
            }
            ++i;
        }
        updateSQL_SB.append(" WHERE ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numKeysT = this.primaryKeysList.size();
        boolean hasCTID = false;
        boolean hasXMIN = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i2 = 0; i2 < numKeysT; ++i2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PrimaryKey primaryKeyT = this.primaryKeysList.get(i2);
            if (primaryKeyT.name.equalsIgnoreCase("ctid")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                hasCTID = true;
            } else if (primaryKeyT.name.equalsIgnoreCase("xmin")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                hasXMIN = true;
            }
            Utils.escapeIdentifier(updateSQL_SB, primaryKeyT.name);
            updateSQL_SB.append(" = ?");
            if (i2 >= numKeysT - 1) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            updateSQL_SB.append(" and ");
        }
        if (hasCTID && hasXMIN) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            updateSQL_SB.append(" returning ctid,xmin");
        }
        String _sqlText = updateSQL_SB.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "updating {0}", _sqlText);
        }
        int i3 = 0;
        this.updateStatementT = tmpPreparedStatement = this.baseConnection.prepareStatement(_sqlText);
        Iterator<Object> objectIterator = this.updateValuesMap.values().iterator();
        while (objectIterator.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Object o = objectIterator.next();
            int tIndex = i3 + 1;
            this.updateStatementT.setObject(tIndex, o);
            ++i3;
        }
        int j = 0;
        while (j < numKeysT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateStatementT.setObject(i3 + 1, this.primaryKeysList.get(j).getValue());
            ++j;
            ++i3;
        }
        this.updateStatementT.execute();
        if (hasCTID && hasXMIN) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ResultSet resultSet = this.updateStatementT.getResultSet();
            if (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int j2 = 0; j2 < this.fieldsT.length; ++j2) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.fieldsT[j2].getColumnLabel().equalsIgnoreCase("ctid")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.rowBufferT[j2] = resultSet.getBytes(1);
                    }
                    if (!this.fieldsT[j2].getColumnLabel().equalsIgnoreCase("xmin")) continue;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.rowBufferT[j2] = resultSet.getBytes(2);
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateStatementT.close();
        this.updateStatementT = null;
        this.updateRowBuffer();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINE, "copying data", new Object[0]);
        System.arraycopy(this.rowBufferT, 0, this._thisRow, 0, this.rowBufferT.length);
        this.rowsList.set(this.curRowT, this.rowBufferT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINE, "done updates", new Object[0]);
        this.doingUpdatesT = false;
        this.updateValuesMap.clear();
    }

    @Override
    public synchronized void updateString(int _columnIndex, String x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int _columnIndex, Time x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int _columnIndex, Timestamp x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateObject(String _columnName, Object x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateObject(this.findColumn(_columnName), x);
    }

    public static String[] quotelessTableName(String fullnameT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String[] partsT = new String[]{null, ""};
        StringBuilder stringBuilder = new StringBuilder();
        boolean betweenQuotesT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block4: for (int i = 0; i < fullnameT.length(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char cT = fullnameT.charAt(i);
            switch (cT) {
                case '\"': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (i < fullnameT.length() - 1 && fullnameT.charAt(i + 1) == '\"') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++i;
                        stringBuilder.append(cT);
                        continue block4;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    betweenQuotesT = !betweenQuotesT;
                    continue block4;
                }
                case '.': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (betweenQuotesT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        stringBuilder.append(cT);
                        continue block4;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    partsT[1] = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    continue block4;
                }
                default: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    stringBuilder.append(betweenQuotesT ? cT : Character.toLowerCase(cT));
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        partsT[0] = stringBuilder.toString();
        return partsT;
    }

    boolean isUpdateable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this._resultsetconcurrency == 1007) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        if (this.updateableT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return TRUE;
        }
        LOGGER.log(Level.FINE, "checking if resultSet is updateable", new Object[0]);
        this.parseQuery();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.singleTableT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "not a single table", new Object[0]);
            return FALSE;
        }
        LOGGER.log(Level.FINE, "getting primary keys", new Object[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.primaryKeysList = new ArrayList<PrimaryKey>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.usingOIDT = false;
        int oidIndexT = this.findColumnIndex("oid");
        int ctidIndex = 0;
        int xminIndex = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean existInternalRID = false;
        ctidIndex = this.findColumnIndex("ctid");
        xminIndex = this.findColumnIndex("xmin");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (ctidIndex > 0 && xminIndex > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            existInternalRID = true;
        }
        int j = 0;
        int numPK_columns = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oidIndexT > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++j;
            ++numPK_columns;
            this.primaryKeysList.add(new PrimaryKey(oidIndexT, "oid"));
            this.usingOIDT = true;
        } else if (existInternalRID) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++j;
            ++numPK_columns;
            this.primaryKeysList.add(new PrimaryKey(ctidIndex, "ctid"));
            ++j;
            ++numPK_columns;
            this.primaryKeysList.add(new PrimaryKey(xminIndex, "xmin"));
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String[] str = PgResultSet.quotelessTableName(this.tablName);
            String quotelessSchemaNameT = str[1];
            String quotelessTableNameT = str[0];
            ResultSet resultSet = this.baseConnection.getMetaData().getPrimaryKeys("", quotelessSchemaNameT, quotelessTableNameT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++numPK_columns;
                String _columnName = resultSet.getString(4);
                int _index = this.findColumnIndex(_columnName);
                if (_index <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++j;
                this.primaryKeysList.add(new PrimaryKey(_index, _columnName));
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet.close();
        }
        LOGGER.log(Level.FINE, "no of keys={0}", j);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (j < 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("No primary _key found for table {0}.", this.tablName), PSQLState.DATA_ERROR);
            throw ksqlException;
        }
        this.updateableT = j == numPK_columns;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINE, "checking primary _key {0}", this.updateableT);
        return this.updateableT;
    }

    private void parseQuery() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sqlStr = this.originalQuery.toString(null);
        StringTokenizer stringTokenizer = new StringTokenizer(sqlStr, " \r\t\n");
        String nameStr = "";
        boolean isTablesChecked = false;
        this.singleTableT = true;
        boolean isTableFound = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (!isTablesChecked && stringTokenizer.hasMoreTokens() && !isTableFound) {
            boolean b;
            nameStr = stringTokenizer.nextToken();
            if (!"from".equalsIgnoreCase(nameStr)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.tablName = stringTokenizer.nextToken();
            if ("only".equalsIgnoreCase(this.tablName)) {
                this.tablName = stringTokenizer.nextToken();
                this.onlyTableT = "ONLY ";
            }
            isTableFound = b = true;
        }
    }

    private void updateRowBuffer() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block9: for (Map.Entry<String, Object> entry : this.updateValuesMap.entrySet()) {
            int tmpint = 1;
            Object _valueObject = entry.getValue();
            int _columnIndex = this.findColumn(entry.getKey()) - tmpint;
            if (_valueObject instanceof PGobject) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _value = ((PGobject)_valueObject).getValue();
                if (_value == null) {
                    this.rowBufferT[_columnIndex] = null;
                    continue;
                }
                this.rowBufferT[_columnIndex] = this.baseConnection._encodeString(_value);
                continue;
            }
            int sqlType = this.getSQLType(_columnIndex + 1);
            switch (sqlType) {
                case 91: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.rowBufferT[_columnIndex] = this.baseConnection._encodeString(this.baseConnection.getTimestampUtils().toString(this.getDefaultCalendar(), (java.sql.Date)_valueObject));
                    continue block9;
                }
                case 92: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.rowBufferT[_columnIndex] = this.baseConnection._encodeString(this.baseConnection.getTimestampUtils().toString(this.getDefaultCalendar(), (Time)_valueObject));
                    continue block9;
                }
                case 0: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue block9;
                }
                case 93: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel()) && _valueObject instanceof java.sql.Date) {
                        _valueObject = new Timestamp(((java.sql.Date)_valueObject).getTime());
                    }
                    this.rowBufferT[_columnIndex] = this.baseConnection._encodeString(this.baseConnection.getTimestampUtils().toString(this.getDefaultCalendar(), (Timestamp)_valueObject));
                    continue block9;
                }
                case -4: 
                case -3: 
                case -2: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.isBinary_(_columnIndex + 1)) {
                        byte[] tmpBytes = (byte[])_valueObject;
                        this.rowBufferT[_columnIndex] = tmpBytes;
                        continue block9;
                    }
                    try {
                        this.rowBufferT[_columnIndex] = PGbytea.toPGString((byte[])_valueObject).getBytes("ISO-8859-1");
                        continue block9;
                    }
                    catch (UnsupportedEncodingException e) {
                        PSQLException ksqlException = new PSQLException(GT.tr("The JVM claims not to support the _encoding: {0}", "ISO-8859-1"), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
                        throw ksqlException;
                    }
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rowBufferT[_columnIndex] = this.baseConnection._encodeString(String.valueOf(_valueObject));
        }
    }

    public BaseStatement getPGStatement() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.stmt;
    }

    @Override
    public String getRefCursor() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.refCursorNameT;
    }

    private void setRefCursor(String refCursorName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.refCursorNameT = refCursorName;
    }

    @Override
    public int getFetchSize() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int _rows) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (_rows < 0) {
            PSQLException ksqlException = new PSQLException(GT.tr("Fetch size must be a _value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        this.fetchSize = _rows;
    }

    @Override
    public boolean next() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this.onInsertRowT) {
            PSQLException ksqlException = new PSQLException(GT.tr("Can''t use relative move mtds while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.curRowT + 1 >= this.rowsList.size()) {
            if (this.resultCursor == null || this.maxRowsT > 0 && this.rowOffsetT + this.rowsList.size() >= this.maxRowsT) {
                this.rowBufferT = null;
                this.curRowT = this.rowsList.size();
                this._thisRow = null;
                return FALSE;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rowOffsetT += this.rowsList.size();
            int _fetchRows = this.fetchSize;
            if (this.maxRowsT != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_fetchRows == 0 || this.rowOffsetT + _fetchRows > this.maxRowsT) {
                    _fetchRows = this.maxRowsT - this.rowOffsetT;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.baseConnection.getQueryExecutor().fetch(this.resultCursor, new CursorResultHandler(), _fetchRows);
            this.curRowT = 0;
            if (this.rowsList.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._thisRow = null;
                this.rowBufferT = null;
                return FALSE;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++this.curRowT;
        }
        this.initRowBuffer_();
        return TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.closeInternally();
        }
        finally {
            ((PgStatement)this.stmt).checkCompletion();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this.wasNullFlagT;
    }

    protected void closeInternally() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowsList = null;
        if (this.resultCursor != null) {
            this.resultCursor.close();
            this.resultCursor = null;
        }
    }

    @Override
    public String getString(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getString _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isBinary_(_columnIndex) && this.getSQLType(_columnIndex) != 12 && this.getSQLType(_columnIndex) != -1) {
            Field _field = this.fieldsT[_columnIndex - 1];
            Object objt = this.internalGetObject(_columnIndex, _field);
            if (null == objt) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                objt = this.getObject(_columnIndex);
                if (objt == null) {
                    return null;
                }
                return objt.toString();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (objt instanceof Date) {
                int oid = _field.getOID();
                long timeNanoSecond = 0L;
                if (this.getSQLType(_columnIndex) == 92) {
                    timeNanoSecond = this.baseConnection.getTimestampUtils().getTimeNanoSecond(this._thisRow[_columnIndex - 1]);
                }
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    return this.baseConnection.getTimestampUtils().timeToString((Date)objt, oid == 7954 || oid == 7950, timeNanoSecond);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.baseConnection.getTimestampUtils().timeToString((Date)objt, oid == 1184 || oid == 1266, timeNanoSecond);
            }
            if ("hstore".equals(this.getPGType(_columnIndex))) {
                return HStoreConverter.toString((Map)objt);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.trimString(_columnIndex, objt.toString());
        }
        Encoding _encoding = this.baseConnection.getEncoding();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String decode = _encoding.decode(this._thisRow[_columnIndex - 1]);
            String pgType = this.getPGType(_columnIndex);
            if ("yminterval".equalsIgnoreCase(pgType) || "dsinterval".equalsIgnoreCase(pgType)) {
                if ("yminterval".equalsIgnoreCase(pgType) && YMInterval.isYMInterval(decode)) {
                    decode = new YMInterval(decode).toString();
                } else if ("dsinterval".equalsIgnoreCase(pgType) && DSInterval.isDSInterval(decode)) {
                    decode = new DSInterval(decode).toString();
                }
            }
            return this.trimString(_columnIndex, decode);
        }
        catch (IOException ioe) {
            PSQLException ksqlException = new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
            throw ksqlException;
        }
    }

    @Override
    public boolean getBoolean(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getBoolean _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return FALSE;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _col = _columnIndex - 1;
        if (this.fieldsT[_col].getOID() == 16) {
            byte[] v = this._thisRow[_col];
            boolean b = 1 == v.length && 116 == v[0];
            return b;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isBinary_(_columnIndex)) {
            return BooleanTypeUtil.castToBoolean(this.readDoubleValue(this._thisRow[_col], this.fieldsT[_col].getOID(), "boolean"), this.baseConnection.getCompatibleLevel());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = BooleanTypeUtil.castToBoolean(this.getString(_columnIndex), this.baseConnection.getCompatibleLevel());
        return b;
    }

    public static byte toByte(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                if (str.isEmpty()) {
                    return (byte)ZERO;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Byte.parseByte(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal nT = new BigDecimal(str);
                    BigInteger iT = nT.toBigInteger();
                    int ltNum = iT.compareTo(BYTEMIN);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int gtNum = iT.compareTo(BYTEMAX);
                    if (ltNum < 0 || gtNum > 0) {
                        PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "byte", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                        throw ksqlException;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return iT.byteValue();
                }
                catch (NumberFormatException numberFormatException1) {
                    PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "byte", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    throw ksqlException;
                }
            }
        }
        return (byte)ZERO;
    }

    @Override
    public byte getByte(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getByte _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return (byte)ZERO;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = _columnIndex - 1;
            long aByte = this.readLongValue(this._thisRow[_col], this.fieldsT[_col].getOID(), -128L, 127L, "byte");
            return (byte)aByte;
        }
        String str = this.getString(_columnIndex);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            if ("f".equalsIgnoreCase(str = str.trim()) || "false".equalsIgnoreCase(str)) {
                return 0;
            }
            if ("t".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str)) {
                return 1;
            }
            if (str.isEmpty()) {
                return (byte)ZERO;
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Byte.parseByte(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    BigDecimal nT = new BigDecimal(str);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    BigInteger iT = nT.toBigInteger();
                    int ltT = iT.compareTo(BYTEMIN);
                    int gtT = iT.compareTo(BYTEMAX);
                    if (ltT < 0 || gtT > 0) {
                        PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "byte", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                        throw ksqlException;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return iT.byteValue();
                }
                catch (NumberFormatException numberFormatException1) {
                    PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "byte", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    throw ksqlException;
                }
            }
        }
        return (byte)ZERO;
    }

    @Override
    public short getShort(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getShort _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return (short)ZERO;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isBinary_(_columnIndex)) {
            int _col = _columnIndex - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (21 == oid) {
                return ByteConverter.int2(this._thisRow[_col], 0);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (short)this.readLongValue(this._thisRow[_col], oid, -32768L, 32767L, "short");
        }
        short toShort = PgResultSet.toShort(this.getFixedString(_columnIndex));
        return toShort;
    }

    @Override
    public int getInt(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getInt _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return ZERO;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = _columnIndex - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (23 == oid) {
                return ByteConverter.int4(this._thisRow[_col], 0);
            }
            long anInt = this.readLongValue(this._thisRow[_col], oid, Integer.MIN_VALUE, Integer.MAX_VALUE, "int");
            return (int)anInt;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Encoding _encoding = this.baseConnection.getEncoding();
        if (_encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(_columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PgResultSet.toInt(this.getFixedString(_columnIndex));
    }

    @Override
    public long getLong(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getLong _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return ZERO;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = _columnIndex - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (oid == 20) {
                return ByteConverter.int8(this._thisRow[_col], 0);
            }
            long aLong = this.readLongValue(this._thisRow[_col], oid, Long.MIN_VALUE, Long.MAX_VALUE, "long");
            return aLong;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Encoding _encoding = this.baseConnection.getEncoding();
        if (_encoding.hasAsciiNumbers()) {
            try {
                return this.getFastLong(_columnIndex);
            }
            catch (NumberFormatException oid) {
                // empty catch block
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long toLong = PgResultSet.toLong(this.getFixedString(_columnIndex));
        return toLong;
    }

    private long getFastLong(int _columnIndex) throws SQLException, NumberFormatException {
        int startT;
        boolean negT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _bytes = this._thisRow[_columnIndex - 1];
        if (_bytes.length == 0) {
            throw FAST_NUMBER_FAILED_EXCEPTION;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long valueT = 0L;
        if (_bytes[0] == 45) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            negT = true;
            startT = 1;
            if (_bytes.length == 1 || _bytes.length > 19) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            startT = 0;
            negT = false;
            if (_bytes.length > 18) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        }
        while (startT < _bytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte aByte = _bytes[startT++];
            if (aByte > 57 || aByte < 48) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
            valueT *= 10L;
            valueT += (long)(aByte - 48);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (negT) {
            valueT = -valueT;
        }
        return valueT;
    }

    private int getFastInt(int _columnIndex) throws SQLException, NumberFormatException {
        int startT;
        boolean negT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _bytes = this._thisRow[_columnIndex - 1];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length == 0) {
            throw FAST_NUMBER_FAILED_EXCEPTION;
        }
        int valueT = 0;
        byte s1 = 45;
        if (_bytes[0] == s1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            negT = true;
            startT = 1;
            if (_bytes.length == 1 || _bytes.length > 10) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            startT = 0;
            negT = false;
            if (_bytes.length > 9) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        }
        while (startT < _bytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte aByte = _bytes[startT++];
            if (aByte > 57 || aByte < 48) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
            valueT *= 10;
            valueT += aByte - 48;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (negT) {
            valueT = -valueT;
        }
        return valueT;
    }

    private BigDecimal getFastBigDecimal(int _columnIndex) throws SQLException, NumberFormatException {
        int startT;
        boolean negT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _bytes = this._thisRow[_columnIndex - 1];
        if (_bytes.length == 0) {
            throw FAST_NUMBER_FAILED_EXCEPTION;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int scaleT = 0;
        long valueT = 0L;
        if (_bytes[0] == 45) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            negT = true;
            startT = 1;
            if (_bytes.length == 1 || _bytes.length > 19) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            startT = 0;
            negT = false;
            if (_bytes.length > 18) {
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
        }
        int periodsSeenT = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (startT < _bytes.length) {
            byte aByte;
            if ((aByte = _bytes[startT++]) > 57 || aByte < 48) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (aByte == 46) {
                    scaleT = _bytes.length - startT;
                    ++periodsSeenT;
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw FAST_NUMBER_FAILED_EXCEPTION;
            }
            valueT *= 10L;
            valueT += (long)(aByte - 48);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numNonSignChars = negT ? _bytes.length - 1 : _bytes.length;
        if (periodsSeenT == numNonSignChars || periodsSeenT > 1) {
            throw FAST_NUMBER_FAILED_EXCEPTION;
        }
        if (negT) {
            valueT = -valueT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return BigDecimal.valueOf(valueT, scaleT);
    }

    @Override
    public float getFloat(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getFloat _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return ZERO;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isBinary_(_columnIndex)) {
            int _col = _columnIndex - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (700 == oid) {
                return ByteConverter.float4(this._thisRow[_col], 0);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double readDoubleValue = this.readDoubleValue(this._thisRow[_col], oid, "float");
            return (float)readDoubleValue;
        }
        float toFloat = PgResultSet.toFloat(this.getFixedString(_columnIndex));
        return toFloat;
    }

    @Override
    public double getDouble(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getDouble _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return ZERO;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _col = _columnIndex - 1;
            int oid = this.fieldsT[_col].getOID();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (701 == oid) {
                return ByteConverter.float8(this._thisRow[_col], 0);
            }
            double aDouble = this.readDoubleValue(this._thisRow[_col], oid, "double");
            return aDouble;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        double toDouble = PgResultSet.toDouble(this.getFixedString(_columnIndex));
        return toDouble;
    }

    @Override
    public BigDecimal getBigDecimal(int _columnIndex, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getBigDecimal _columnIndex: {0}", _columnIndex);
        Number numeric_ = this.getNumeric_(_columnIndex, scale, false);
        return (BigDecimal)numeric_;
    }

    private Number getNumeric_(int _columnIndex, int scaleT, boolean allowNaNT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _sqlType = this.getSQLType(_columnIndex);
            if (_sqlType != 3 && _sqlType != 2) {
                Object objt = this.internalGetObject(_columnIndex, this.fieldsT[_columnIndex - 1]);
                Number number = null;
                if (null == objt) {
                    return number;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (objt instanceof Byte || objt instanceof Long || objt instanceof Integer) {
                    BigDecimal resT = BigDecimal.valueOf(((Number)objt).longValue());
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resT = this.scaleBigDecimal(resT, scaleT);
                    return resT;
                }
                BigDecimal bigDecimal = this.toBigDecimal(this.trimMoney(String.valueOf(objt)), scaleT);
                return bigDecimal;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Number numT = ByteConverter.numeric(this._thisRow[_columnIndex - 1]);
            if (Double.isNaN(numT.doubleValue()) && allowNaNT) {
                Double d = Double.NaN;
                return d;
            }
            return numT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Encoding _encoding = this.baseConnection.getEncoding();
        if (_encoding.hasAsciiNumbers()) {
            try {
                BigDecimal resT = this.getFastBigDecimal(_columnIndex);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resT = this.scaleBigDecimal(resT, scaleT);
                return resT;
            }
            catch (NumberFormatException resT) {
                // empty catch block
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String stringValueT = this.getFixedString(_columnIndex);
        if ("NaN".equalsIgnoreCase(stringValueT) && allowNaNT) {
            Double d = Double.NaN;
            return d;
        }
        BigDecimal bigDecimal = this.toBigDecimal(stringValueT, scaleT);
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getBytes _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isBinary_(_columnIndex)) {
            return this._thisRow[_columnIndex - 1];
        }
        if (this.fieldsT[_columnIndex - 1].getOID() == 17 || this.fieldsT[_columnIndex - 1].getOID() == 8013) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] bytes = this.trimBytes(_columnIndex, PGbytea.toBytes(this._thisRow[_columnIndex - 1]));
            return bytes;
        }
        byte[] bytes = this.trimBytes(_columnIndex, this._thisRow[_columnIndex - 1]);
        return bytes;
    }

    @Override
    public java.sql.Date getDate(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getDate _columnIndex: {0}", _columnIndex);
        java.sql.Date date = this.getDate(_columnIndex, null);
        return date;
    }

    @Override
    public Time getTime(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getTime _columnIndex: {0}", _columnIndex);
        Time time = this.getTime(_columnIndex, null);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getTimestamp _columnIndex: {0}", _columnIndex);
        Timestamp timestamp = this.getTimestamp(_columnIndex, null);
        return timestamp;
    }

    @Override
    public InputStream getAsciiStream(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getAsciiStream _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        try {
            if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new ByteArrayInputStream(this.getBytes(_columnIndex));
            }
            return new ByteArrayInputStream(this.getString(_columnIndex).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException l_uee) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("The JVM claims not to support the _encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            throw ksqlException;
        }
    }

    @Override
    public InputStream getUnicodeStream(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getUnicodeStream _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                return new ByteArrayInputStream(this.getBytes(_columnIndex));
            }
            return new ByteArrayInputStream(this.getString(_columnIndex).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException l_uee) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("The JVM claims not to support the _encoding: {0}", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            throw ksqlException;
        }
    }

    @Override
    public InputStream getBinaryStream(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getBinaryStream _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] b = this.getBytes(_columnIndex);
        if (b != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new ByteArrayInputStream(b);
        }
        InputStream inputStream = null;
        return inputStream;
    }

    @Override
    public String getString(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getString(this.findColumn(_columnName));
    }

    @Override
    public boolean getBoolean(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBoolean(this.findColumn(_columnName));
    }

    @Override
    public byte getByte(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getByte(this.findColumn(_columnName));
    }

    @Override
    public short getShort(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getShort(this.findColumn(_columnName));
    }

    @Override
    public int getInt(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getInt(this.findColumn(_columnName));
    }

    @Override
    public long getLong(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLong(this.findColumn(_columnName));
    }

    @Override
    public float getFloat(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getFloat(this.findColumn(_columnName));
    }

    @Override
    public double getDouble(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getDouble(this.findColumn(_columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String _columnName, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBigDecimal(this.findColumn(_columnName), scale);
    }

    @Override
    public byte[] getBytes(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBytes(this.findColumn(_columnName));
    }

    @Override
    public java.sql.Date getDate(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getDate(this.findColumn(_columnName), null);
    }

    @Override
    public Time getTime(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTime(this.findColumn(_columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getTimestamp(this.findColumn(_columnName), null);
    }

    @Override
    public InputStream getAsciiStream(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getAsciiStream(this.findColumn(_columnName));
    }

    @Override
    public InputStream getUnicodeStream(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getUnicodeStream(this.findColumn(_columnName));
    }

    @Override
    public InputStream getBinaryStream(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBinaryStream(this.findColumn(_columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return this._warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this._warnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        return null;
    }

    protected void addWarning(SQLWarning _warnings) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null != this._warnings) {
            this._warnings.setNextWarning(_warnings);
        } else {
            this._warnings = _warnings;
        }
    }

    @Override
    public Object getObject(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getObject _columnIndex: {0}", _columnIndex);
        this.checkResultSet_(_columnIndex);
        if (this.wasNullFlagT) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.fieldsT[_columnIndex - 1];
        if (_field == null) {
            this.wasNullFlagT = true;
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object _result = this.internalGetObject(_columnIndex, _field);
        if (_result != null) {
            return _result;
        }
        if (this.isBinary_(_columnIndex)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Object object = this.baseConnection.getObject(this.getPGType(_columnIndex), null, this._thisRow[_columnIndex - 1]);
            return object;
        }
        Object object = this.baseConnection.getObject(this.getPGType(_columnIndex), this.getString(_columnIndex), null);
        return object;
    }

    @Override
    public synchronized void updateDouble(String _columnName, double x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateDouble(this.findColumn(_columnName), x);
    }

    public static Map<String, Integer> createColumnNameIndexMap(Field[] _fields, boolean isSanitiserDisabled) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int capacity = _fields.length * 2;
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>(capacity);
        for (int i = _fields.length - 1; i >= 0; --i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _columnLabel = _fields[i].getColumnLabel();
            if (isSanitiserDisabled) {
                columnNameIndexMap.put(_columnLabel, i + 1);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            columnNameIndexMap.put(_columnLabel.toLowerCase(Locale.US), i + 1);
        }
        return columnNameIndexMap;
    }

    @Override
    public Object getObject(String _columnName) throws SQLException {
        return this.getObject(this.findColumn(_columnName));
    }

    @Override
    public int findColumn(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        int _col = this.findColumnIndex(_columnName);
        if (_col == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("The _column name {0} was not found in this ResultSet.", _columnName), PSQLState.UNDEFINED_COLUMN);
            throw ksqlException;
        }
        return _col;
    }

    private int findColumnIndex(String _columnName) {
        Integer _index;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.columnNameIndexMap == null) {
            if (this.originalQuery != null) {
                this.columnNameIndexMap = this.originalQuery.getResultSetColumnNameIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.columnNameIndexMap = PgResultSet.createColumnNameIndexMap(this.fieldsT, this.baseConnection.isColumnSanitiserDisabled());
            }
        }
        if (null != (_index = this.columnNameIndexMap.get(_columnName))) {
            return _index;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _index = this.columnNameIndexMap.get(_columnName.toLowerCase(Locale.US));
        if (_index != null) {
            this.columnNameIndexMap.put(_columnName, _index);
            return _index;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _index = this.columnNameIndexMap.get(_columnName.toUpperCase(Locale.US));
        if (_index != null) {
            this.columnNameIndexMap.put(_columnName, _index);
            return _index;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ZERO;
    }

    private String trimMoney(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s1 = "-";
        if (str == null) {
            return null;
        }
        if (str.length() < 2) {
            return str;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char chrT = str.charAt(0);
        if (chrT > '-' && chrT != '\uffe5') {
            return str;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (chrT == '(') {
            str = "-" + PGtokenizer.removePara(str).substring(1);
        } else if (chrT == '$' || chrT == '\uffe5') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            str = str.substring(1);
        } else if (chrT == '-' && (str.charAt(1) == '$' || str.charAt(1) == '\uffe5')) {
            str = "-" + str.substring(2);
        }
        return str;
    }

    public int getColumnOID(int _field) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fieldsT[_field - 1].getOID();
    }

    public String getFixedString(int _col) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.trimMoney(this.getString(_col));
    }

    protected String getPGType(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.fieldsT[_column - 1];
        this.initSqlType(_field);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String pgType = _field.getPGType();
        return pgType;
    }

    protected int getSQLType(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.fieldsT[_column - 1];
        this.initSqlType(_field);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sqlType = _field.getSQLType();
        return sqlType;
    }

    private void checkUpdateable_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (!this.isUpdateable()) {
            PSQLException ksqlException = new PSQLException(GT.tr("ResultSet is not updateable.  The query that generated this _result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == this.updateValuesMap) {
            float loadFactor = 0.75f;
            this.updateValuesMap = new HashMap((int)((double)this.fieldsT.length / 0.75), loadFactor);
        }
    }

    private void initSqlType(Field _field) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_field.isTypeInitialized()) {
            return;
        }
        int oid = _field.getOID();
        TypeInfo typeInfo = this.baseConnection.getTypeInfo();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (typeInfo != null) {
            int _sqlType = typeInfo.getSQLType(oid);
            String pgType = typeInfo.getPGType(oid);
            _field.setPGType(pgType);
            _field.setSQLType(_sqlType);
        }
    }

    protected void checkClosed_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == this.rowsList) {
            PSQLException ksqlException = new PSQLException(GT.tr("This ResultSet is closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            throw ksqlException;
        }
    }

    protected boolean isResultSetClosed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowsList == null;
    }

    protected void checkColumnIndex(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_column > this.fieldsT.length || _column < 1) {
            PSQLException ksqlException = new PSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", _column, this.fieldsT.length), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
    }

    protected void checkResultSet_(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (this._thisRow == null) {
            PSQLException ksqlException = new PSQLException(GT.tr("ResultSet not posed properly, perhapst you need to call next.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        this.checkColumnIndex(_column);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wasNullFlagT = this._thisRow[_column - 1] == null;
    }

    @Override
    public synchronized void updateLong(String _columnName, long x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateLong(this.findColumn(_columnName), x);
    }

    @Override
    public synchronized void updateByte(int _columnIndex, byte x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, String.valueOf(x));
    }

    protected boolean isBinary_(int columnIndex) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fieldsT[columnIndex - 1].getFormat() == 1;
    }

    @Override
    public synchronized void updateAsciiStream(String _columnName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateAsciiStream(this.findColumn(_columnName), x, length);
    }

    public static short toShort(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                if ("f".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str)) {
                    return 0;
                }
                if ("t".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str)) {
                    return 1;
                }
                short v = Short.parseShort(str);
                return v;
            }
            catch (NumberFormatException numberFormatException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    BigDecimal nT = new BigDecimal(str);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    BigInteger iT = nT.toBigInteger();
                    int ltT = iT.compareTo(SHORT_MIN_VAL);
                    int gtT = iT.compareTo(SHORT_MAX_VAL);
                    if (ltT < 0 || gtT > 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "short", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                        throw ksqlException;
                    }
                    return iT.shortValue();
                }
                catch (NumberFormatException numberFormatException1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "short", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    throw ksqlException;
                }
            }
        }
        return (short)ZERO;
    }

    public static int toInt(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                if ("f".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str)) {
                    return 0;
                }
                if ("t".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str)) {
                    return 1;
                }
                int v = Integer.parseInt(str);
                return v;
            }
            catch (NumberFormatException numberFormatException1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    BigDecimal nT = new BigDecimal(str);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    BigInteger iT = nT.toBigInteger();
                    int ltT = iT.compareTo(INT_MIN_VAL);
                    int gtT = iT.compareTo(INT_MAX_VAL);
                    if (ltT < 0 || gtT > 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "int", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                        throw ksqlException;
                    }
                    return iT.intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "int", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    throw ksqlException;
                }
            }
        }
        return ZERO;
    }

    @Override
    public synchronized void updateObject(int _columnIndex, Object x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNull(this.findColumn(_columnName));
    }

    public static long toLong(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                if ("f".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str)) {
                    return 0L;
                }
                if ("t".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str)) {
                    return 1L;
                }
                long v = Long.parseLong(str);
                return v;
            }
            catch (NumberFormatException numberFormatException1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    BigDecimal nT = new BigDecimal(str);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    BigInteger iT = nT.toBigInteger();
                    int ltT = iT.compareTo(LONG_MIN_VAL);
                    int gtT = iT.compareTo(LONG_MAX_VAL);
                    if (ltT < 0 || gtT > 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "long", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                        throw ksqlException;
                    }
                    return iT.longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "long", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    throw ksqlException;
                }
            }
        }
        return ZERO;
    }

    public static BigDecimal toBigDecimal(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str == null) {
            return null;
        }
        try {
            str = str.trim();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new BigDecimal(str);
        }
        catch (NumberFormatException numberFormatException) {
            PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "BigDecimal", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            throw ksqlException;
        }
    }

    public BigDecimal toBigDecimal(String str, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str == null) {
            return null;
        }
        BigDecimal valueT = PgResultSet.toBigDecimal(str);
        BigDecimal bigDecimal = this.scaleBigDecimal(valueT, scale);
        return bigDecimal;
    }

    @Override
    public synchronized void updateShort(String _columnName, short x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateShort(this.findColumn(_columnName), x);
    }

    private BigDecimal scaleBigDecimal(BigDecimal value, int scale) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (scale == -1) {
            return value;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return value.setScale(scale);
        }
        catch (ArithmeticException arithmeticException) {
            PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "BigDecimal", value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            throw ksqlException;
        }
    }

    public static float toFloat(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Float.parseFloat(str);
            }
            catch (NumberFormatException numberFormatException) {
                PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "float", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                throw ksqlException;
            }
        }
        return ZERO;
    }

    @Override
    public synchronized void updateInt(String _columnName, int x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateInt(this.findColumn(_columnName), x);
    }

    public static double toDouble(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str != null) {
            try {
                str = str.trim();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Double.parseDouble(str);
            }
            catch (NumberFormatException numberFormatException) {
                PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", "double", str), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                throw ksqlException;
            }
        }
        return ZERO;
    }

    private void initRowBuffer_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._thisRow = this.rowsList.get(this.curRowT);
        if (this._resultsetconcurrency == 1008) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rowBufferT = new byte[this._thisRow.length][];
            System.arraycopy(this._thisRow, 0, this.rowBufferT, 0, this._thisRow.length);
        } else {
            this.rowBufferT = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    @Override
    public synchronized void updateBoolean(String _columnName, boolean x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBoolean(this.findColumn(_columnName), x);
    }

    @Override
    public synchronized void updateDate(int _columnIndex, java.sql.Date x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    private boolean isColumnTrimmable(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (isColumnTrimmableSet.contains(this.getSQLType(_columnIndex))) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public synchronized void updateString(String _columnName, String x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateString(this.findColumn(_columnName), x);
    }

    private byte[] trimBytes(int columnIndexT, byte[] bytesT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bytesT.length > this.maxFieldSize && this.isColumnTrimmable(columnIndexT) && this.maxFieldSize > 0) {
            byte[] newBytesT = new byte[this.maxFieldSize];
            System.arraycopy(bytesT, 0, newBytesT, 0, this.maxFieldSize);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return newBytesT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return bytesT;
    }

    @Override
    public synchronized void updateCharacterStream(String _columnName, Reader reader, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateCharacterStream(this.findColumn(_columnName), reader, length);
    }

    private String trimString(int _columnIndex, String string) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.maxFieldSize > 0 && string.length() > this.maxFieldSize && this.isColumnTrimmable(_columnIndex)) {
            return string.substring(0, this.maxFieldSize);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return string;
    }

    @Override
    public synchronized void updateBoolean(int _columnIndex, boolean x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public synchronized void updateShort(int _columnIndex, short x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    protected void updateValue(int _columnIndex, Object _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkUpdateable_();
        if (!this.onInsertRowT && (this.isBeforeFirst() || this.isAfterLast() || this.rowsList.isEmpty())) {
            PSQLException ksqlException = new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the _results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkColumnIndex(_columnIndex);
        boolean bl = this.doingUpdatesT = !this.onInsertRowT;
        if (_value == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateNull(_columnIndex);
        } else {
            PGResultSetMetaData md = (PGResultSetMetaData)((Object)this.getMetaData());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateValuesMap.put(md.getBaseColumnName(_columnIndex), _value);
        }
    }

    private double readDoubleValue(byte[] _bytes, int oid, String targetType) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (oid) {
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.int1(_bytes, 0);
            }
            case 21: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.int2(_bytes, 0);
            }
            case 23: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.int4(_bytes, 0);
            }
            case 20: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.int8(_bytes, 0);
            }
            case 700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.float4(_bytes, 0);
            }
            case 701: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ByteConverter.float8(_bytes, 0);
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                double doubleValue = ByteConverter.numeric(_bytes).doubleValue();
                return doubleValue;
            }
        }
        PSQLException ksqlException = new PSQLException(GT.tr("Cannot convert the _column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
        throw ksqlException;
    }

    protected Object getUUID(byte[] bytes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new UUID(ByteConverter.int8(bytes, 0), ByteConverter.int8(bytes, 8));
    }

    void addRows(List<byte[][]> _tuples) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rowsList.addAll(_tuples);
    }

    @Override
    public void updateRef(int _columnIndex, Ref x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateRef(int,Ref)");
        throw e;
    }

    protected Object getUUID(String str) throws SQLException {
        UUID uuidT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            uuidT = UUID.fromString(str);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PSQLException ksqlException = new PSQLException(GT.tr("Invalid UUID data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)illegalArgumentException);
            throw ksqlException;
        }
        return uuidT;
    }

    @Override
    public void updateRef(String _columnName, Ref x) throws SQLException {
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateRef(String,Ref)");
        throw e;
    }

    @Override
    public void updateBlob(int _columnIndex, Blob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateObject(_columnIndex, (Object)x.getBytes(1L, (int)x.length()));
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateBlob(int,Blob)");
        throw e;
    }

    @Override
    public void updateBlob(String _columnName, Blob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBlob(this.findColumn(_columnName), x);
    }

    @Override
    public void updateClob(int _columnIndex, Clob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateObject(_columnIndex, (Object)x.getSubString(1L, (int)x.length()));
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateClob(int,Clob)");
        throw e;
    }

    @Override
    public void updateClob(String _columnName, Clob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateClob(this.findColumn(_columnName), x);
    }

    @Override
    public void updateArray(int _columnIndex, Array x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateObject(_columnIndex, (Object)x);
    }

    @Override
    public void updateArray(String _columnName, Array x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateArray(this.findColumn(_columnName), x);
    }

    @Override
    public <T> T getObject(int _columnIndex, Class<T> type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == type) {
            SQLException type_is_null = new SQLException("type is null");
            throw type_is_null;
        }
        int _sqlType = this.getSQLType(_columnIndex);
        if (BigDecimal.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 2 || _sqlType == 3) {
                T cast = type.cast(this.getBigDecimal(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (String.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 12 || _sqlType == 1) {
                T cast = type.cast(this.getString(_columnIndex));
                return cast;
            }
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Boolean.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 16 || _sqlType == -7) {
                boolean booleanValue = this.getBoolean(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    return v;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                T v = type.cast(booleanValue);
                return v;
            }
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Byte.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (-6 == _sqlType) {
                byte byteValue = this.getByte(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    return v;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                T v = type.cast(byteValue);
                return v;
            }
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Short.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 5 || _sqlType == -6) {
                short shortValue = this.getShort(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(shortValue);
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Integer.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 5 || _sqlType == -6 || _sqlType == 4) {
                int intValue = this.getInt(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(intValue);
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Long.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == -5) {
                long longValue = this.getLong(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(longValue);
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (BigInteger.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == -5) {
                long longValue = this.getLong(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(BigInteger.valueOf(longValue));
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Float.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 7) {
                float floatValue = this.getFloat(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(Float.valueOf(floatValue));
                return v;
            }
            if (_sqlType == 8) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                float floatValue = this.getFloat(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(Float.valueOf(floatValue));
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Double.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 6 || _sqlType == 8) {
                double doubleValue = this.getDouble(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return v;
                }
                T v = type.cast(doubleValue);
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (java.sql.Date.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 91 || _sqlType == 93) {
                T cast = type.cast(this.getDate(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Time.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 92) {
                T cast = type.cast(this.getTime(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Timestamp.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 93) {
                T cast = type.cast(this.getTimestamp(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Calendar.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 93) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Timestamp timestampValue = this.getTimestamp(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    return v;
                }
                Calendar cal = Calendar.getInstance(this.getDefaultCalendar().getTimeZone());
                cal.setTimeInMillis(timestampValue.getTime());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                T v = type.cast(cal);
                return v;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Blob.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 2004 || _sqlType == -2 || _sqlType == -5) {
                T cast = type.cast(this.getBlob(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Clob.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 2005 || _sqlType == -5) {
                T cast = type.cast(this.getClob(_columnIndex));
                return cast;
            }
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Date.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 93) {
                Timestamp timestamp = this.getTimestamp(_columnIndex);
                if (this.wasNull()) {
                    T v = null;
                    return v;
                }
                T v = type.cast(new Date(timestamp.getTime()));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return v;
            }
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (Array.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 2003) {
                T cast = type.cast(this.getArray(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (SQLXML.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_sqlType == 2009) {
                T cast = type.cast(this.getSQLXML(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (UUID.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            T cast = type.cast(this.getObject(_columnIndex));
            return cast;
        }
        if (InetAddress.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String inetText = this.getString(_columnIndex);
            if (null == inetText) {
                return null;
            }
            String s1 = "/";
            int slash = inetText.indexOf("/");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                T cast = type.cast(InetAddress.getByName(slash < 0 ? inetText : inetText.substring(0, slash)));
                return cast;
            }
            catch (UnknownHostException ex) {
                PSQLException ksqlException = new PSQLException(GT.tr("Invalid Inet data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ex);
                throw ksqlException;
            }
        }
        if (Struct.class == type) {
            if (2002 == _sqlType) {
                T cast = type.cast(this.getObject(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (RowId.class == type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (-8 == _sqlType) {
                T cast = type.cast(this.getRowId(_columnIndex));
                return cast;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
            throw ksqlException;
        }
        if (PGobject.class.isAssignableFrom(type)) {
            Object object;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.isBinary_(_columnIndex)) {
                object = this.baseConnection.getObject(this.getPGType(_columnIndex), null, this._thisRow[_columnIndex - 1]);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                object = this.baseConnection.getObject(this.getPGType(_columnIndex), this.getString(_columnIndex), null);
            }
            T cast = type.cast(object);
            return cast;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PSQLException ksqlException = new PSQLException(GT.tr("conversion to {0} from {1} not supported", type, this.getPGType(_columnIndex)), PSQLState.INVALID_PARAMETER_VALUE);
        throw ksqlException;
    }

    @Override
    public synchronized void updateByte(String _columnName, byte x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateByte(this.findColumn(_columnName), x);
    }

    @Override
    public <T> T getObject(String _columnLabel, Class<T> type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        T object = this.getObject(this.findColumn(_columnLabel), type);
        return object;
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object objectImpl = this.getObjectImpl(s, map);
        return objectImpl;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object objectImpl = this.getObjectImpl(i, map);
        return objectImpl;
    }

    @Override
    public RowId getRowId(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getRowId _columnIndex: {0}", _columnIndex);
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            if (this.wasNullFlagT) {
                return null;
            }
            if (this.baseConnection.isDatabaseSupportRowid()) {
                return new PgRowId(this.getString(_columnIndex));
            }
            Field field = this.fieldsT[_columnIndex - 1];
            return new PgRowId(field.getTableOid(), this.getString(_columnIndex));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getRowId(int)");
        throw e;
    }

    @Override
    public RowId getRowId(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getRowId(this.findColumn(_columnName));
    }

    @Override
    public synchronized void updateObject(String _columnName, Object x, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateObject(this.findColumn(_columnName), x);
    }

    @Override
    public void updateRowId(int _columnIndex, RowId x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateValue(_columnIndex, x.toString());
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateRowId(int, RowId)");
        throw e;
    }

    @Override
    public void updateRowId(String _columnName, RowId x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateRowId(this.findColumn(_columnName), x);
    }

    private long readLongValue(byte[] _bytes, int oid, long minVal, long maxVal, String targetType) throws PSQLException {
        long value;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (oid) {
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = ByteConverter.int1(_bytes, 0);
                break;
            }
            case 21: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = ByteConverter.int2(_bytes, 0);
                break;
            }
            case 23: 
            case 7015: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = ByteConverter.int4(_bytes, 0);
                break;
            }
            case 20: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = ByteConverter.int8(_bytes, 0);
                break;
            }
            case 700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = (long)ByteConverter.float4(_bytes, 0);
                break;
            }
            case 701: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = (long)ByteConverter.float8(_bytes, 0);
                break;
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Number num = ByteConverter.numeric(_bytes);
                if (num instanceof BigDecimal) {
                    long longValue;
                    value = longValue = ((BigDecimal)num).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                value = num.longValue();
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PSQLException ksqlException = new PSQLException(GT.tr("Cannot convert the _column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
                throw ksqlException;
            }
        }
        if (value < minVal || value > maxVal) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PSQLException ksqlException = new PSQLException(GT.tr("Bad _value for type {0} : {1}", targetType, value), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            throw ksqlException;
        }
        return value;
    }

    @Override
    public synchronized void updateBytes(String _columnName, byte[] x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBytes(this.findColumn(_columnName), x);
    }

    @Override
    public synchronized void updateLong(int _columnIndex, long x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getHoldability()");
        throw e;
    }

    @Override
    public synchronized void updateBinaryStream(String _columnName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBinaryStream(this.findColumn(_columnName), x, length);
    }

    @Override
    public synchronized void updateNull(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkColumnIndex(_columnIndex);
        String _columnTypeName = this.getPGType(_columnIndex);
        this.updateValue(_columnIndex, new NullObject(_columnTypeName));
    }

    @Override
    public boolean isClosed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isClosed = this.rowsList == null;
        return isClosed;
    }

    @Override
    public void updateNString(int _columnIndex, String nString) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateValue(_columnIndex, nString);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNString(int, String)");
        throw e;
    }

    @Override
    public void updateNString(String _columnName, String nString) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNString(this.findColumn(_columnName), nString);
    }

    @Override
    public void updateNClob(int _columnIndex, NClob nClob) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateObject(_columnIndex, (Object)nClob);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNClob(int, NClob)");
        throw e;
    }

    @Override
    public synchronized void updateFloat(int _columnIndex, float x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, Float.valueOf(x));
    }

    @Override
    public void updateNClob(String _columnName, NClob nClob) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNClob(this.findColumn(_columnName), nClob);
    }

    @Override
    public synchronized void updateInt(int _columnIndex, int x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public void updateNClob(int _columnIndex, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateClob(_columnIndex, reader);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNClob(int, Reader)");
        throw e;
    }

    @Override
    public void updateNClob(String _columnName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNClob(this.findColumn(_columnName), reader);
    }

    @Override
    public synchronized void updateBytes(int _columnIndex, byte[] x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public void updateNClob(int _columnIndex, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateClob(_columnIndex, reader, length);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNClob(int, Reader, long)");
        throw e;
    }

    @Override
    public void updateNClob(String _columnName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNClob(this.findColumn(_columnName), reader, length);
    }

    protected NClob makeNClob(char[] _buffer, PgResultSet resultSet, int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new EsNClob(_buffer, resultSet, _columnIndex, this.baseConnection.getEncoding().name());
    }

    @Override
    public NClob getNClob(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getNClob _columnIndex: {0}", _columnIndex);
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            String str = this.getString(_columnIndex);
            return this.makeNClob(str == null ? null : str.toCharArray(), this, _columnIndex);
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getNClob(int)");
        throw e;
    }

    @Override
    public NClob getNClob(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getNClob(this.findColumn(_columnName));
    }

    @Override
    public void updateBlob(int _columnIndex, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            if (inputStream == null) {
                this.updateNull(_columnIndex);
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] _value = new byte[(int)length];
            try {
                inputStream.read(_value, 0, (int)length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateObject(_columnIndex, (Object)_value);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream, long)");
        throw e;
    }

    @Override
    public void updateBlob(String _columnName, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBlob(this.findColumn(_columnName), inputStream, length);
    }

    @Override
    public void updateBlob(int _columnIndex, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            byte[] _value = null;
            try {
                if (inputStream != null) {
                    _value = new byte[inputStream.available()];
                    inputStream.read(_value);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateObject(_columnIndex, (Object)_value);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream)");
        throw e;
    }

    @Override
    public void updateBlob(String _columnName, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBlob(this.findColumn(_columnName), inputStream);
    }

    @Override
    public void updateClob(int _columnIndex, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.updateCharacterStream(_columnIndex, reader, (int)length);
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateClob(int, Reader, long)");
        throw e;
    }

    @Override
    public void updateClob(String _columnName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateClob(this.findColumn(_columnName), reader, length);
    }

    @Override
    public void updateClob(int _columnIndex, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            StringBuffer sbu = null;
            try {
                if (reader != null) {
                    sbu = new StringBuffer();
                    int leng = 0;
                    char[] c_buf = new char[1024];
                    while ((leng = reader.read(c_buf)) != -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        sbu.append(c_buf, 0, leng);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.updateValue(_columnIndex, sbu == null ? null : sbu.toString());
            return;
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateClob(int, Reader)");
        throw e;
    }

    @Override
    public synchronized void updateBigDecimal(String _columnName, BigDecimal x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBigDecimal(this.findColumn(_columnName), x);
    }

    @Override
    public void updateClob(String _columnName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateClob(this.findColumn(_columnName), reader);
    }

    @Override
    public SQLXML getSQLXML(int _columnIndex) throws SQLException {
        LOGGER.log(Level.FINEST, "  getSQLXML _columnIndex: {0}", _columnIndex);
        String data = this.getString(_columnIndex);
        SQLXML sqlxml = null;
        if (null == data) {
            return sqlxml;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PgSQLXML(this.baseConnection, data);
    }

    @Override
    public SQLXML getSQLXML(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSQLXML(this.findColumn(_columnName));
    }

    @Override
    public void updateSQLXML(int _columnIndex, SQLXML xmlObject) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String _columnName, SQLXML xmlObject) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateSQLXML(this.findColumn(_columnName), xmlObject);
    }

    @Override
    public String getNString(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getNString _columnIndex: {0}", _columnIndex);
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            return this.getString(_columnIndex);
        }
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getNString(int)");
        throw e;
    }

    @Override
    public String getNString(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getNString(this.findColumn(_columnName));
    }

    @Override
    public Reader getNCharacterStream(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "  getNCharacterStream _columnIndex: {0}", _columnIndex);
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
        throw e;
    }

    @Override
    public Reader getNCharacterStream(String _columnName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getNCharacterStream(this.findColumn(_columnName));
    }

    public void updateNCharacterStream(int _columnIndex, Reader x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, int)");
        throw e;
    }

    public void updateNCharacterStream(String _columnName, Reader x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNCharacterStream(this.findColumn(_columnName), x, length);
    }

    @Override
    public void updateNCharacterStream(int _columnIndex, Reader x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader)");
        throw e;
    }

    @Override
    public void updateNCharacterStream(String _columnName, Reader x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNCharacterStream(this.findColumn(_columnName), x);
    }

    @Override
    public void updateNCharacterStream(int _columnIndex, Reader x, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, long)");
        throw e;
    }

    @Override
    public void updateNCharacterStream(String _columnName, Reader x, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateNCharacterStream(this.findColumn(_columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int _columnIndex, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader, long)");
        throw e;
    }

    @Override
    public void updateCharacterStream(String _columnName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateCharacterStream(this.findColumn(_columnName), reader, length);
    }

    @Override
    public synchronized void updateDouble(int _columnIndex, double x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateValue(_columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int _columnIndex, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader)");
        throw e;
    }

    @Override
    public void updateCharacterStream(String _columnName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateCharacterStream(this.findColumn(_columnName), reader);
    }

    @Override
    public void updateBinaryStream(int _columnIndex, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, long)");
        throw e;
    }

    @Override
    public void updateBinaryStream(String _columnName, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBinaryStream(this.findColumn(_columnName), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int _columnIndex, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream)");
        throw e;
    }

    @Override
    public void updateBinaryStream(String _columnName, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateBinaryStream(this.findColumn(_columnName), inputStream);
    }

    @Override
    public void updateAsciiStream(int _columnIndex, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, long)");
        throw e;
    }

    @Override
    public void updateAsciiStream(String _columnName, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateAsciiStream(this.findColumn(_columnName), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int _columnIndex, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SQLFeatureNotSupportedException e = Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream)");
        throw e;
    }

    @Override
    public void updateAsciiStream(String _columnName, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateAsciiStream(this.findColumn(_columnName), inputStream);
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        SQLException throwables = new SQLException("Cannot unwrap to " + clz.getName());
        throw throwables;
    }

    private Calendar getDefaultCalendar() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils tsUtils = this.baseConnection.getTimestampUtils();
        if (tsUtils.hasFastDefaultTimeZone()) {
            Calendar sharedCalendar = tsUtils.getSharedCalendar(null);
            return sharedCalendar;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar sharedCalendar = tsUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    public int getTupleCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowsList.size();
    }

    @Override
    public synchronized void updateDate(String _columnName, java.sql.Date x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateDate(this.findColumn(_columnName), x);
    }

    @Override
    public synchronized void updateFloat(String _columnName, float x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateFloat(this.findColumn(_columnName), x);
    }

    public synchronized void insertLob(Object objt) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        if (!this.originalQuery.hasForUpdate()) {
            PSQLException ksqlException = new PSQLException(GT.tr("The query \"{0}\" is not locked.", this.originalQuery.toString(null)), null);
            throw ksqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.parseQuery();
        if (!this.singleTableT) {
            LOGGER.log(Level.FINE, "not a single table", new Object[0]);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINE, "getting primary keys", new Object[0]);
        StringBuilder updateSQL_SB = new StringBuilder("UPDATE " + this.onlyTableT + this.tablName + " SET  ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGResultSetMetaData md = (PGResultSetMetaData)((Object)this.getMetaData());
        String _column = null;
        if (objt instanceof EsClob) {
            _column = md.getBaseColumnName(((EsClob)objt).getColumnIndex());
        } else if (objt instanceof EsBlob) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _column = md.getBaseColumnName(((EsBlob)objt).getColumnIndex());
        }
        Utils.escapeIdentifier(updateSQL_SB, _column);
        updateSQL_SB.append(" = ?");
        updateSQL_SB.append(" WHERE ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Map<String, Object> primaryKeys = this.allPrimaryKeysOfLobList.get(this.curRowT);
        Utils.escapeIdentifier(updateSQL_SB, "ctid");
        updateSQL_SB.append(" = ? and ");
        Utils.escapeIdentifier(updateSQL_SB, "xmin");
        updateSQL_SB.append(" = ?");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        updateSQL_SB.append(" returning ctid,xmin");
        String _sqlText = updateSQL_SB.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "updating {0}", _sqlText);
        }
        this.updateStatementT = this.baseConnection.prepareStatement(_sqlText);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i = 0;
        this.updateStatementT.setObject(++i, objt);
        this.updateStatementT.setObject(++i, primaryKeys.get("ctid"));
        this.updateStatementT.setObject(++i, primaryKeys.get("xmin"));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateStatementT.execute();
        ResultSet resultSet = this.updateStatementT.getResultSet();
        if (resultSet.next()) {
            primaryKeys.put("ctid", resultSet.getString(1));
            primaryKeys.put("xmin", resultSet.getString(2));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateStatementT.close();
        this.updateStatementT = null;
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        isColumnTrimmableSet.add(-3);
        isColumnTrimmableSet.add(12);
        isColumnTrimmableSet.add(1);
        isColumnTrimmableSet.add(12);
        isColumnTrimmableSet.add(-2);
        isColumnTrimmableSet.add(-1);
    }

    static class NullObject
    extends PGobject {
        NullObject(String type) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setType(type);
        }

        @Override
        public String getValue() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
    }

    private class PrimaryKey {
        int _index;
        String name;

        PrimaryKey(int _index, String name) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._index = _index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return PgResultSet.this.getObject(this._index);
        }
    }

    public class CursorResultHandler
    extends ResultHandlerBase {
        @Override
        public void handleCommandStatus(String status, long updateNum, long insertOID) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PgResultSet.this.rowsList = _tuples;
            PgResultSet.this.resultCursor = cursor;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, boolean isLast) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PgResultSet.this.rowsList = tuples;
            PgResultSet.this.resultCursor = cursor;
        }

        @Override
        public void handleCompletion() throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SQLWarning _warning = this.getWarning();
            if (_warning != null) {
                PgResultSet.this.addWarning(_warning);
            }
            super.handleCompletion();
        }
    }
}

