/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public final class URLCoder {
    private static final String ENCODING_FOR_URL = System.getProperty("postgresql.url._encoding", "UTF-8");

    public static String decode(String _encoded) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            return URLDecoder.decode(_encoded, ENCODING_FOR_URL);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to decode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }

    public static String encode(String plain) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            return URLEncoder.encode(plain, ENCODING_FOR_URL);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to _encode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }
}

