/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ukpwd;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.security.auth.callback.CallbackHandler;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.ssl.LazyKeyManager;
import org.postgresql.ssl.LibKCIFactory;
import org.postgresql.ssl.PKCS12KeyManager;
import org.postgresql.ukpwd.SM2Sign;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.ObjectFactory;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class CertAuthenticator {
    private Properties infoProps;
    private PGStream pgStream;
    private byte[] clientRandom;
    private KeyManager km;
    private boolean defaultfileT;
    private String sslrootcertfile;
    private String sslcertfile;
    private String sslkeyfileT;

    public CertAuthenticator(PGStream pgStream, Properties infoProps) throws PSQLException {
        String defaultdirT;
        this.pgStream = pgStream;
        this.infoProps = infoProps;
        String pathsepT = System.getProperty("file.separator");
        String windosStr = "windows";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (System.getProperty("os.name").toLowerCase().contains(windosStr)) {
            defaultdirT = System.getenv("APPDATA") + pathsepT + "postgresql" + pathsepT;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            defaultdirT = System.getProperty("user.home") + pathsepT + ".postgresql" + pathsepT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sslkeyfileT = PGProperty.UKPWD_KEY.get(infoProps);
        if (this.sslkeyfileT == null) {
            this.defaultfileT = true;
            this.sslkeyfileT = defaultdirT + "uclient.pk8";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.sslkeyfileT.endsWith("pk8") || this.sslkeyfileT.endsWith("key")) {
            this.initPk8(this.sslkeyfileT, defaultdirT, infoProps);
        } else if (this.sslkeyfileT.endsWith("p12")) {
            this.initP12(this.sslkeyfileT, infoProps);
        } else {
            throw new PSQLException("The key file must end with pk8 or p12 or key.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sslrootcertfile = PGProperty.UKPWD_ROOT_CERT.get(infoProps);
        if (this.sslrootcertfile == null) {
            this.sslrootcertfile = defaultdirT + "ca.crt";
        }
    }

    private void initPk8(String sslkeyfile, String defaultdir, Properties info) throws PSQLException {
        this.sslcertfile = PGProperty.UKPWD_CERT.get(info);
        if (this.sslcertfile == null) {
            this.defaultfileT = true;
            this.sslcertfile = defaultdir + "uclient.crt";
        }
        this.km = new LazyKeyManager("".equals(this.sslcertfile) ? null : this.sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, this.getCallbackHandler(info), this.defaultfileT);
    }

    private void initP12(String sslkeyfile, Properties info) throws PSQLException {
        this.km = new PKCS12KeyManager(sslkeyfile, this.getCallbackHandler(info));
    }

    private CallbackHandler getCallbackHandler(Properties info) throws PSQLException {
        CallbackHandler cbh;
        String sslpasswordcallback = PGProperty.UKPWD_PASSWORD_CALLBACK.get(info);
        if (sslpasswordcallback != null) {
            try {
                cbh = ObjectFactory.instantiate(CallbackHandler.class, sslpasswordcallback, info, false, null);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        } else {
            cbh = new LibKCIFactory.ConsoleCallbackHandler(PGProperty.UKPWD_PASSWORD.get(info));
        }
        return cbh;
    }

    public void sendCertAndSign(int len) throws IOException, SQLException {
        String randomNumber = this.pgStream.receiveString(len - 1);
        int certType = this.pgStream.receiveChar();
        if (certType == 50) {
            try {
                LOGGER.log(Level.FINEST, "class load.... " + CertAuthenticator.class.getClassLoader().toString(), new Object[0]);
                Security.insertProviderAt((Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance(), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PSQLException(GT.tr(e.getMessage(), new Object[0]), PSQLState.CONNECTION_REJECTED);
            }
        }
        Random random = new Random();
        char[] clientRand = new char[]{(char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1), (char)(random.nextInt(100) + 1)};
        this.clientRandom = new String(clientRand).getBytes();
        X509Certificate[] cert = null;
        PrivateKey key = null;
        if (this.km instanceof LazyKeyManager) {
            String aliasT = null;
            if (certType == 50) {
                aliasT = "BC";
                cert = ((LazyKeyManager)this.km).getCertificateChain(aliasT);
            } else {
                if (this.sslkeyfileT.endsWith("key")) {
                    throw new PSQLException("The key file must end with pk8 or p12.", PSQLState.INVALID_PARAMETER_VALUE);
                }
                cert = ((LazyKeyManager)this.km).getCertificateChain(aliasT);
                key = ((LazyKeyManager)this.km).getPrivateKey(aliasT);
            }
            ((LazyKeyManager)this.km).throwKeyManagerException();
        } else if (this.km instanceof PKCS12KeyManager) {
            cert = ((PKCS12KeyManager)this.km).getCertificateChain(null);
            key = ((PKCS12KeyManager)this.km).getPrivateKey(null);
            ((PKCS12KeyManager)this.km).throwKeyManagerException();
        }
        byte[] signdigest = null;
        try {
            if (certType == 50) {
                if (this.sslcertfile == null) {
                    throw new PSQLException("ukpwdcert is not allowed to be null.", PSQLState.INVALID_PARAMETER_VALUE);
                }
                signdigest = SM2Sign.getSigndigest(this.sslcertfile, this.sslkeyfileT, randomNumber, PGProperty.USER.get(this.infoProps));
            } else {
                Signature sign = Signature.getInstance("SHA1WithRSA");
                sign.initSign(key);
                sign.update(randomNumber.getBytes());
                signdigest = sign.sign();
            }
        }
        catch (Exception e) {
            throw new PSQLException("Could not sign server number.", PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        byte[] usercert = null;
        try {
            usercert = cert[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new PSQLException("Could not transform uclient certificate file", PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        this.pgStream.sendChar(99);
        this.pgStream.sendInteger4(16 + signdigest.length + usercert.length);
        this.pgStream.send(this.clientRandom);
        this.pgStream.sendInteger42(signdigest.length);
        this.pgStream.sendInteger42(usercert.length);
        this.pgStream.send(signdigest);
        this.pgStream.send(usercert);
        this.pgStream.flush();
    }

    public void verifyServerSign() throws SQLException, IOException {
        X509Certificate[] sercert;
        X509Certificate[] rootcert;
        int serversignlen = this.pgStream.receiveInteger42();
        int servercertlen = this.pgStream.receiveInteger42();
        byte[] serversign = this.pgStream.receive(serversignlen);
        byte[] servercert = this.pgStream.receive(servercertlen);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            FileInputStream fin = new FileInputStream(this.sslrootcertfile);
            Collection<? extends Certificate> rootcerts = cf.generateCertificates(fin);
            rootcert = rootcerts.toArray(new X509Certificate[0]);
            ByteArrayInputStream bin = new ByteArrayInputStream(servercert);
            Collection<? extends Certificate> sercertcerts = cf.generateCertificates(bin);
            sercert = sercertcerts.toArray(new X509Certificate[0]);
        }
        catch (IOException ioex) {
            throw new PSQLException(GT.tr("Could not read root certificate file {0}.", this.sslrootcertfile), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
        }
        catch (CertificateException gsex) {
            throw new PSQLException("Loading the certificate failed.", PSQLState.CONNECTION_FAILURE, (Throwable)gsex);
        }
        try {
            sercert[0].verify(rootcert[0].getPublicKey());
        }
        catch (Exception e) {
            throw new PSQLException("Verify the certificate of server failed.", PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        try {
            Signature sign = Signature.getInstance("SHA1WithRSA");
            sign.initVerify(sercert[0]);
            sign.update(this.clientRandom);
            boolean success = sign.verify(serversign);
            if (!success) {
                throw new PSQLException("Verify the signature of the server failed.", PSQLState.CONNECTION_FAILURE);
            }
        }
        catch (Exception e) {
            throw new PSQLException("Verify the signature of the server failed.", PSQLState.CONNECTION_FAILURE);
        }
    }
}

