/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.v3.ConnectionFactoryImpl;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] _hostSpecs, String user, String database, Properties info, int _version, Object cCMV2) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String protoName = KBProperty.PROTOCOL_VERSION.get(info);
        if (protoName == null || protoName.isEmpty() || "3".equals(protoName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ConnectionFactoryImpl _connectionFactory = new ConnectionFactoryImpl();
            QueryExecutor queryExecutorImpl = ((ConnectionFactory)_connectionFactory).openConnectionImpl(_hostSpecs, user, database, info, _version, cCMV2);
            if (queryExecutorImpl != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return queryExecutorImpl;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("A _connection could not be made using the requested protocol {0}.", protoName), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, int var5, Object var6) throws SQLException;

    protected void closeStream(KBStream newStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

