/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpath
extends KBobject
implements Serializable,
Cloneable {
    public boolean open;
    public KBpoint[] points;

    public KBpath(KBpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public KBpath() {
        this.setType("path");
    }

    public KBpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = KBtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = KBtokenizer.removePara(s);
        } else {
            throw new KSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s), KSQLState.DATA_TYPE_MISMATCH);
        }
        KBtokenizer t = new KBtokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new KBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBpath) {
            KBpath p = (KBpath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBpath newKBpath = (KBpath)super.clone();
        if (newKBpath.points != null) {
            newKBpath.points = (KBpoint[])newKBpath.points.clone();
            for (int i = 0; i < newKBpath.points.length; ++i) {
                newKBpath.points[i] = (KBpoint)newKBpath.points[i].clone();
            }
        }
        return newKBpath;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

