/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public class ResultWrapper {
    private final ResultSet resultSet;
    private final long updateNum;
    private final long insertOID;
    private ResultWrapper nextOne;
    private boolean isLast;

    public ResultWrapper(ResultSet resultSet) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultSet = resultSet;
        this.updateNum = -1L;
        this.insertOID = -1L;
    }

    public ResultWrapper(ResultSet rs, boolean isLast) {
        this(rs);
        this.isLast = isLast;
    }

    public ResultWrapper(long updateNum, long insertOID) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultSet = null;
        this.updateNum = updateNum;
        this.insertOID = insertOID;
    }

    public ResultSet getResultSet() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.resultSet;
    }

    public long getUpdateCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.updateNum;
    }

    public long getInsertOID() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.insertOID;
    }

    public ResultWrapper getNext() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.nextOne;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void append(ResultWrapper newResult) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultWrapper tail = this;
        while (tail.nextOne != null) {
            tail = tail.nextOne;
        }
        tail.nextOne = newResult;
    }
}

