/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Encoding;
import com.kingbase8.util.GT;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.util.logging.Level;

class UTF8Encoding
extends Encoding {
    private static final int MIN_2_BYTES_T = 128;
    private static final int MIN_3_BYTES_T = 2048;
    private static final int MIN_4_BYTES_T = 65536;
    private static final int MAX_CODE_POINT_T = 0x10FFFF;
    private char[] decoderArrayT = new char[1024];

    UTF8Encoding() {
        super("UTF-8".intern(), true);
    }

    private static void checkByte(int chr, int position, int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((chr & 0xC0) != 128) {
            throw new IOException(GT.tr("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", position, leng, chr));
        }
    }

    private static void checkMinimal(int chr, int minValueT) throws IOException {
        int expectedLenT;
        int actualLenT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (chr >= minValueT) {
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (minValueT) {
            case 2048: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                actualLenT = 3;
                break;
            }
            case 128: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                actualLenT = 2;
                break;
            }
            case 65536: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                actualLenT = 4;
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + minValueT);
            }
        }
        if (chr < 128) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            expectedLenT = 1;
        } else if (chr < 2048) {
            expectedLenT = 2;
        } else if (chr < 65536) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            expectedLenT = 3;
        } else {
            throw new IllegalArgumentException("unexpected chr passed to checkMinimal: " + chr);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new IOException(GT.tr("Illegal UTF-8 sequence: {0} _bytes used to _encode a {1} byte _value: {2}", actualLenT, expectedLenT, chr));
    }

    @Override
    public synchronized String decode(byte[] data, int _offset, int length) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] cdataT = this.decoderArrayT;
        if (cdataT.length < length) {
            cdataT = this.decoderArrayT = new char[length];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int inT = _offset;
        int outT = 0;
        int endT = length + _offset;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (inT < endT) {
                int chr;
                if ((chr = data[inT++] & 0xFF) >= 128) {
                    if (chr < 192) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "10xxxxxx", chr));
                    }
                    if (chr < 224) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        chr = (chr & 0x1F) << 6;
                        UTF8Encoding.checkByte(data[inT], 2, 2);
                        UTF8Encoding.checkMinimal(chr |= data[inT++] & 0x3F, 128);
                    } else if (chr < 240) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        chr = (chr & 0xF) << 12;
                        UTF8Encoding.checkByte(data[inT], 2, 3);
                        chr |= (data[inT++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[inT], 3, 3);
                        UTF8Encoding.checkMinimal(chr |= data[inT++] & 0x3F, 2048);
                    } else if (chr < 248) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        chr = (chr & 7) << 18;
                        UTF8Encoding.checkByte(data[inT], 2, 4);
                        chr |= (data[inT++] & 0x3F) << 12;
                        UTF8Encoding.checkByte(data[inT], 3, 4);
                        chr |= (data[inT++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[inT], 4, 4);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        UTF8Encoding.checkMinimal(chr |= data[inT++] & 0x3F, 65536);
                    } else {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "11111xxx", chr));
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (chr > 0x10FFFF) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final _value is out of range: {0}", chr));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (chr > 65535) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    cdataT[outT++] = (char)(55296 + ((chr -= 65536) >> 10));
                    cdataT[outT++] = (char)(56320 + (chr & 0x3FF));
                    continue;
                }
                if (chr >= 55296 && chr < 57344) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final _value is a surrogate _value: {0}", chr));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cdataT[outT++] = (char)chr;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        if (inT > endT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(cdataT, 0, outT);
    }
}

