/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;

public class BlobInputStream
extends InputStream {
    private long limit = -1L;
    private LargeObject largeObject;
    private int bsize;
    private long aposition;
    private byte[] _buffer;
    private long mposition = 0L;
    private int bposition;

    public BlobInputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobInputStream(LargeObject largeObject, int bsize) {
        this(largeObject, bsize, -1L);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public BlobInputStream(LargeObject largeObject, int bsize, long limit) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.largeObject = largeObject;
        this._buffer = null;
        this.bposition = 0;
        this.aposition = 0L;
        this.bsize = bsize;
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        try {
            if (this.limit > 0L && this.aposition >= this.limit) {
                return -1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this._buffer == null || this.bposition >= this._buffer.length) {
                this._buffer = this.largeObject.read(this.bsize);
                this.bposition = 0;
            }
            if (this.bposition >= this._buffer.length) {
                return -1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int ret = this._buffer[this.bposition] & 0x7F;
            if ((this._buffer[this.bposition] & 0x80) == 128) {
                ret |= 0x80;
            }
            ++this.bposition;
            ++this.aposition;
            return ret;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObject != null) {
            try {
                this.largeObject.close();
                this.largeObject = null;
            }
            catch (SQLException sqlException) {
                throw new IOException(sqlException.toString());
            }
        }
    }

    @Override
    public synchronized void mark(int readlimitT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.mposition = this.aposition;
    }

    @Override
    public synchronized void reset() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        try {
            if (this.mposition <= Integer.MAX_VALUE) {
                this.largeObject.seek((int)this.mposition);
            } else {
                this.largeObject.seek64(this.mposition, 0);
            }
            this._buffer = null;
            this.aposition = this.mposition;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (SQLException sqlException) {
            throw new IOException(sqlException.toString());
        }
    }

    @Override
    public boolean markSupported() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    private void checkIsClosed() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObject == null) {
            throw new IOException("BlobOutputStream is closed");
        }
    }
}

