/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public class PGtokenizer {
    protected List<String> _tokens;

    public PGtokenizer(String string, char delimiter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.tokenize(string, delimiter);
    }

    public int tokenize(String string, char delimiter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._tokens = new ArrayList<String>();
        int nest = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean skipCharacter = false;
        boolean nestedDoubleQuote = false;
        int str = 0;
        for (int p = 0; p < string.length(); ++p) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<' || !nestedDoubleQuote && !skipCharacter && c == '\"') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++nest;
                if (c == '\"') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    nestedDoubleQuote = true;
                    skipCharacter = true;
                }
            }
            if (c == ')' || c == ']' || c == '>' || nestedDoubleQuote && !skipCharacter && c == '\"') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                --nest;
                if (c == '\"') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    nestedDoubleQuote = false;
                }
            }
            boolean bl = skipCharacter = c == '\\';
            if (nest != 0 || c != delimiter) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._tokens.add(string.substring(str, p));
            str = p + 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str < string.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._tokens.add(string.substring(str));
        }
        return this._tokens.size();
    }

    public int getSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._tokens.size();
    }

    public String getToken(int n) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._tokens.get(n);
    }

    public PGtokenizer tokenizeToken(int n, char delimiter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PGtokenizer(this.getToken(n), delimiter);
    }

    public static String remove(String str, String l, String t) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str.startsWith(l)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            str = str.substring(l.length());
        }
        if (str.endsWith(t)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            str = str.substring(0, str.length() - t.length());
        }
        return str;
    }

    public void remove(String l, String t) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < this._tokens.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._tokens.set(i, PGtokenizer.remove(this._tokens.get(i), l, t));
        }
    }

    public static String removePara(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGtokenizer.remove(str, "(", ")");
    }

    public void removePara() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.remove("(", ")");
    }

    public static String removeBox(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGtokenizer.remove(str, "[", "]");
    }

    public static String removeAngle(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGtokenizer.remove(str, "<", ">");
    }

    public void removeAngle() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.remove("<", ">");
    }

    public static String removeCurlyBrace(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PGtokenizer.remove(str, "{", "}");
    }

    public void removeBox() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.remove("[", "]");
    }

    public void removeCurlyBrace() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.remove("{", "}");
    }
}

