/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class KbSQLXML
implements SQLXML {
    private final BaseConnection _conn;
    private String content;
    private boolean initializedT;
    private boolean activeT;
    private boolean freed;
    private ByteArrayOutputStream byteArrayOutputStream;
    private StringWriter sw;
    private DOMResult domResultT;

    public KbSQLXML(BaseConnection _conn) {
        this(_conn, null, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KbSQLXML(BaseConnection _conn, String content) {
        this(_conn, content, true);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private KbSQLXML(BaseConnection _conn, String content, boolean initialized) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._conn = _conn;
        this.content = content;
        this.initializedT = initialized;
        this.activeT = false;
        this.freed = false;
    }

    @Override
    public synchronized void free() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.freed = true;
        this.content = null;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.ensureInitialized();
        if (this.content == null) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            return new ByteArrayInputStream(this._conn.getEncoding().encode(this.content));
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException("Failed to re-_encode xml content.", KSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.ensureInitialized();
        if (this.content == null) {
            return null;
        }
        return new StringReader(this.content);
    }

    @Override
    public synchronized <T extends Source> T getSource(Class<T> srcClass) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.ensureInitialized();
        if (this.content == null) {
            return null;
        }
        try {
            if (srcClass == null || DOMSource.class.equals(srcClass)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder _builder = factory.newDocumentBuilder();
                _builder.setErrorHandler(new NonPrintErrorHandler());
                InputSource input = new InputSource(new StringReader(this.content));
                return (T)new DOMSource(_builder.parse(input));
            }
            if (SAXSource.class.equals(srcClass)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                InputSource is = new InputSource(new StringReader(this.content));
                return (T)new SAXSource(is);
            }
            if (StreamSource.class.equals(srcClass)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (T)new StreamSource(new StringReader(this.content));
            }
            if (StAXSource.class.equals(srcClass)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(this.content));
                return (T)new StAXSource(xsr);
            }
        }
        catch (Exception e) {
            throw new KSQLException(GT.tr("Unable to decode xml content.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Unknown XML Source class: {0}", srcClass), KSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized String getString() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.ensureInitialized();
        return this.content;
    }

    @Override
    public synchronized OutputStream setBinaryStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.initialize_();
        this.activeT = true;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    @Override
    public synchronized Writer setCharacterStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.initialize_();
        this.activeT = true;
        this.sw = new StringWriter();
        return this.sw;
    }

    @Override
    public synchronized <T extends Result> T setResult(Class<T> _resultClass) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.initialize_();
        if (_resultClass == null || DOMResult.class.equals(_resultClass)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.domResultT = new DOMResult();
            this.activeT = true;
            return (T)this.domResultT;
        }
        if (SAXResult.class.equals(_resultClass)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                this.sw = new StringWriter();
                transformerHandler.setResult(new StreamResult(this.sw));
                this.activeT = true;
                return (T)new SAXResult(transformerHandler);
            }
            catch (TransformerException te) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Unable to create SAXResult for SQLXML.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)te);
            }
        }
        if (StreamResult.class.equals(_resultClass)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sw = new StringWriter();
            this.activeT = true;
            return (T)new StreamResult(this.sw);
        }
        if (StAXResult.class.equals(_resultClass)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sw = new StringWriter();
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xsw = xof.createXMLStreamWriter(this.sw);
                this.activeT = true;
                return (T)new StAXResult(xsw);
            }
            catch (XMLStreamException xse) {
                throw new KSQLException(GT.tr("Unable to create StAXResult for SQLXML", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)xse);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Unknown XML Result class: {0}", _resultClass), KSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized void setString(String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        this.initialize_();
        this.content = _value;
    }

    private void checkHasFreed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.freed) {
            throw new KSQLException(GT.tr("This SQLXML object has already been freed.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private void ensureInitialized() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.initializedT) {
            throw new KSQLException(GT.tr("This SQLXML object has not been initialized, so you cannot retrieve content from it.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        if (!this.activeT) {
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.byteArrayOutputStream != null) {
            try {
                this.content = this._conn.getEncoding().decode(this.byteArrayOutputStream.toByteArray());
            }
            catch (IOException ioe) {
                throw new KSQLException(GT.tr("Failed to convert binary xml content to _encoding: {0}.", this._conn.getEncoding().name()), KSQLState.DATA_ERROR, (Throwable)ioe);
            }
            finally {
                this.byteArrayOutputStream = null;
                this.activeT = false;
            }
        }
        if (this.sw != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.content = this.sw.toString();
            this.sw = null;
            this.activeT = false;
        } else if (this.domResultT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformerT = transformerFactory.newTransformer();
                DOMSource domSourceT = new DOMSource(this.domResultT.getNode());
                StringWriter sw = new StringWriter();
                StreamResult streamResult = new StreamResult(sw);
                transformerT.transform(domSourceT, streamResult);
                this.content = sw.toString();
            }
            catch (TransformerException te) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Unable to convert DOMResult SQLXML content to a string.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)te);
            }
            finally {
                this.domResultT = null;
                this.activeT = false;
            }
        }
    }

    private void initialize_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.initializedT) {
            throw new KSQLException(GT.tr("This SQLXML object has already been initialized, so you cannot manipulate it further.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        this.initializedT = true;
    }

    static class NonPrintErrorHandler
    implements ErrorHandler {
        NonPrintErrorHandler() {
        }

        @Override
        public void warning(SAXParseException saxParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }

        @Override
        public void error(SAXParseException saxParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }

        @Override
        public void fatalError(SAXParseException saxParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }
}

