/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;

public class NioWebSocketMessageProcessor
extends NioTcpMessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(NioWebSocketMessageProcessor.class);

    public NioWebSocketMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, sipStack, port);
        this.transport = "WS";
    }

    @Override
    public NioTcpMessageChannel createMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel client) throws IOException {
        NioWebSocketMessageChannel retval = (NioWebSocketMessageChannel)this.nioHandler.getMessageChannel(client);
        if (retval == null) {
            retval = new NioWebSocketMessageChannel(this.sipStack, nioTcpMessageProcessor, client);
            this.nioHandler.putMessageChannel(client, retval);
        }
        return retval;
    }

    @Override
    ConnectionOrientedMessageChannel constructMessageChannel(InetAddress targetHost, int port) throws IOException {
        return new NioWebSocketMessageChannel(targetHost, port, this.sipStack, this);
    }
}

