/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobOutputStream
extends OutputStream {
    private Clob largeObj;
    private byte[] _buf;
    private int bsize;
    private int bposition;
    private int clobposition;
    private String _encoding;

    public ClobOutputStream(Clob largeObj, int position, String _encoding) {
        this.largeObj = largeObj;
        this.clobposition = position;
        this.bsize = 1024;
        this._buf = new byte[this.bsize];
        this.bposition = 0;
        this._encoding = _encoding;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        try {
            if (this.bposition >= this.bsize) {
                this.largeObj.setString(this.clobposition, new String(this._buf, this._encoding));
                this.clobposition += this._buf.length;
                this.bposition = 0;
            }
            this._buf[this.bposition++] = (byte)b;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf) throws IOException {
        this.checkClosed();
        try {
            if (this.bposition > 0) {
                this.flush();
            }
            String str = new String(_buf, this._encoding);
            this.largeObj.setString(this.clobposition, str.trim());
            this.clobposition += _buf.length;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf, int off, int leng) throws IOException {
        this.checkClosed();
        try {
            if (this.bposition > 0) {
                this.flush();
            }
            if (off == 0 && leng == _buf.length) {
                this.largeObj.setString(this.clobposition, new String(_buf, this._encoding));
                this.clobposition += _buf.length;
            } else {
                this.largeObj.setString(this.clobposition, new String(_buf, this._encoding), off, leng);
                this.clobposition += leng;
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            if (this.bposition > 0) {
                this.largeObj.setString(this.clobposition, new String(this._buf, this._encoding), 0, this.bposition);
                this.clobposition += this.bposition;
            }
            this.bposition = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.largeObj != null) {
            this.flush();
            this.largeObj = null;
        }
    }

    private void checkClosed() throws IOException {
        if (this.largeObj == null) {
            throw new IOException("ClobOutputStream is closed");
        }
    }
}

