/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.postgresql.util.LOGGER;
import org.postgresql.util.Yylex;

public class Word {
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int SEMI = 10;
    public static final int RPAREN = 11;
    public static final int LPAREN = 12;
    public static final int RCBRACK = 13;
    public static final int LCBRACK = 14;
    public static final int PUNCTUATION = 15;
    public static final int EQ = 16;
    public static final int COMMA = 17;
    public static final int POINT = 18;
    public static final int EXPLAIN = 100;
    public static final int CREATE = 101;
    public static final int SELECT = 102;
    public static final int INTO = 103;
    public static final int INSERT = 104;
    public static final int UPDATE = 105;
    public static final int DELETE = 106;
    public static final int FROM = 107;
    public static final int AS = 108;
    public static final int PREPARE = 109;
    public static final int GRANT = 110;
    public static final int DECLARE = 111;
    public static final int SET = 112;
    public static final int REVOKE = 113;
    public static final int AUDIT = 114;
    public static final int DROP = 115;
    public static final int CALL = 118;
    public static final int AVG = 150;
    public static final int COUNT = 151;
    public static final int MAX = 152;
    public static final int MIN = 153;
    public static final int STDDEV = 154;
    public static final int SUM = 155;
    public static final int VARIANCE = 156;
    public static final int BEGIN = 116;
    public static final int ROLLBACK = 117;
    public static final int STRING_IDENTIFIER = 200;
    public static final int STRING_SINGLE = 201;
    public static final int STRING_DOUBLE = 202;
    public static final int LNOTE = 203;
    public static final int RNOTE = 204;
    public static final int NOTE = 205;
    public static final int GROUP_BY = 300;
    private static final String[] _keywords = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "COALESCE", "COLLATE", "COLUMN", "CONSTRAINT", "CREATE", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEC", "DECIMAL", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FLOAT", "FOR", "FOREIGN", "FROM", "GRANT", "GREATEST", "GROUP", "GROUPING", "HAVING", "IN", "INITIALLY", "INOUT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "LATERAL", "LEADING", "LEAST", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATIONAL", "NCHAR", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUT", "OVERLAY", "PLACING", "POSITION", "PRECISION", "PRIMARY", "REAL", "REFERENCES", "RETURNING", "ROW", "SELECT", "SESSION_USER", "SETOF", "SMALLINT", "SOME", "SUBSTRING", "SYMMETRIC", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TREAT", "TRIM", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VALUES", "VARCHAR", "VARIADIC", "WHEN", "WHERE", "WINDOW", "WITH", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", ",", ";", "(", ")", "{", "}", "=", ".", "?", "<", ">", "!", "-", "*", "~", "@", "#", "%", "^", "&", "|", "`", "/", "+"};
    private static final List<String> _keywordList = Arrays.asList(_keywords);
    private int m_type;
    private String m_text;
    private int m_charBegin;
    private int m_charEnd;

    public static String getTypeString(int type) {
        if (type == -1) {
            return "ERROR";
        }
        if (type == 0) {
            return "EOF";
        }
        if (type == 10) {
            return "SEMI";
        }
        if (type == 11) {
            return "RPAREN";
        }
        if (type == 12) {
            return "LPAREN";
        }
        if (type == 100) {
            return "EXPLAIN";
        }
        if (type == 101) {
            return "CREATE";
        }
        if (type == 102) {
            return "SELECT";
        }
        if (type == 103) {
            return "INTO";
        }
        if (type == 104) {
            return "INSERT";
        }
        if (type == 105) {
            return "UPDATE";
        }
        if (type == 106) {
            return "DELETE";
        }
        if (type == 112) {
            return "SET";
        }
        if (type == 107) {
            return "FROM";
        }
        if (type == 108) {
            return "AS";
        }
        if (type == 109) {
            return "PREPARE";
        }
        if (type == 110) {
            return "GRANT";
        }
        if (type == 113) {
            return "REVOKE";
        }
        if (type == 111) {
            return "DECLARE";
        }
        if (type == 150 || type == 151 || type == 152 || type == 153 || type == 154 || type == 155 || type == 156) {
            return "AGGREGATE";
        }
        if (type == 200) {
            return "STRING_IDENTIFIER";
        }
        if (type == 201) {
            return "STRING_SINGLE";
        }
        if (type == 202) {
            return "STRING_DOUBLE";
        }
        if (type == 115) {
            return "DROP";
        }
        if (type == 116) {
            return "BEGIN";
        }
        if (type == 117) {
            return "ROLLBACK";
        }
        if (type == 118) {
            return "CALL";
        }
        if (type == 13) {
            return "RCBRACK";
        }
        if (type == 14) {
            return "LCBRACK";
        }
        if (type == 300) {
            return "GROUP_BY";
        }
        return "UNKNOWN";
    }

    public static void printWords(String _sql) {
        if (_sql == null) {
            return;
        }
        Yylex lex = null;
        try {
            lex = new Yylex(new CharArrayReader(_sql.toCharArray()));
            Word w = null;
            do {
                w = lex.yylex();
                System.err.println(w);
            } while (w.m_type != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parsing(String _sql, List<String> whiteList, List<String> blackList, List<String> masterList, List<String> allSendFunctionList, List<String> tempTables, String _keyword) {
        if (_sql == null) {
            return 0;
        }
        if (_sql.toLowerCase().startsWith("show")) {
            return 1;
        }
        int select = 0;
        int call = 0;
        int create = 0;
        int into = 0;
        int explain = 0;
        int update = 0;
        int prepare = 0;
        int grant = 0;
        int declare = 0;
        int delete = 0;
        int set = 0;
        int revoke = 0;
        int audit = 0;
        int drop = 0;
        int rollback = 0;
        int group_by = 0;
        int function = 0;
        int master = 0;
        int all = 0;
        int aggregate = 0;
        Yylex lex = null;
        Word pre = null;
        Vector<String> _sqlArray = new Vector<String>();
        String fun = "";
        int noteLevel = 0;
        int i = 0;
        try {
            lex = new Yylex(new CharArrayReader(_sql.toCharArray()));
            while (true) {
                Word w = lex.yylex();
                if (w.m_type == 0) break;
                if (w.m_type == 203) {
                    ++noteLevel;
                    continue;
                }
                if (w.m_type == 204) {
                    --noteLevel;
                    continue;
                }
                if (w.m_type == 205) {
                    if (_keyword == null || _keyword.isEmpty() || !w.getText().toLowerCase().contains(_keyword)) continue;
                    ++master;
                    break;
                }
                if (noteLevel != 0) {
                    if (!w.getText().equalsIgnoreCase(_keyword)) continue;
                    ++master;
                    break;
                }
                if (w.m_type == 102) {
                    ++select;
                    _sqlArray.add(i++, w.m_text);
                } else {
                    if (w.m_type == 118) {
                        ++call;
                        _sqlArray.add(i++, w.m_text);
                    }
                    if (w.m_type == 101) {
                        ++create;
                        break;
                    }
                    if (w.m_type == 100) {
                        ++explain;
                        break;
                    }
                    if (w.m_type == 103) {
                        ++into;
                        break;
                    }
                    if (w.m_type == 105) {
                        ++update;
                        break;
                    }
                    if (w.m_type == 106) {
                        ++delete;
                        break;
                    }
                    if (w.m_type == 112) {
                        ++set;
                        break;
                    }
                    if (w.m_type == 109) {
                        ++prepare;
                        break;
                    }
                    if (w.m_type == 110) {
                        ++grant;
                        break;
                    }
                    if (w.m_type == 113) {
                        ++revoke;
                        break;
                    }
                    if (w.m_type == 111) {
                        ++declare;
                        break;
                    }
                    if (w.m_type == 115) {
                        ++drop;
                        break;
                    }
                    if (w.m_type == 114) {
                        ++audit;
                        break;
                    }
                    if (w.m_type == 150 || w.m_type == 151 || w.m_type == 152 || w.m_type == 153 || w.m_type == 154 || w.m_type == 155 || w.m_type == 156) {
                        ++aggregate;
                        _sqlArray.add(i++, w.m_text.toLowerCase());
                    } else {
                        if (w.m_type == 300) {
                            ++group_by;
                            break;
                        }
                        if (w.m_type == 116 || w.m_type == 117) {
                            ++rollback;
                            break;
                        }
                    }
                    if (w.m_type == 12 && pre != null) {
                        if (blackList != null && !blackList.isEmpty()) {
                            if (blackList.contains(_sqlArray.get(i - 1))) {
                                ++function;
                            }
                        } else if (whiteList != null && !whiteList.contains(_sqlArray.get(i - 1)) && pre != null && pre.m_type != 202 && !_keywordList.contains(((String)_sqlArray.get(i - 1)).toUpperCase())) {
                            ++function;
                            fun = fun + (String)_sqlArray.get(i - 1) + ";";
                        }
                        if (masterList != null && masterList.contains(_sqlArray.get(i - 1))) {
                            ++master;
                        }
                        if (allSendFunctionList != null && allSendFunctionList.contains(_sqlArray.get(i - 1))) {
                            ++all;
                        }
                        _sqlArray.set(i - 1, (String)_sqlArray.elementAt(i - 1) + w.m_text);
                    }
                    if (w.m_type == 200) {
                        if (w.m_text.equalsIgnoreCase("by") && pre.m_text.equalsIgnoreCase("group")) {
                            ++group_by;
                        }
                        if (pre != null && pre.m_type == 18) {
                            _sqlArray.set(i - 1, (String)_sqlArray.elementAt(i - 1) + w.m_text.toLowerCase());
                        } else {
                            _sqlArray.add(i++, w.m_text.toLowerCase());
                        }
                    }
                    if (w.m_type == 202) {
                        if (pre != null && pre.m_type == 18) {
                            _sqlArray.set(i - 1, (String)_sqlArray.elementAt(i - 1) + w.m_text);
                        } else {
                            _sqlArray.add(i++, w.m_text);
                        }
                    }
                    if (w.m_type == 18) {
                        _sqlArray.set(i - 1, (String)_sqlArray.elementAt(i - 1) + w.m_text);
                    }
                    if (w.m_type == 17 || w.m_type == 11 || w.m_type == 107 || w.m_type == 108 || w.m_type == 16) {
                        _sqlArray.add(i++, w.m_text);
                    }
                }
                pre = w;
            }
            lex.yyclose();
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (tempTables != null) {
            for (String tempTable : tempTables) {
                int _index = _sqlArray.indexOf(tempTable);
                if (_index == -1 || !"from".equalsIgnoreCase((String)_sqlArray.get(_index - 1)) && !"join".equalsIgnoreCase((String)_sqlArray.get(_index - 1)) && !",".equalsIgnoreCase((String)_sqlArray.get(_index - 1))) continue;
                ++master;
            }
        }
        if (whiteList != null && !fun.isEmpty() && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Not in WhiteList:" + fun, new Object[0]);
        }
        if ((select > 0 || call > 0) && explain == 0 && create == 0 && update == 0 && prepare == 0 && grant == 0 && declare == 0 && function == 0 && into == 0 && set == 0 && delete == 0 && revoke == 0 && audit == 0 && drop == 0 && rollback == 0 && master == 0 && all == 0) {
            return 1;
        }
        if (aggregate != 0 && group_by != 0) {
            return 1;
        }
        if (all != 0) {
            return 3;
        }
        if (master != 0) {
            return 2;
        }
        return 0;
    }

    public static void main(String[] args) {
        System.err.println(Word.parsing("audit select on sysdba.b;", null, null, null, null, null, null));
    }

    public static boolean normalSelect(String _sql) {
        int whereIndex;
        String upp_sql = _sql.trim().toUpperCase();
        if (upp_sql.startsWith("(")) {
            upp_sql = upp_sql.substring(1).trim();
        }
        if ((whereIndex = upp_sql.indexOf(" WHERE ")) >= 0) {
            upp_sql = upp_sql.substring(0, whereIndex);
        }
        int intoIndex = upp_sql.indexOf(" INTO ");
        boolean hasInto = false;
        if (intoIndex >= 0) {
            hasInto = true;
        }
        return upp_sql.startsWith("SHOW") || upp_sql.startsWith("EXPLAIN") || upp_sql.startsWith("SELECT") && !hasInto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canExplain(String _sql) {
        if (_sql == null || _sql == "") {
            return false;
        }
        int select = 0;
        int create = 0;
        int explain = 0;
        int update = 0;
        int delete = 0;
        int insert = 0;
        int drop = 0;
        Yylex lex = null;
        try {
            lex = new Yylex(new CharArrayReader(_sql.toCharArray()));
            Word w = lex.yylex();
            while (w.m_type != 0) {
                switch (w.m_type) {
                    case 101: {
                        ++create;
                        break;
                    }
                    case 102: {
                        ++select;
                        break;
                    }
                    case 104: {
                        ++insert;
                        break;
                    }
                    case 105: {
                        ++update;
                        break;
                    }
                    case 106: {
                        ++delete;
                        break;
                    }
                    case 100: {
                        ++explain;
                        break;
                    }
                    case 115: {
                        ++drop;
                    }
                }
                w = lex.yylex();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return create == 0 && explain == 0 && (select > 0 || delete > 0 || update > 0 || insert > 0 || drop > 0);
    }

    Word(int type, String text) {
        this.m_type = type;
        this.m_text = text;
        this.m_charBegin = -1;
        this.m_charEnd = -1;
    }

    Word(int type, String text, int charBegin, int charEnd) {
        this.m_type = type;
        this.m_text = text;
        this.m_charBegin = charBegin;
        this.m_charEnd = charEnd;
    }

    public String toString() {
        return Word.getTypeString(this.m_type) + " : " + this.m_text;
    }

    public int getType() {
        return this.m_type;
    }

    public String getText() {
        return this.m_text;
    }
}

