/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.jdbc.BatchResultHandler;
import org.postgresql.jdbc.CallableBatchResultHandler;
import org.postgresql.jdbc.EsBlob;
import org.postgresql.jdbc.EsClob;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgPreparedStatement;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgRowId;
import org.postgresql.jdbc.ResultWrapper;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    private int lastIndex = 0;
    protected boolean outParmBeforeFunc = false;
    private List<String> functionParameterNames = new ArrayList<String>();
    private String schemaName;
    private String functionName;
    private Map<String, Integer> callParameterNames = new HashMap<String, Integer>();
    private int paramIndex = 0;
    private int inParamCount = 0;

    PgCallableStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, connection.borrowCallableQuery(sql), rsType, rsConcurrency, rsHoldability);
        this.isFunction = this.preparedQuery.isFunction;
        this.outParmBeforeFunc = this.preparedQuery.outParmBeforeFunc;
        this.schemaName = this.preparedQuery.schemaName;
        this.functionName = this.preparedQuery.funName;
        this.inParamCount = this.preparedParameters.getInParameterCount();
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
    }

    public void copyCallableStatementInfo(PgCallableStatement stnew) {
        this.isFunction = stnew.isFunction;
        this.functionReturnType = stnew.functionReturnType;
        this.testReturn = stnew.testReturn;
        this.returnTypeSet = stnew.returnTypeSet;
        this.callResult = stnew.callResult;
        this.lastIndex = stnew.lastIndex;
        this.outParmBeforeFunc = stnew.outParmBeforeFunc;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        int outParameterCount;
        boolean hasResultSet = super.executeWithFlags(flags);
        if (!this.isFunction || !this.returnTypeSet) {
            return hasResultSet;
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = null;
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            this.checkClosed();
            for (ResultWrapper rw = this.result; rw != null; rw = rw.getNext()) {
                rs = rw.getResultSet();
            }
        }
        if (!rs.next()) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        int cols = rs.getMetaData().getColumnCount();
        if (cols != (outParameterCount = this.preparedParameters.getOutParameterCount())) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
        }
        this.lastIndex = 0;
        this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
        int i = 0;
        int j = 0;
        while (i < cols) {
            while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                ++j;
            }
            if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
                ((PgResultSet)rs).checkResultSet(i + 1);
                if (((PgResultSet)rs).wasNullFlag) {
                    this.callResult[j] = null;
                } else {
                    switch (this.functionReturnType[j]) {
                        case 2009: {
                            this.callResult[j] = rs.getSQLXML(i + 1);
                            break;
                        }
                        case -6: 
                        case 5: {
                            this.callResult[j] = rs.getShort(i + 1);
                            break;
                        }
                        case 4: {
                            this.callResult[j] = rs.getInt(i + 1);
                            break;
                        }
                        case -5: {
                            this.callResult[j] = rs.getLong(i + 1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.callResult[j] = rs.getBigDecimal(i + 1);
                            break;
                        }
                        case 7: {
                            this.callResult[j] = Float.valueOf(rs.getFloat(i + 1));
                            break;
                        }
                        case 6: 
                        case 8: {
                            this.callResult[j] = rs.getDouble(i + 1);
                            break;
                        }
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            this.callResult[j] = rs.getString(i + 1);
                            break;
                        }
                        case 91: {
                            this.callResult[j] = rs.getDate(i + 1);
                            break;
                        }
                        case 92: {
                            this.callResult[j] = rs.getTime(i + 1);
                            break;
                        }
                        case 93: {
                            this.callResult[j] = rs.getTimestamp(i + 1);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            this.callResult[j] = rs.getBytes(i + 1);
                            break;
                        }
                        case 2003: {
                            this.callResult[j] = rs.getArray(i + 1);
                            break;
                        }
                        case 2005: {
                            this.callResult[j] = rs.getClob(i + 1);
                            break;
                        }
                        case 2004: {
                            this.callResult[j] = rs.getBlob(i + 1);
                            break;
                        }
                        case 2011: {
                            this.callResult[j] = rs.getNClob(i + 1);
                            break;
                        }
                        case -8: {
                            this.callResult[j] = rs.getRowId(i + 1);
                            break;
                        }
                        default: {
                            this.callResult[j] = rs.getObject(i + 1);
                            break;
                        }
                    }
                }
            } else {
                this.callResult[j] = rs.getObject(i + 1);
            }
            int columnType = rs.getMetaData().getColumnType(i + 1);
            if (!"oracle".equals(this.connection.getCompatibleLevel()) && !"mysql".equals(this.connection.getCompatibleLevel()) && columnType != this.functionReturnType[j]) {
                if (columnType == 8 && this.functionReturnType[j] == 7) {
                    if (this.callResult[j] != null) {
                        this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                    }
                } else {
                    throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                }
            }
            ++i;
            ++j;
        }
        rs.close();
        PgCallableStatement pgCallableStatement2 = this;
        synchronized (pgCallableStatement2) {
            if (this.result.getNext() == null) {
                this.result = null;
            }
        }
        return false;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
            case 16: {
                sqlType = -7;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            int oid = 0;
            switch (sqlType) {
                case 2009: {
                    oid = 142;
                    break;
                }
                case 4: {
                    oid = 23;
                    break;
                }
                case -6: 
                case 5: {
                    oid = 21;
                    break;
                }
                case -5: {
                    oid = 20;
                    break;
                }
                case 7: {
                    oid = 700;
                    break;
                }
                case 6: 
                case 8: {
                    oid = 701;
                    break;
                }
                case 2: 
                case 3: {
                    oid = 1700;
                    break;
                }
                case 1: {
                    oid = 1042;
                    break;
                }
                case -9: 
                case -1: 
                case 12: {
                    oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                    break;
                }
                case 91: {
                    if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
                        oid = 8020;
                        break;
                    }
                    oid = 1082;
                    break;
                }
                case 92: {
                    oid = 1083;
                    break;
                }
                case 93: {
                    oid = 1114;
                    break;
                }
                case -7: 
                case 16: {
                    oid = 16;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    oid = 17;
                    break;
                }
                case 2004: {
                    oid = 8013;
                    break;
                }
                case 2005: {
                    oid = 8014;
                    break;
                }
                case 2011: {
                    oid = 8015;
                    break;
                }
                case -10: 
                case 1111: 
                case 2001: 
                case 2002: 
                case 2003: {
                    oid = 0;
                    break;
                }
                case -8: {
                    oid = 27;
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("Unknown Types value.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
                }
            }
            this.preparedParameters.registerOutParameter(parameterIndex, oid, this.outParmBeforeFunc);
        } else {
            this.preparedParameters.registerOutParameter(parameterIndex, sqlType, this.outParmBeforeFunc);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return null;
        }
        if (this.callResult[parameterIndex - 1] instanceof Clob) {
            return ((Clob)this.callResult[parameterIndex - 1]).getSubString(1L, (int)((Clob)this.callResult[parameterIndex - 1]).length());
        }
        return this.callResult[parameterIndex - 1].toString();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[parameterIndex - 1]).byteValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).byteValue();
        }
        this.checkIndex(parameterIndex, 5, "Byte");
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[parameterIndex - 1]).shortValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).shortValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[parameterIndex - 1]).shortValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).shortValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return (Short)this.callResult[parameterIndex - 1];
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).shortValue();
        }
        this.checkIndex(parameterIndex, 5, "Short");
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[parameterIndex - 1]).intValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).intValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[parameterIndex - 1]).intValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[parameterIndex - 1]).intValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).intValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return (Integer)this.callResult[parameterIndex - 1];
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).intValue();
        }
        this.checkIndex(parameterIndex, 4, "Int");
        return (Integer)this.callResult[parameterIndex - 1];
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[parameterIndex - 1]).longValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).longValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[parameterIndex - 1]).longValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[parameterIndex - 1]).longValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).longValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return (Long)this.callResult[parameterIndex - 1];
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).longValue();
        }
        this.checkIndex(parameterIndex, -5, "Long");
        return (Long)this.callResult[parameterIndex - 1];
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).floatValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).floatValue();
        }
        this.checkIndex(parameterIndex, 7, "Float");
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return (Double)this.callResult[parameterIndex - 1];
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]).doubleValue();
        }
        this.checkIndex(parameterIndex, 8, "Double");
        return (Double)this.callResult[parameterIndex - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getBigDecimal(parameterIndex);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return Date.valueOf((String)this.callResult[parameterIndex - 1]);
        }
        if (this.callResult[parameterIndex - 1] instanceof Time) {
            return new Date(((Time)this.callResult[parameterIndex - 1]).getTime());
        }
        if (this.callResult[parameterIndex - 1] instanceof Timestamp) {
            return new Date(((Timestamp)this.callResult[parameterIndex - 1]).getTime());
        }
        this.checkIndex(parameterIndex, 91, "Date");
        if (("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) && this.callResult[parameterIndex - 1] instanceof Timestamp) {
            return new Date(((Timestamp)this.callResult[parameterIndex - 1]).getTime());
        }
        return (Date)this.callResult[parameterIndex - 1];
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return Time.valueOf((String)this.callResult[parameterIndex - 1]);
        }
        if (this.callResult[parameterIndex - 1] instanceof Date) {
            return new Time(((Date)this.callResult[parameterIndex - 1]).getTime());
        }
        if (this.callResult[parameterIndex - 1] instanceof Timestamp) {
            return new Time(((Timestamp)this.callResult[parameterIndex - 1]).getTime());
        }
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return Timestamp.valueOf((String)this.callResult[parameterIndex - 1]);
        }
        if (this.callResult[parameterIndex - 1] instanceof Date) {
            return new Timestamp(((Date)this.callResult[parameterIndex - 1]).getTime());
        }
        if (this.callResult[parameterIndex - 1] instanceof Time) {
            return new Timestamp(((Time)this.callResult[parameterIndex - 1]).getTime());
        }
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new CallableBatchResultHandler(this, queries, parameterLists);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        if (this.callResult[parameterIndex - 1] instanceof Float) {
            return BigDecimal.valueOf(((Float)this.callResult[parameterIndex - 1]).floatValue());
        }
        if (this.callResult[parameterIndex - 1] instanceof Double) {
            return BigDecimal.valueOf((Double)this.callResult[parameterIndex - 1]);
        }
        if (this.callResult[parameterIndex - 1] instanceof Long) {
            return BigDecimal.valueOf((Long)this.callResult[parameterIndex - 1]);
        }
        if (this.callResult[parameterIndex - 1] instanceof Short) {
            return BigDecimal.valueOf(((Short)this.callResult[parameterIndex - 1]).shortValue());
        }
        if (this.callResult[parameterIndex - 1] instanceof Integer) {
            return BigDecimal.valueOf(((Integer)this.callResult[parameterIndex - 1]).intValue());
        }
        if (this.callResult[parameterIndex - 1] instanceof BigDecimal) {
            return (BigDecimal)this.callResult[parameterIndex - 1];
        }
        if (this.callResult[parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[parameterIndex - 1]);
        }
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            this.checkClosed();
            this.checkIndex(i);
            if (this.callResult[i - 1] instanceof byte[]) {
                return new EsBlob((byte[])this.callResult[i - 1]);
            }
            return (Blob)this.callResult[i - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            this.checkClosed();
            this.checkIndex(i);
            if (this.callResult[i - 1] instanceof String) {
                return new EsClob(((String)this.callResult[i - 1]).toCharArray());
            }
            return (Clob)this.callResult[i - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            int oid = this.connection.getTypeInfo().getPGType(typeName);
            if (oid == 0) {
                this.registerOutParameter(parameterIndex, sqlType);
            } else {
                this.preparedParameters.registerOutParameter(parameterIndex, oid, this.outParmBeforeFunc);
                this.functionReturnType[parameterIndex - 1] = sqlType;
                this.testReturn[parameterIndex - 1] = sqlType;
                if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
                    this.testReturn[parameterIndex - 1] = 12;
                } else if (this.functionReturnType[parameterIndex - 1] == 6) {
                    this.testReturn[parameterIndex - 1] = 7;
                }
                this.returnTypeSet = true;
            }
            return;
        }
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            this.checkClosed();
            this.checkIndex(parameterIndex);
            if (this.callResult[parameterIndex - 1] instanceof String) {
                return new PgRowId(0, (String)this.callResult[parameterIndex - 1]);
            }
            this.checkIndex(parameterIndex, -8, 1111, "tid");
            if (this.callResult[parameterIndex - 1] == null) {
                return null;
            }
            return (RowId)this.callResult[parameterIndex - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return (RowId)this.getXXX("getRowId", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setXXX("setRowId", new Class[]{Integer.TYPE, RowId.class}, parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setXXX("setNString", new Class[]{Integer.TYPE, String.class}, parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setXXX("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setXXX("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class}, parameterName, value);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, value, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class}, parameterName, value);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value, long length) throws SQLException {
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, value, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value) throws SQLException {
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, parameterName, value);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value, long length) throws SQLException {
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, value, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value) throws SQLException {
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setXXX("setNClob", new Class[]{Integer.TYPE, NClob.class}, parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setXXX("setClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setXXX("setClob", new Class[]{Integer.TYPE, Reader.class}, parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setXXX("setBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setXXX("setBlob", new Class[]{Integer.TYPE, InputStream.class}, parameterName, inputStream);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setXXX("setBlob", new Class[]{Integer.TYPE, Blob.class}, parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setXXX("setClob", new Class[]{Integer.TYPE, Clob.class}, parameterName, x);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setXXX("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setXXX("setNClob", new Class[]{Integer.TYPE, Reader.class}, parameterName, reader);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return (NClob)this.getXXX("getNClob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setXXX("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[parameterIndex - 1];
    }

    @Override
    public SQLXML getSQLXML(String parameterIndex) throws SQLException {
        return (SQLXML)this.getXXX("getSQLXML", new Class[]{Integer.TYPE}, parameterIndex);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel()) || "mysql".equals(this.connection.getCompatibleLevel())) {
            return this.getString(parameterIndex);
        }
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return (String)this.getXXX("getNString", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return (Reader)this.getXXX("getNCharacterStream", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return (Reader)this.getXXX("getCharacterStream", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == ResultSet.class) {
            return type.cast(this.getObject(parameterIndex));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return (T)this.getXXX("getObject", new Class[]{Integer.TYPE, Class.class}, parameterName, type);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, String.class}, parameterName, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setXXX("setURL", new Class[]{Integer.TYPE, URL.class}, parameterName, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setXXX("setNull", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setXXX("setBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setXXX("setByte", new Class[]{Integer.TYPE, Byte.TYPE}, parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setXXX("setShort", new Class[]{Integer.TYPE, Short.TYPE}, parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setXXX("setInt", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setXXX("setLong", new Class[]{Integer.TYPE, Long.TYPE}, parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setXXX("setFloat", new Class[]{Integer.TYPE, Float.TYPE}, parameterName, Float.valueOf(x));
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setXXX("setDouble", new Class[]{Integer.TYPE, Double.TYPE}, parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setXXX("setBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setXXX("setString", new Class[]{Integer.TYPE, String.class}, parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setXXX("setBytes", new Class[]{Integer.TYPE, byte[].class}, parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setXXX("setDate", new Class[]{Integer.TYPE, Date.class}, parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setXXX("setTime", new Class[]{Integer.TYPE, Time.class}, parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setXXX("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterName, x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}, parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class}, parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setXXX("setDate", new Class[]{Integer.TYPE, Date.class, Calendar.class}, parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setXXX("setTime", new Class[]{Integer.TYPE, Time.class, Calendar.class}, parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setXXX("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class, Calendar.class}, parameterName, x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setXXX("setNull", new Class[]{Integer.TYPE, Integer.TYPE, String.class}, parameterName, sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return (String)this.getXXX("getString", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return (Boolean)this.getXXX("getBoolean", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return (Byte)this.getXXX("getByte", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return (Short)this.getXXX("getShort", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return (Integer)this.getXXX("getInt", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return (Long)this.getXXX("getLong", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return ((Float)this.getXXX("getFloat", new Class[]{Integer.TYPE}, parameterName)).floatValue();
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return (Double)this.getXXX("getDouble", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return (byte[])this.getXXX("getBytes", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return (Date)this.getXXX("getDate", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return (Time)this.getXXX("getTime", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return (Timestamp)this.getXXX("getTimestamp", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getXXX("getObject", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return (BigDecimal)this.getXXX("getBigDecimal", new Class[]{Integer.TYPE}, parameterName);
    }

    public Object getObjectImpl(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getXXX("getObjectImpl", new Class[]{Integer.TYPE, Map.class}, parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return (Ref)this.getXXX("getRef", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return (Blob)this.getXXX("getBlob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return (Clob)this.getXXX("getClob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return (Array)this.getXXX("getArray", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return (Date)this.getXXX("getDate", new Class[]{Integer.TYPE, Calendar.class}, parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return (Time)this.getXXX("getTime", new Class[]{Integer.TYPE, Calendar.class}, parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return (Timestamp)this.getXXX("getTimestamp", new Class[]{Integer.TYPE, Calendar.class}, parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return (URL)this.getXXX("getURL", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameterAtName(String parameterName, int sqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, sqlType: {1}", parameterName, sqlType);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.registerOutParameter(index, sqlType);
        }
    }

    public void registerOutParameterAtName(String parameterName, int sqlType, int scale) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, sqlType: {1}, scale: {2}", parameterName, sqlType, scale);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.registerOutParameter(index, sqlType, scale);
        }
    }

    public void registerOutParameterAtName(String parameterName, int sqlType, String typeName) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, sqlType: {1}, typeName: {2}", parameterName, sqlType, typeName);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.registerOutParameter(index, sqlType, typeName);
        }
    }

    private void fillFunctionParameterNames() throws SQLException {
        if (this.functionParameterNames.isEmpty() && this.inParamCount != 0) {
            ResultSet rs = this.connection.getMetaData().getProcedureColumns(null, this.schemaName, this.functionName, "%");
            while (rs.next()) {
                this.functionParameterNames.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
        }
    }

    private void setXXX(String methodName, Class<?>[] classes, Object ... x) throws SQLException {
        try {
            Method method = this.getClass().getMethod(methodName, classes);
            if (this.isFunction && this.functionName != null && this.preparedParameterNames.isEmpty()) {
                this.fillFunctionParameterNames();
                List<Integer> indexes = this.findIndexByName(((String)x[0]).toLowerCase(), this.functionParameterNames);
                for (int index : indexes) {
                    x[0] = index;
                    method.invoke((Object)this, x);
                }
            } else {
                if (!this.callParameterNames.containsKey(((String)x[0]).toLowerCase())) {
                    if (this.callParameterNames.size() >= this.inParamCount) {
                        throw new PSQLException("Invalid column index.", PSQLState.INVALID_NAME);
                    }
                    this.callParameterNames.put(((String)x[0]).toLowerCase(), ++this.paramIndex);
                }
                x[0] = this.callParameterNames.get(((String)x[0]).toLowerCase());
                method.invoke((Object)this, x);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Object getXXX(String methodName, Class<?>[] classes, Object ... x) throws SQLException {
        try {
            List<Integer> indexes;
            Iterator<Integer> i$;
            Method method = this.getClass().getMethod(methodName, classes);
            if (this.isFunction && this.functionName != null && this.preparedParameterNames.isEmpty() && (i$ = (indexes = this.findIndexByName(((String)x[0]).toLowerCase(), this.functionParameterNames)).iterator()).hasNext()) {
                int index = i$.next();
                x[0] = index;
                return method.invoke((Object)this, x);
            }
            if (this.callParameterNames.size() == 0) {
                throw new PSQLException("Ordinal binding and Named binding cannot be combined!", PSQLState.INVALID_NAME);
            }
            if (this.callParameterNames.get(((String)x[0]).toLowerCase()) == null) {
                throw new PSQLException("Invalid column name.", PSQLState.INVALID_NAME);
            }
            x[0] = this.callParameterNames.get(((String)x[0]).toLowerCase());
            return method.invoke((Object)this, x);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new Object();
    }
}

