/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.sqlParser.sql;

import java.sql.SQLException;
import org.postgresql.PGProperty;
import org.postgresql.dispatcher.entity.DispatchConnection;
import org.postgresql.dispatcher.parser.ParseException;
import org.postgresql.dispatcher.parser.statement.AbstractStatement;
import org.postgresql.dispatcher.parser.statement.BeginStatement;
import org.postgresql.dispatcher.parser.statement.EndStatement;
import org.postgresql.dispatcher.parser.statement.MasterStatement;
import org.postgresql.dispatcher.parser.statement.OtherStatement;
import org.postgresql.dispatcher.parser.statement.SelectStatement;
import org.postgresql.dispatcher.parser.statement.SetStatement;
import org.postgresql.dispatcher.parser.statement.Statement;
import org.postgresql.dispatcher.parser.statement.TransactionStatement;
import org.postgresql.util.Word;

public class SqlParser {
    private Statement statement;
    private String commandText = "";
    private String strategyValue;

    public String getStrategyValue() {
        return this.strategyValue;
    }

    public SqlParser(String sql, String strategyValue) {
        this.commandText = sql.trim().endsWith(";") ? sql.trim().substring(0, sql.trim().length() - 1) : sql.trim();
        this.strategyValue = strategyValue;
    }

    public Statement doParse(DispatchConnection dispatchConnection) throws ParseException {
        try {
            this.statement = this.parse(dispatchConnection);
            this.statement.setCommandText(this.commandText);
            return this.statement;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Statement getParsedStatement() {
        return this.statement;
    }

    public final Statement parse(DispatchConnection dispatchConnection) throws SQLException {
        int result;
        AbstractStatement statement = null;
        String blackSqlList = PGProperty.BLACKSQLLIST.get(dispatchConnection.m_props);
        if (blackSqlList != null) {
            String[] sqls;
            for (String sql : sqls = blackSqlList.split(";")) {
                if (!sql.equalsIgnoreCase(this.commandText)) continue;
                return new MasterStatement();
            }
        }
        if (this.commandText.toLowerCase().startsWith("begin")) {
            return new BeginStatement();
        }
        if (this.commandText.toLowerCase().startsWith("commit") || this.commandText.toLowerCase().startsWith("rollback") || this.commandText.toLowerCase().startsWith("end")) {
            return new EndStatement();
        }
        if (this.commandText.toLowerCase().startsWith("set") || this.commandText.toLowerCase().startsWith("reset")) {
            return new SetStatement();
        }
        if (this.commandText.toLowerCase().contains("nextval") || this.commandText.toLowerCase().contains("currval") || this.commandText.toLowerCase().contains("setval") || this.commandText.toLowerCase().contains("lastval")) {
            return new OtherStatement();
        }
        statement = !dispatchConnection.getAutoCommit() ? (dispatchConnection.isHasUpdate() ? new TransactionStatement() : ("2".equals(this.strategyValue) ? ((result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword)) == 1 ? new SelectStatement() : (result == 2 ? new MasterStatement() : new OtherStatement())) : new TransactionStatement())) : (Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword) == 1 ? new SelectStatement() : new OtherStatement());
        return statement;
    }
}

