/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.core.SocketFactoryFactory;
import org.postgresql.jdbc.SslMode;
import org.postgresql.ssl.LibKCIFactory;
import org.postgresql.ssl.PGjdbcHostnameVerifier;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.ObjectFactory;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class MakeSSL
extends ObjectFactory {
    public static void convert(PGStream stream, Properties propInfo) throws PSQLException, IOException {
        SSLSocket newSSLSocketT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl", new Object[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SSLSocketFactory sslSocketFactoryT = SocketFactoryFactory.getSslSocketFactory(propInfo);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT = (SSLSocket)sslSocketFactoryT.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT.setUseClientMode(true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT.startHandshake();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (IOException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "SSL error: {0}";
            throw new PSQLException(GT.tr(e1, ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslSocketFactoryT instanceof LibKCIFactory) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((LibKCIFactory)sslSocketFactoryT).throwKeyManagerException();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SslMode sslModeT = SslMode.of(propInfo);
        if (sslModeT.verifyPeerName()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            MakeSSL.verifyPeerName(stream, propInfo, newSSLSocketT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stream.changeSocket(newSSLSocketT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void verifyPeerName(PGStream stream, Properties info, SSLSocket newConn) throws PSQLException {
        HostnameVerifier hvn;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslhostnameverifier = PGProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hvn = PGjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "KbjdbcHostnameVerifier";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                hvn = MakeSSL.instantiate(HostnameVerifier.class, sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "The HostnameVerifier class provided {0} could not be instantiated.";
                throw new PSQLException(GT.tr(e1, sslhostnameverifier), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (hvn.verify(stream.getHostSpec().getHost(), newConn.getSession())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String e1 = "The hostname {0} could not be verified by hostnameverifier {1}.";
        throw new PSQLException(GT.tr(e1, stream.getHostSpec().getHost(), sslhostnameverifier), PSQLState.CONNECTION_FAILURE);
    }
}

