/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.TraceLogger;

public class PSQLException
extends SQLException {
    private ServerErrorMessage serverError;

    public PSQLException(String msg, PSQLState state, Throwable cause) {
        super(msg, state == null ? null : state.getState(), cause);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PSQLException(String msg, PSQLState state) {
        super(msg, state == null ? null : state.getState());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PSQLException(ServerErrorMessage serverError) {
        this(serverError, true);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PSQLException(ServerErrorMessage serverError, boolean detail) {
        super(detail ? serverError.toString() : serverError.getNonSensitiveErrorMessage(), serverError.getSQLState());
        this.serverError = serverError;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public ServerErrorMessage getServerErrorMessage() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.serverError;
    }
}

