/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class LOGGER {
    private static final Object fileLock = new Object();
    private static PrintWriter logStream = null;
    private static boolean isFile = false;
    private static volatile int levelValue = Level.OFF.intValue();
    private static final int offValue = Level.OFF.intValue();

    public static boolean getLogger(String name) {
        return true;
    }

    public static boolean isLoggable(Level level) {
        return level.intValue() >= levelValue && levelValue != offValue;
    }

    public static void setLevel(Level newLevel) {
        levelValue = newLevel.intValue();
    }

    public static String logFormatter(String Cname, String Mname) {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String fString = "[" + df.format(day) + "] " + "[" + Thread.currentThread().getId() + "] " + "[" + Cname + "-->" + Mname + "] ";
        return fString;
    }

    public static void log(Level level, Exception e) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        if (isFile) {
            LOGGER.debug(e);
        } else {
            e.printStackTrace();
        }
    }

    public static void log(Level level, String msg, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        String classname = new Exception().getStackTrace()[1].getClassName();
        String method_name = new Exception().getStackTrace()[1].getMethodName();
        String message = "";
        for (int i = 0; i < params.length; ++i) {
            message = params[i] == null || params[i].toString() == null ? msg.replace("{" + i + "}", "null") : msg.replace("{" + i + "}", params[i].toString());
            msg = message;
        }
        message = LOGGER.logFormatter(classname, method_name) + msg;
        if (isFile) {
            LOGGER.debug(message);
        } else {
            System.out.println(message);
        }
    }

    public static void debug(String msg) {
        if (logStream != null) {
            logStream.println(msg);
            logStream.flush();
        }
    }

    public static void debug(Exception e) {
        if (logStream != null) {
            e.printStackTrace(logStream);
            logStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDebugStatus(String LogLevel, String LogFile) {
        boolean isDebug = false;
        Object object = fileLock;
        synchronized (object) {
            if ("OFF".equalsIgnoreCase(LogLevel)) {
                return false;
            }
            if ("INFO".equalsIgnoreCase(LogLevel)) {
                LOGGER.setLevel(Level.INFO);
                isDebug = true;
            } else if ("WARNING".equalsIgnoreCase(LogLevel)) {
                LOGGER.setLevel(Level.WARNING);
                isDebug = true;
            } else if ("DEBUG".equalsIgnoreCase(LogLevel)) {
                LOGGER.setLevel(Level.FINE);
                isDebug = true;
            } else if ("TRACE".equalsIgnoreCase(LogLevel)) {
                LOGGER.setLevel(Level.FINEST);
                isDebug = true;
            }
            if (LogFile != null && isDebug) {
                try {
                    logStream = new PrintWriter(new FileOutputStream(LogFile, true));
                    isFile = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to create log file : " + LogFile + ", no permission or directory does not exist.");
                }
            }
            return isDebug;
        }
    }
}

