/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGline
extends PGobject
implements Serializable,
Cloneable {
    public double c;
    public double b;
    public double a;

    public PGline(double a, double b, double c) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.c = c;
        this.a = a;
        this.b = b;
    }

    public PGline(double xx1, double y1, double x2, double y2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (xx1 == x2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = -1.0;
            this.b = 0.0;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = (y2 - y1) / (x2 - xx1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * xx1;
    }

    public PGline(PGpoint p1, PGpoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGline(PGlseg lseg) {
        this(lseg.pointArray[0], lseg.pointArray[1]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGline(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
    }

    public PGline() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("line");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s.trim().startsWith("{")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGtokenizer t = new PGtokenizer(PGtokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(t.getToken(0));
            this.b = Double.parseDouble(t.getToken(1));
            this.c = Double.parseDouble(t.getToken(2));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else if (s.trim().startsWith("[")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
            }
            PGpoint p1 = new PGpoint(t.getToken(0));
            PGpoint point2 = new PGpoint(t.getToken(1));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = point2.x - p1.x;
            this.b = point2.y - p1.y;
            this.c = p1.y;
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this == objt) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (objt == null || this.getClass() != objt.getClass()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (!super.equals(objt)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGline pGline = (PGline)objt;
        return Double.compare(pGline.a, this.a) == 0 && Double.compare(pGline.b, this.b) == 0 && Double.compare(pGline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        return _result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return super.clone();
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String v = "{" + this.a + "," + this.b + "," + this.c + "}";
        return v;
    }
}

