/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.core;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.postgresql.PGProperty;
import org.postgresql.dispatcher.entity.DispatchConnection;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class ConnectionMangerV2 {
    public static Map<String, ConnectionMangerV2> clustersMap = new HashMap<String, ConnectionMangerV2>();
    public static Object globallock = new Object();
    public Properties pros = new Properties();
    public String password;
    public String dbName;
    public String clusterKey;
    public ConcurrentHashMap<String, String> rates = new ConcurrentHashMap();
    public ConcurrentHashMap<String, AtomicInteger> _hostA_count = new ConcurrentHashMap();
    public ConcurrentHashMap<String, AtomicInteger> totalA_count = new ConcurrentHashMap();
    public AtomicInteger lastSlaveID = new AtomicInteger(0);
    public Object lock = new Object();
    public ClusterMonitorThread ctmonitor = null;
    public Thread thread_ct = null;
    public DispatchConnection ctmonitor_connect = null;
    public String slave_online_ip = new String("");
    public String master_online_ip = new String("");
    public Map<String, Integer> _connVersion = new HashMap<String, Integer>();
    public boolean monitorUp;
    public Map<String, String> nodeMap = new HashMap<String, String>();
    private BigDecimal differentLsn;

    public ConnectionMangerV2(String cluster_key, Properties ppros) throws PSQLException {
        String[] nodes;
        this.clusterKey = cluster_key;
        this.pros = new Properties(ppros);
        this.password = PGProperty.PASSWORD.get(this.pros);
        this.dbName = PGProperty.PG_DBNAME.get(this.pros);
        for (String node : nodes = PGProperty.NODE_LIST.get(this.pros) == null ? new String[]{} : PGProperty.NODE_LIST.get(this.pros).split(",")) {
            this._connVersion.put(node, 0);
        }
        this.initNodeMap(this.pros);
        if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
            try {
                this.differentLsn = new BigDecimal(PGProperty.DIFFERENT_LSN.get(this.pros));
            }
            catch (NumberFormatException e) {
                throw new PSQLException("The value of differentLsn must be a number,now is [" + PGProperty.DIFFERENT_LSN.get(this.pros) + "].", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)e);
            }
        }
        this.ctmonitor = new ClusterMonitorThread(this);
        this.thread_ct = new Thread((Runnable)this.ctmonitor, "JDBC cluster monitor [ " + this.clusterKey + " ] ");
        this.thread_ct.setDaemon(true);
        this.thread_ct.start();
        while (!this.monitorUp) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getClusterKey(Properties pros) throws SQLException {
        String temp;
        String[] slavePorts;
        String[] _hosts = PGProperty.PG_HOST.get(pros).split(",");
        String[] _hostPorts = PGProperty.PG_PORT.get(pros).split(",");
        String slaveList = PGProperty.SLAVE_ADD.get(pros);
        String slavePortList = PGProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length || _hosts.length != _hostPorts.length) {
            throw new PSQLException("The number of cluster machines's address does not match the number of cluster machines's ports.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        Object[] cluster_key = new String[slaves.length + _hosts.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < _hosts.length; ++i) {
            temp = _hosts[i] + ":" + _hostPorts[i];
            cluster_key[i] = temp;
        }
        for (j = 0; j < slaves.length; ++j) {
            temp = slaves[j] + ":" + slavePorts[j];
            cluster_key[j + i] = temp;
        }
        Arrays.sort(cluster_key);
        return Arrays.toString(cluster_key) + " " + "readListStrategy=" + PGProperty.READ_LIST_STRATEGY.getInt(pros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DispatchConnection createConnection(String url, String passward, String dbName, Properties pros) throws SQLException {
        String clusterKey = ConnectionMangerV2.getClusterKey(pros);
        if (clustersMap.get(clusterKey) == null) {
            Object object = globallock;
            synchronized (object) {
                if (clustersMap.get(clusterKey) == null) {
                    ConnectionMangerV2 tempCM2 = new ConnectionMangerV2(clusterKey, pros);
                    clustersMap.put(clusterKey, tempCM2);
                }
            }
        }
        ConnectionMangerV2 tempCM2 = clustersMap.get(clusterKey);
        DispatchConnection _conn = new DispatchConnection(null, passward, dbName, pros, tempCM2);
        if (tempCM2.rates.get(_conn.url) == null) {
            tempCM2.rates.put(_conn.url, PGProperty.HOSTLOADRATE.get(pros));
            tempCM2._hostA_count.put(_conn.url, new AtomicInteger(0));
            tempCM2.totalA_count.put(_conn.url, new AtomicInteger(0));
        }
        return _conn;
    }

    public void initNodeMap(Properties pros) throws PSQLException {
        int i;
        String[] slavePorts;
        String nodeList = PGProperty.NODE_LIST.get(pros);
        if (nodeList == null || nodeList.isEmpty()) {
            throw new PSQLException("The nodeList cannot be empty.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] nodes = nodeList.split(",");
        String[] _hosts = PGProperty.PG_HOST.get(pros).split(",");
        String[] _hostPorts = PGProperty.PG_PORT.get(pros).split(",");
        String slaveList = PGProperty.SLAVE_ADD.get(pros);
        String slavePortList = PGProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length) {
            throw new PSQLException("The number of standby machines does not match the number of ports.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (slaves.length + _hosts.length != nodes.length) {
            throw new PSQLException("The number of _hosts does not match the number of nodes.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        for (i = 0; i < _hosts.length; ++i) {
            this.nodeMap.put(_hosts[i] + ":" + _hostPorts[i], nodes[i]);
        }
        for (i = _hosts.length; i < nodes.length; ++i) {
            this.nodeMap.put(slaves[i - _hosts.length] + ":" + slavePorts[i - _hosts.length], nodes[i]);
        }
    }

    public class ClusterMonitorThread
    implements Runnable {
        private Properties pros;
        private ConnectionMangerV2 mCMV2;

        ClusterMonitorThread(ConnectionMangerV2 pCMV2) {
            this.mCMV2 = pCMV2;
            this.pros = new Properties(this.mCMV2.pros);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                while (true) {
                    int monitor_interval = PGProperty.MONITORINTERVAL.getIntNoCheck(this.pros);
                    try {
                        if (ConnectionMangerV2.this.ctmonitor_connect == null) {
                            LOGGER.log(Level.SEVERE, "create new ctmonitor_connect", new Object[0]);
                            this.pros.setProperty("isMonitor", "true");
                            this.pros.setProperty("socketTimeout", PGProperty.MONITOR_SOCKET_TIMEOUT.getInt(this.pros) + "");
                            Map<String, Integer> map = ConnectionMangerV2.this._connVersion;
                            synchronized (map) {
                                for (String ip : ConnectionMangerV2.this._connVersion.keySet()) {
                                    ConnectionMangerV2.this._connVersion.put(ip, ConnectionMangerV2.this._connVersion.get(ip) + 1);
                                }
                            }
                            ConnectionMangerV2.this.ctmonitor_connect = new DispatchConnection(null, ConnectionMangerV2.this.password, ConnectionMangerV2.this.dbName, this.pros, this.mCMV2);
                        }
                        ConnectionMangerV2.this.master_online_ip = ConnectionMangerV2.this.nodeMap.get(((PgConnection)ConnectionMangerV2.this.ctmonitor_connect.getMainConn()).getHostIp() + ":" + ((PgConnection)ConnectionMangerV2.this.ctmonitor_connect.getMainConn()).getHostPort());
                        String _sql = "select application_name";
                        if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 2 || PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 4) {
                            _sql = _sql + ",sync_state";
                        } else if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
                            _sql = _sql + ",pg_wal_lsn_diff(pg_current_wal_flush_lsn(), replay_lsn)";
                        }
                        _sql = _sql + " from pg_stat_replication";
                        Statement stcheck = ConnectionMangerV2.this.ctmonitor_connect.getMainConn().createStatement();
                        ResultSet resultSet = stcheck.executeQuery(_sql);
                        String sip = "";
                        while (resultSet.next()) {
                            if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 2) {
                                if (!"sync".equalsIgnoreCase(resultSet.getString(2))) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
                                if (resultSet.getBigDecimal(2).compareTo(ConnectionMangerV2.this.differentLsn) > 0) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            if (PGProperty.READ_LIST_STRATEGY.getInt(this.pros) == 4) {
                                if ("sync".equalsIgnoreCase(resultSet.getString(2))) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            sip = sip + resultSet.getString(1);
                            sip = sip + ",";
                        }
                        resultSet.close();
                        ConnectionMangerV2.this.slave_online_ip = sip;
                        if (ConnectionMangerV2.this.slave_online_ip.isEmpty()) {
                            Boolean bmaster = false;
                            _sql = String.format("select * from pg_is_in_recovery()", new Object[0]);
                            resultSet = stcheck.executeQuery(_sql);
                            if (resultSet.next()) {
                                bmaster = !resultSet.getBoolean(1);
                            }
                            resultSet.close();
                            if (!bmaster.booleanValue()) {
                                try {
                                    ConnectionMangerV2.this.master_online_ip = "";
                                    ConnectionMangerV2.this.ctmonitor_connect.CloseConnectCluter();
                                    ConnectionMangerV2.this.ctmonitor_connect = null;
                                }
                                catch (SQLException e1) {
                                    ConnectionMangerV2.this.ctmonitor_connect = null;
                                }
                            }
                        }
                        LOGGER.log(Level.SEVERE, "ClusterMonitorThread master online: {0}, current slave online: {1}, cluster_key: {2}", ConnectionMangerV2.this.master_online_ip, ConnectionMangerV2.this.slave_online_ip, this.mCMV2.clusterKey);
                        stcheck.close();
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info Exception: {0} {1}", e.getMessage(), this.mCMV2.clusterKey);
                        LOGGER.log(Level.SEVERE, e);
                        ConnectionMangerV2.this.slave_online_ip = "";
                        ConnectionMangerV2.this.master_online_ip = "";
                        if (ConnectionMangerV2.this.ctmonitor_connect != null) {
                            try {
                                ConnectionMangerV2.this.ctmonitor_connect.CloseConnectCluter();
                                ConnectionMangerV2.this.ctmonitor_connect = null;
                                LOGGER.log(Level.SEVERE, "close CloseConnectCluter normal", new Object[0]);
                            }
                            catch (SQLException e1) {
                                ConnectionMangerV2.this.ctmonitor_connect = null;
                                LOGGER.log(Level.SEVERE, "close CloseConnectCluter exception:{0}", e1);
                            }
                        }
                    }
                    catch (Exception e2) {
                        ConnectionMangerV2.this.ctmonitor_connect = null;
                        LOGGER.log(Level.SEVERE, "close CloseConnectCluter exception:{0}", e2);
                    }
                    finally {
                        ConnectionMangerV2.this.monitorUp = true;
                    }
                    Thread.sleep(monitor_interval * 1000);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info InterruptedException: {0} {1}", e.getMessage(), this.mCMV2.clusterKey);
                LOGGER.log(Level.SEVERE, e);
                return;
            }
        }
    }
}

