/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.ParameterList;
import org.postgresql.core.QueryExecutor;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

@Deprecated
public class Fastpath {
    private static final long NUM_OIDS_NUMBER = 0x100000000L;
    private final Map<String, Integer> func = new HashMap<String, Integer>();
    private final QueryExecutor exec;
    private final BaseConnection _connection;

    public Fastpath(BaseConnection _conn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = _conn;
        this.exec = _conn.getQueryExecutor();
    }

    @Deprecated
    public Object fp(int fnId, boolean _resultType, FastpathArg[] args) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] returnBytes = this.fp(fnId, args);
        if (returnBytes == null || !_resultType) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return returnBytes;
        }
        if (4 == returnBytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int4(returnBytes, 0);
        }
        if (returnBytes.length == 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int8(returnBytes, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Fastpath call {0} - No _result was returned and we expected a numeric.", fnId), PSQLState.NO_DATA);
    }

    public byte[] fp(int fnId, FastpathArg[] fastpathArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParameterList _params = this.exec.createFastpathParameters(fastpathArgs.length);
        for (int i = 0; i < fastpathArgs.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            fastpathArgs[i].populateParameter(_params, i + 1);
        }
        return this.exec.fpCall(fnId, _params, this._connection.getAutoCommit());
    }

    @Deprecated
    public Object fp(String name, boolean _resulttype, FastpathArg[] args) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "Fastpath: calling {0}", name);
        return this.fp(this.getID(name), _resulttype, args);
    }

    public byte[] fp(String name, FastpathArg[] args) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, "Fastpath: calling {0}", name);
        return this.fp(this.getID(name), args);
    }

    public int getInteger(String name, FastpathArg[] fastpathArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] returnBytes = this.fp(name, fastpathArgs);
        if (null == returnBytes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Fastpath call {0} - No _result was returned and we expected an integer.", name), PSQLState.NO_DATA);
        }
        if (4 == returnBytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int4(returnBytes, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Fastpath call {0} - No _result was returned or wrong size while expecting an integer.", name), PSQLState.NO_DATA);
    }

    public long getLong(String name, FastpathArg[] fastpathArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] returnBytes = this.fp(name, fastpathArgs);
        if (null == returnBytes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Fastpath call {0} - No _result was returned and we expected a long.", name), PSQLState.NO_DATA);
        }
        if (8 == returnBytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int8(returnBytes, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Fastpath call {0} - No _result was returned or wrong size while expecting a long.", name), PSQLState.NO_DATA);
    }

    public long getOID(String name, FastpathArg[] fastpathArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long oidLong = this.getInteger(name, fastpathArgs);
        if (oidLong < 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oidLong += 0x100000000L;
        }
        return oidLong;
    }

    public byte[] getData(String name, FastpathArg[] fastpathArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fp(name, fastpathArgs);
    }

    public void addFunction(String name, int functionId) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.func.put(name, functionId);
    }

    public void addFunctions(ResultSet resultSet) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.func.put(resultSet.getString(1), resultSet.getInt(2));
        }
    }

    public int getID(String name) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer id = this.func.get(name);
        if (id == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("The fp function {0} is unknown.", name), PSQLState.UNEXPECTED_ERROR);
        }
        return id;
    }

    public static FastpathArg createOIDArg(long oidLong) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (Integer.MAX_VALUE < oidLong) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oidLong -= 0x100000000L;
        }
        return new FastpathArg((int)oidLong);
    }
}

