/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.entity;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.PGProperty;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ReplicationProtocol;
import org.postgresql.core.TransactionState;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Version;
import org.postgresql.dispatcher.core.ConnectionMangerV2;
import org.postgresql.dispatcher.entity.FakeConnection;
import org.postgresql.dispatcher.executor.DispatchCallableStatementV2;
import org.postgresql.dispatcher.executor.DispatchPreparedStatementV2;
import org.postgresql.dispatcher.executor.DispatchStatementV2;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.jdbc.AutoSave;
import org.postgresql.jdbc.FieldMetadata;
import org.postgresql.jdbc.PSQLSavepoint;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.replication.PGReplicationConnection;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.LruCache;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class DispatchConnection
implements BaseConnection {
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private int transStatus;
    private Connection mainConn;
    boolean bmaster_check = false;
    public int retrytimes = 0;
    public int retryinterval = 0;
    SQLException master_error = null;
    private String lastSqlType;
    public String passward;
    public String dbName;
    public Properties m_props = new Properties();
    public String url;
    private Map<String, Connection> slaveConnMap = new HashMap<String, Connection>();
    private Map<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
    public static String SLAVE = "slave";
    public int slaveCount;
    public List<String> whiteList = null;
    public List<String> blackList = null;
    public List<String> masterFunctionList = null;
    public List<String> tempTables = null;
    public String masterKeyword = null;
    protected volatile boolean autoCommit = true;
    protected volatile boolean hasUpdate = false;
    private int rsHoldability = 2;
    private boolean readOnly = false;
    private AutoSave autoSave;
    private int fetchSize;
    private int level = 0;
    protected Map<String, Class<?>> typemap;
    private Properties _clientInfo;
    private boolean flushCacheOnDeallocate;
    private int threshold;
    private String schema;
    private Executor executor;
    private int networkTimeout;
    private boolean hasSetNetworkTimeout;

    public String getLastSqlType() {
        return this.lastSqlType;
    }

    public void setLastSqlType(String lastSqlType) {
        this.lastSqlType = lastSqlType;
    }

    public Connection getMainConn() throws SQLException {
        if (this.mainConn != null && !this.mainConn.isClosed()) {
            return this.mainConn;
        }
        String hostip = Driver.hostSpecs(this.m_props)[0].getHost();
        int hostport = Driver.hostSpecs(this.m_props)[0].getPort();
        String node = ConnectionMangerV2.nodeMap.get(hostip + ":" + hostport);
        if (this.m_props.getProperty("isMonitor") == null && !ConnectionMangerV2.master_online_ip.equals(node) && !ConnectionMangerV2.slave_online_ip.contains(node + ",")) {
            String debugmsg = String.format("Create Fake Master connection for : {%s} ", node);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            this.mainConn = new FakeConnection("masterkey", hostip, hostport);
            return this.mainConn;
        }
        boolean bconnect = true;
        PgConnection con = null;
        try {
            con = new PgConnection(Driver.hostSpecs(this.m_props), Driver.user(this.m_props), Driver.database(this.m_props), this.m_props, this.url, ConnectionMangerV2.connVersion.get(node));
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Master connection for : {%s} Exception: {%s}", node, e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                LOGGER.log(Level.SEVERE, e);
            }
            if (!this.bmaster_check) {
                throw new SQLException(e);
            }
            this.master_error = new SQLException(e);
            bconnect = false;
        }
        if (!bconnect) {
            this.mainConn = new FakeConnection("masterkey", hostip, hostport);
            return this.mainConn;
        }
        con.setDispatchConn(this);
        con.setIsSlave(false);
        this.mainConn = con;
        return this.mainConn;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public DispatchConnection(PgConnection main_Conn, String pass_ward, String db_Name, Properties prop_s) throws SQLException {
        this.mainConn = main_Conn;
        this.passward = pass_ward;
        this.dbName = db_Name;
        this.m_props = prop_s;
        this.bmaster_check = PGProperty.MASTER_CHECK.getBoolean(prop_s);
        this.retrytimes = PGProperty.RETRYTIMES.getIntNoCheck(prop_s);
        this.retryinterval = PGProperty.RETRYINTERVAL.getIntNoCheck(prop_s);
        this.whiteList = this.initFunctionList(PGProperty.WHITELIST.get(prop_s));
        this.blackList = this.initFunctionList(PGProperty.BLACKLIST.get(prop_s));
        this.masterFunctionList = this.initFunctionList(PGProperty.MASTERFUNCTIONLIST.get(prop_s));
        this.tempTables = this.initFunctionList(PGProperty.TEMPTABLE.get(prop_s));
        this.masterKeyword = PGProperty.MASTER_KEYWORD.get(prop_s);
        this.initSlavesInfo(this.m_props);
        this.url = this.getUrl();
        this.getMasterConnection();
        this.getAllSlaveConn();
        if (this.bmaster_check) {
            this.CheckClusteInfo(prop_s);
        }
        this.replicationConnection = PGProperty.REPLICATION.get(this.m_props) != null;
    }

    public List<String> initFunctionList(String function) {
        if (function != null) {
            String[] funs;
            ArrayList<String> functions = new ArrayList<String>();
            for (String fun : funs = function.split(";")) {
                int start = 0;
                int index = fun.indexOf("\"", start);
                String str = "";
                boolean flag = false;
                while (index != -1) {
                    str = !flag ? str + fun.substring(start, index).toLowerCase() : str + fun.substring(start, index);
                    flag = !flag;
                    start = index + 1;
                    index = fun.indexOf("\"", start);
                }
                str = str + fun.substring(start, fun.length()).toLowerCase();
                functions.add(str);
            }
            return functions;
        }
        return null;
    }

    public void initSlavesInfo(Properties props) throws PSQLException {
        int index;
        String[] slave_port;
        String slaveadd = PGProperty.SLAVE_ADD.get(props);
        String slaveport = PGProperty.SLAVE_PORT.get(props);
        this.slaveConnInfo.clear();
        this.slaveCount = 0;
        if (slaveadd == null || slaveadd.isEmpty() || slaveport == null || slaveport.isEmpty()) {
            return;
        }
        String[] slave_add = slaveadd.split(",");
        if (slave_add.length != (slave_port = slaveport.split(",")).length) {
            throw new PSQLException("The number of standby machines does not match the number of ports.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        int count = slave_add.length;
        for (index = 0; index < count; ++index) {
            String key = "slave" + index;
            HashMap<String, String> info = new HashMap<String, String>();
            this.slaveConnInfo.put(key, info);
            info.put("ADDRESS", slave_add[index]);
            info.put("PORT", slave_port[index]);
        }
        this.slaveCount = index;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, " slaveConnInfo (session={0} ADDRESS={1},PORT={2})", this, slaveadd, slaveport);
        }
    }

    public Connection createSlaveConnection(String key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(key);
        String url = "jdbc:kingbase8://" + infoMap.get("ADDRESS") + ":" + infoMap.get("PORT") + "/" + this.dbName;
        LOGGER.log(Level.SEVERE, "createSlaveConnection key " + key + " " + url, new Object[0]);
        String host = infoMap.get("ADDRESS") + ":" + infoMap.get("PORT");
        String node = ConnectionMangerV2.nodeMap.get(host);
        if (this.m_props.getProperty("isMonitor") == null && !ConnectionMangerV2.slave_online_ip.contains(node + ",") && !ConnectionMangerV2.master_online_ip.equals(node)) {
            String debugmsg = String.format("Create Fake Slave connection for : {key:%s %s} ", key, node);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            Connection tagConn = this.setSlaveToFakebyKey(key);
            return tagConn;
        }
        try {
            PgConnection conn = null;
            Properties slave_props = new Properties(this.m_props);
            slave_props.setProperty("PGHOST", infoMap.get("ADDRESS"));
            slave_props.setProperty("PGPORT", infoMap.get("PORT"));
            conn = new PgConnection(Driver.hostSpecs(slave_props), Driver.user(slave_props), Driver.database(slave_props), slave_props, url, ConnectionMangerV2.connVersion.get(node));
            conn.setDispatchConn(this);
            conn.setMasterConnection(this.mainConn);
            conn.setIsSlave(true);
            this.slaveConnMap.put(key, conn);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "create SlaveConnection success (session={0} url={1})", this, url);
            }
            return conn;
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Slave connection for : {key:%s %s} Exception: {%s}", key, node, e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                LOGGER.log(Level.SEVERE, e);
            }
            Connection tagConn = this.setSlaveToFakebyKey(key);
            return tagConn;
        }
    }

    public Connection setSlaveToFakebyKey(String key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(key);
        String debugmsg = String.format("set Slave connection to Fake state for : {key:%s %s} ", key, infoMap.get("ADDRESS") + ":" + infoMap.get("PORT"));
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
        }
        FakeConnection tagConn = new FakeConnection(key, infoMap.get("ADDRESS"), Integer.valueOf(infoMap.get("PORT")));
        this.slaveConnMap.put(key, tagConn);
        return tagConn;
    }

    public Connection getSlaveConnection(String key) throws SQLException {
        LOGGER.log(Level.INFO, "getSlaveConnection key:" + key, new Object[0]);
        if (key == null) {
            return this.mainConn;
        }
        Connection conn = null;
        if (!this.slaveConnMap.containsKey(key)) {
            conn = this.createSlaveConnection(key);
        } else {
            conn = this.slaveConnMap.get(key);
            if (conn == null || conn.isClosed() && !(conn instanceof FakeConnection) || conn instanceof FakeConnection && ((FakeConnection)conn).getSlaveStatus()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg;
                    if (conn instanceof FakeConnection) {
                        String node = ConnectionMangerV2.nodeMap.get(((FakeConnection)conn).getSlaveIP() + ":" + ((FakeConnection)conn).getSlavePort());
                        debugmsg = String.format("getSlaveConnection recreate fake slave connection for : {%s}", node);
                        ConnectionMangerV2.connVersion.put(node, ConnectionMangerV2.connVersion.get(node) + 1);
                    } else {
                        debugmsg = conn != null ? String.format("getSlaveConnection recreate PgConnection slave connection for : {%s}", ((PgConnection)conn).getURL()) : String.format("getSlaveConnection recreate null slave connection", new Object[0]);
                    }
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                conn = this.createSlaveConnection(key);
            }
        }
        return conn;
    }

    public List<Connection> getAllSlaveConn() throws SQLException {
        LOGGER.log(Level.INFO, "getAllSlaveConn slaveCount:" + this.slaveCount + "\n", new Object[0]);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (int i = 0; i < this.slaveCount; ++i) {
            String key = SLAVE + i;
            conns.add(this.getSlaveConnection(key));
        }
        return conns;
    }

    protected String getUrl() {
        String url = "jdbc:kingbase8://" + PGProperty.PG_HOST.get(this.m_props) + ":" + PGProperty.PG_PORT.get(this.m_props) + "/" + this.dbName + "?hostLoadRate=" + PGProperty.HOSTLOADRATE.get(this.m_props);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block11: {
            Boolean useconn_pool = PGProperty.USECONNECT_POOL.getBoolean(this.m_props);
            if (useconn_pool.booleanValue()) {
                LOGGER.log(Level.INFO, "dispatch close():::connect pool reset this connect to idle sessionID: {0}", this);
                Object object = ConnectionMangerV2.lock;
                synchronized (object) {
                    if (!ConnectionMangerV2.pool_used.isEmpty()) {
                        ConnectionMangerV2.pool_used.remove(this);
                    }
                    if (!this.isClosed()) {
                        ConnectionMangerV2.pool_available.push(this);
                    }
                }
                return;
            }
            try {
                LOGGER.log(Level.INFO, "dispatch close()", new Object[0]);
                this.mainConn.close();
            }
            catch (SQLException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void checkslavestatus() throws SQLException {
        for (int i = 0; i < this.slaveCount; ++i) {
            String key = SLAVE + i;
            Connection con = this.getSlaveConnection(key);
            if (con instanceof FakeConnection) {
                String node = ConnectionMangerV2.nodeMap.get(((FakeConnection)con).getSlaveIP() + ":" + ((FakeConnection)con).getSlavePort());
                if (!ConnectionMangerV2.slave_online_ip.contains(node + ",") && !ConnectionMangerV2.master_online_ip.equals(node)) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg = String.format("checkslavestatus recreate slave connection for : {%s}", ((FakeConnection)con).getSlaveIP());
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                ((FakeConnection)con).setSlaveStatus(true);
                continue;
            }
            try {
                if (con.isValid(5)) continue;
                con.close();
                LOGGER.log(Level.INFO, "checkslavestatus: find connect on " + ((PgConnection)con).getHostIp() + " is invalid  need reconnect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(key, ((PgConnection)con).getHostIp(), ((PgConnection)con).getHostPort());
                this.slaveConnMap.put(key, tagConn);
                tagConn.setSlaveStatus(false);
                continue;
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "checkslavestatus Exception: " + e.getMessage() + " find connect on " + ((PgConnection)con).getHostIp() + " is invalid  need reconnect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(key, ((PgConnection)con).getHostIp(), ((PgConnection)con).getHostPort());
                this.slaveConnMap.put(key, tagConn);
                tagConn.setSlaveStatus(false);
            }
        }
    }

    public boolean checkslaveisup(String slaveip) throws SQLException {
        boolean bres = false;
        Connection conn = this.mainConn;
        String sql = String.format("select CLIENT_ADDR from pg_stat_replication where CLIENT_ADDR = '%s' ", slaveip);
        try {
            if (conn == null || conn instanceof FakeConnection) {
                return false;
            }
            if (conn.isClosed()) {
                return false;
            }
            Statement stcheck = conn.createStatement();
            ResultSet rs = stcheck.executeQuery(sql);
            bres = rs.next();
            LOGGER.log(Level.INFO, "checkslaveisup: " + sql + " slaveip: " + slaveip + " status: " + bres, new Object[0]);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public void CloseConnectCluter() throws SQLException {
        try {
            LOGGER.log(Level.INFO, "recreate cluster connection", new Object[0]);
            this.mainConn.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                Connection con = it.next();
                con.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void ReConnectCluter() throws SQLException {
        this.getMasterConnection();
        this.checkslavestatus();
        this.getAllSlaveConn();
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((PgConnection)this.mainConn).clearWarnings();
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.clearWarnings();
        }
    }

    @Override
    public void commit() throws SQLException {
        LOGGER.log(Level.INFO, " commit", new Object[0]);
        this.mainConn.commit();
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.commit();
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.mainConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.mainConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mainConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.mainConn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.mainConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.mainConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mainConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mainConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.mainConn.nativeSQL(sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DispatchStatementV2(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new DispatchCallableStatementV2(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mainConn.releaseSavepoint(((PSQLSavepoint)savepoint).clone());
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.releaseSavepoint(((PSQLSavepoint)savepoint).clone());
        }
        ((PSQLSavepoint)savepoint).invalidate();
    }

    @Override
    public void rollback() throws SQLException {
        LOGGER.log(Level.INFO, " rollback", new Object[0]);
        this.mainConn.rollback();
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.rollback();
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        LOGGER.log(Level.INFO, "  rollback {0}", savepoint);
        this.mainConn.rollback(savepoint);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        LOGGER.log(Level.INFO, "  setAutoCommit = {0}", autoCommit);
        this.mainConn.setAutoCommit(autoCommit);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setAutoCommit(autoCommit);
        }
        if (this.autoCommit != autoCommit) {
            this.autoCommit = autoCommit;
            this.setHasUpdate(false);
            this.setLastSqlType(null);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.mainConn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.rsHoldability = holdability;
        this.mainConn.setHoldability(holdability);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setHoldability(holdability);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.mainConn.setReadOnly(readOnly);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setReadOnly(readOnly);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setSavepoint();
        }
        return this.mainConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setSavepoint(name);
        }
        return this.mainConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.level = level;
        this.mainConn.setTransactionIsolation(level);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setTransactionIsolation(level);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
        this.mainConn.setTypeMap(map);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setTypeMap(map);
        }
    }

    public void addWarning(SQLWarning warn) {
        ((PgConnection)this.mainConn).addWarning(warn);
    }

    @Override
    public void cancelQuery() throws SQLException {
        ((PgConnection)this.mainConn).cancelQuery();
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return ((PgConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        return ((PgConnection)this.mainConn).execSQLQuery(s, resultSetType, resultSetConcurrency);
    }

    public String getCursorName() throws SQLException {
        return ((PgConnection)this.mainConn).getCursorName();
    }

    @Override
    public Encoding getEncoding() {
        return ((PgConnection)this.mainConn).getEncoding();
    }

    public void setCursorName(String cursor) throws SQLException {
        ((PgConnection)this.mainConn).setCursorName(cursor);
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getFastpathAPI();
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return ((PgConnection)this.mainConn).getQueryExecutor();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            LOGGER.log(Level.WARNING, GT.tr("Validating connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setMasterConnection(Connection conn) {
        this.mainConn = (PgConnection)conn;
        ((PgConnection)this.mainConn).setDispatchConn(this);
        ((PgConnection)this.mainConn).setIsSlave(false);
    }

    public boolean CheckIsMaster(Connection conn) {
        boolean bres = false;
        try {
            if (conn == null || conn instanceof FakeConnection) {
                return bres;
            }
            LOGGER.log(Level.INFO, "CheckIsMaster" + ((PgConnection)conn).getURL() + "\n", new Object[0]);
            if (conn.isClosed()) {
                return bres;
            }
            Statement stcheck = conn.createStatement();
            ResultSet rs = stcheck.executeQuery("select * from pg_is_in_recovery()");
            if (rs.next()) {
                bres = !rs.getBoolean(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public Properties UpdateSlaveinfoFromMaster(Properties props) throws SQLException {
        Statement stcheck = this.mainConn.createStatement();
        ResultSet rs = stcheck.executeQuery("select CLIENT_ADDR from sys_stat_replication ");
        StringBuffer slave_ip = new StringBuffer("");
        while (rs.next()) {
            if (slave_ip.length() == 0) {
                slave_ip.append(rs.getString("CLIENT_ADDR"));
                continue;
            }
            slave_ip.append(",");
            slave_ip.append(rs.getString("CLIENT_ADDR"));
        }
        PGProperty.SLAVE_ADD.set(props, slave_ip.toString());
        stcheck.close();
        Properties props_new = new Properties(props);
        return props_new;
    }

    public boolean CheckClusteInfo(Properties prop_s) throws SQLException {
        Connection old_mainconn;
        boolean bMasterChange = false;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "CheckClusteInfo prop_s  host: " + PGProperty.PG_HOST.get(prop_s) + ":" + PGProperty.PG_PORT.get(prop_s) + " slaveadd: " + PGProperty.SLAVE_ADD.get(prop_s) + ":" + PGProperty.SLAVE_PORT.get(prop_s) + "\n", new Object[0]);
        }
        if ((old_mainconn = this.mainConn) == null) {
            // empty if block
        }
        if (this.CheckIsMaster(this.mainConn)) {
            return bMasterChange;
        }
        bMasterChange = true;
        if (bMasterChange) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "CheckClusteInfo slaveConnMap size()" + this.slaveConnMap.size() + " " + this.slaveConnMap.toString() + "\n", new Object[0]);
            }
            for (Map.Entry<String, Connection> entry : this.slaveConnMap.entrySet()) {
                String key = entry.getKey();
                Connection slavecon = entry.getValue();
                if (!this.CheckIsMaster(slavecon)) continue;
                this.setMasterConnection(slavecon);
                if (!(old_mainconn instanceof FakeConnection)) {
                    ((PgConnection)old_mainconn).setIsSlave(true);
                }
                this.slaveConnMap.put(key, old_mainconn);
                bMasterChange = true;
                String old_masterip = PGProperty.PG_HOST.get(prop_s);
                String new_masterip = ((PgConnection)slavecon).getHostIp();
                PGProperty.PG_HOST.set(prop_s, new_masterip);
                String old_slaveip = PGProperty.SLAVE_ADD.get(prop_s);
                String new_slaveip = old_slaveip.replace(new_masterip, old_masterip);
                PGProperty.SLAVE_ADD.set(prop_s, new_slaveip);
                String old_masterport = PGProperty.PG_PORT.get(prop_s);
                String new_masterport = String.valueOf(((PgConnection)slavecon).getHostPort());
                PGProperty.PG_PORT.set(prop_s, new_masterport);
                String old_slaveport = PGProperty.SLAVE_PORT.get(prop_s);
                String[] slaveports = old_slaveport.split(",");
                int index = Integer.valueOf(key.substring(5));
                slaveports[index] = old_masterport;
                String new_slaveport = "";
                for (int i = 0; i < slaveports.length; ++i) {
                    new_slaveport = new_slaveport + slaveports[i] + ",";
                }
                new_slaveport = new_slaveport.substring(0, new_slaveport.length() - 1);
                PGProperty.SLAVE_PORT.set(prop_s, new_slaveport);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("ADDRESS", old_masterip);
                info.put("PORT", old_masterport);
                this.slaveConnInfo.put(key, info);
                this.m_props = prop_s;
                if (!LOGGER.isLoggable(Level.INFO)) break;
                String debugmsg = String.format("CheckClusteInfo::Cluster Change Master DB from " + old_masterip + ":" + old_masterport + " to " + new_masterip + ":" + new_masterport, new Object[0]);
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                break;
            }
        }
        if (!this.CheckIsMaster(this.mainConn)) {
            throw new PSQLException("JDBC can't find a vaild master database in cluster...", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return bMasterChange;
    }

    @Override
    public Connection getMasterConnection() throws SQLException {
        return this.getMainConn();
    }

    public Properties getConnectionProperties() {
        return this.m_props;
    }

    public void setConnectionProperties(Properties props) {
        this.m_props = props;
    }

    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    public int getTransStatus() {
        return this.transStatus;
    }

    public boolean isCompatibleOldDateFormat() {
        return false;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
    }

    @Override
    public boolean isZeroResend() {
        return false;
    }

    public boolean isUseSlaveSynRead() {
        return false;
    }

    public boolean checkDBLinkSql() {
        return false;
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        return ((PgConnection)this.mainConn).getNotifications();
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getCopyAPI();
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getLargeObjectAPI();
    }

    @Override
    public void addDataType(String type, String className) {
        ((PgConnection)this.mainConn).addDataType(type, className);
    }

    @Override
    public void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        ((PgConnection)this.mainConn).addDataType(type, klass);
    }

    @Override
    public void setPrepareThreshold(int threshold) {
        this.threshold = threshold;
        ((PgConnection)this.mainConn).setPrepareThreshold(threshold);
        try {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                ((PgConnection)connection).setPrepareThreshold(threshold);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPrepareThreshold() {
        return ((PgConnection)this.mainConn).getPrepareThreshold();
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
        ((PgConnection)this.mainConn).setDefaultFetchSize(fetchSize);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            ((PgConnection)connection).setDefaultFetchSize(fetchSize);
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return ((PgConnection)this.mainConn).getDefaultFetchSize();
    }

    @Override
    public int getBackendPID() {
        return ((PgConnection)this.mainConn).getBackendPID();
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return ((PgConnection)this.mainConn).escapeIdentifier(identifier);
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return ((PgConnection)this.mainConn).escapeIdentifier(literal);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return ((PgConnection)this.mainConn).getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return ((PgConnection)this.mainConn).getAutosave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.autoSave = autoSave;
        ((PgConnection)this.mainConn).setAutosave(autoSave);
        try {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                ((PgConnection)connection).setAutosave(autoSave);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PGReplicationConnection getReplicationAPI() {
        return ((PgConnection)this.mainConn).getReplicationAPI();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.mainConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.mainConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.mainConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.mainConn.createSQLXML();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.mainConn.setClientInfo(name, value);
        try {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                ((PgConnection)connection).setClientInfo(name, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._clientInfo = properties;
        this.mainConn.setClientInfo(properties);
        try {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                ((PgConnection)connection).setClientInfo(properties);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.mainConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.mainConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.mainConn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.mainConn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.schema = schema;
        ((PgConnection)this.mainConn).setSchema(schema);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            ((PgConnection)connection).setSchema(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return ((PgConnection)this.mainConn).getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        ((PgConnection)this.mainConn).abort(executor);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            ((PgConnection)connection).abort(executor);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.executor = executor;
        this.networkTimeout = milliseconds;
        this.hasSetNetworkTimeout = true;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.hasSetNetworkTimeout) {
            return this.networkTimeout;
        }
        return PGProperty.SOCKET_TIMEOUT.getInt(this.m_props) * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(PgConnection.class)) {
            return this.mainConn.unwrap(iface);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.mainConn.isWrapperFor(iface);
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        ((PgConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return ((PgConnection)this.mainConn).getReplicationProtocol();
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        return ((PgConnection)this.mainConn).getObject(type, value, byteValue);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return ((PgConnection)this.mainConn).getTypeInfo();
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return ((PgConnection)this.mainConn).haveMinimumServerVersion(ver);
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return ((PgConnection)this.mainConn).haveMinimumServerVersion(ver);
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        return ((PgConnection)this.mainConn).encodeString(str);
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return ((PgConnection)this.mainConn).escapeString(str);
    }

    @Override
    public boolean getStandardConformingStrings() {
        return ((PgConnection)this.mainConn).getStandardConformingStrings();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return ((PgConnection)this.mainConn).getTimestampUtils();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return ((PgConnection)this.mainConn).getStringVarcharFlag();
    }

    @Override
    public TransactionState getTransactionState() {
        return ((PgConnection)this.mainConn).getTransactionState();
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return ((PgConnection)this.mainConn).binaryTransferSend(oid);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return ((PgConnection)this.mainConn).isColumnSanitiserDisabled();
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        ((PgConnection)this.mainConn).addTimerTask(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        ((PgConnection)this.mainConn).purgeTimerTasks();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return ((PgConnection)this.mainConn).getFieldMetadataCache();
    }

    @Override
    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return ((PgConnection)this.mainConn).createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
        ((PgConnection)this.mainConn).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        try {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                ((PgConnection)connection).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object elements) throws SQLException {
        return ((PgConnection)this.mainConn).createArrayOf(typeName, elements);
    }

    @Override
    public PGNotification[] getNotifications(int timeoutMillis) throws SQLException {
        return ((PgConnection)this.mainConn).getNotifications(timeoutMillis);
    }

    @Override
    public Map<String, String> getParameterStatuses() {
        return ((PgConnection)this.mainConn).getParameterStatuses();
    }

    @Override
    public String getParameterStatus(String parameterName) {
        return ((PgConnection)this.mainConn).getParameterStatus(parameterName);
    }

    @Override
    public boolean hintReadOnly() {
        return ((PgConnection)this.mainConn).hintReadOnly();
    }

    public void resetConnInfo() throws SQLException {
        if (!this.autoCommit) {
            this.setAutoCommit(this.autoCommit);
        }
        if (this._clientInfo != null) {
            this.setClientInfo(this._clientInfo);
        }
        if (this.readOnly) {
            this.setReadOnly(this.readOnly);
        }
        if (this.rsHoldability != 2) {
            this.setHoldability(this.rsHoldability);
        }
        if (this.level != 0) {
            this.setTransactionIsolation(this.level);
        }
        if (this.typemap != null) {
            this.setTypeMap(this.typemap);
        }
        if (this.networkTimeout != 0) {
            this.setNetworkTimeout(this.executor, this.networkTimeout);
        }
        if (this.autoSave != null) {
            this.setAutosave(this.autoSave);
        }
        if (this.fetchSize != 0) {
            this.setDefaultFetchSize(this.fetchSize);
        }
        if (!this.flushCacheOnDeallocate) {
            this.setFlushCacheOnDeallocate(this.flushCacheOnDeallocate);
        }
        if (this.threshold != 5) {
            this.setPrepareThreshold(this.threshold);
        }
        if (this.schema != null) {
            this.setSchema(this.schema);
        }
    }

    @Override
    public String getCompatibleLevel() {
        return ((PgConnection)this.mainConn).getCompatibleLevel();
    }
}

