/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.HashMap;
import org.postgresql.jdbc.AbstractTypeInfoCache;
import org.postgresql.jdbc.TypeInfoCache;

public class PgTypeInfoCache
extends AbstractTypeInfoCache {
    private static final Object[][] types = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"json", 114, 1111, "org.postgresql.util.PGobject", 199}, {"point", 600, 1111, "org.postgresql.geometric.PGpoint", 1017}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public PgTypeInfoCache(TypeInfoCache typeInfoCache) {
        super(typeInfoCache);
    }

    @Override
    public Object[][] getTypes() {
        return types;
    }

    @Override
    public HashMap<String, String> getTypeAliases() {
        return typeAliases;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        oid = this.typeInfoCache.convertArrayToBaseOid(oid);
        switch (oid) {
            case 7014: 
            case 8100: {
                return 3;
            }
            case 21: {
                return 5;
            }
            case 7015: 
            case 7016: 
            case 7017: {
                return 7;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: 
            case 8016: 
            case 8018: {
                if (typmod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 8020: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typmod;
            }
            case 27: {
                return 18;
            }
        }
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        oid = this.typeInfoCache.convertArrayToBaseOid(oid);
        switch (oid) {
            case 7014: 
            case 8100: {
                return 4;
            }
            case 21: {
                return 6;
            }
            case 7015: 
            case 7016: {
                return 8;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 8020: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: 
                    case 8020: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: 
            case 8016: 
            case 8018: {
                if (typmod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this.typeInfoCache.unknownLength;
            }
            case 27: {
                return 18;
            }
        }
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.typeInfoCache.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public int getColumnSize(int oid, int typmod) {
        return this.getPrecision(oid, typmod);
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
    }
}

