/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint centerPoint;
    public double cicleRadius;

    public PGcircle(double x, double y, double r) {
        this(new PGpoint(x, y), r);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGcircle(PGpoint point, double radius) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.centerPoint = point;
        this.cicleRadius = radius;
    }

    public PGcircle(String value) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(value);
    }

    public PGcircle() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.centerPoint = new PGpoint(t.getToken(0));
            this.cicleRadius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (objt instanceof PGcircle) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGcircle circle = (PGcircle)objt;
            return circle.cicleRadius == this.cicleRadius && circle.centerPoint.equals(this.centerPoint);
        }
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGcircle newPGcircle = (PGcircle)super.clone();
        if (newPGcircle.centerPoint != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newPGcircle.centerPoint = (PGpoint)newPGcircle.centerPoint.clone();
        }
        return newPGcircle;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long doubleToLongBits = Double.doubleToLongBits(this.cicleRadius);
        return (int)(doubleToLongBits >>> 32 ^ (long)this.centerPoint.hashCode() ^ doubleToLongBits);
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "<" + this.centerPoint + "," + this.cicleRadius + ">";
    }
}

