/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.ServerVersion;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public abstract class AbstractBlobClob {
    private boolean support64bitT;
    private ArrayList<LargeObject> subLosArray;
    private final long _oid;
    private boolean currentLoIsWriteableT;
    private LargeObject currentLoT;
    protected BaseConnection baseConnection;

    public AbstractBlobClob(BaseConnection _conn, long _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection = _conn;
        this._oid = _oid;
        this.currentLoT = null;
        this.currentLoIsWriteableT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.support64bitT = _conn.haveMinimumServerVersion(90300);
        this.subLosArray = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void truncate(long leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        if (!this.baseConnection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Truncation of large objects is only implemented in 8.3 and later servers.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (leng < 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot truncate LOB to a negative length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (leng <= Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.getLo(true).truncate((int)leng);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.support64bitT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.getLo(true).truncate64(leng);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("PostgreSQL LOBs can only _index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
    }

    public synchronized void free() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.currentLoT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.currentLoT.close();
            this.currentLoIsWriteableT = false;
            this.currentLoT = null;
        }
        for (LargeObject subLoT : this.subLosArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subLoT.close();
        }
        this.subLosArray = null;
    }

    public synchronized long length() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        if (this.support64bitT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getLo(false).size64();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getLo(false).size();
    }

    public synchronized byte[] getBytes(long position, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.assertPosition(position);
        this.getLo(false).seek((int)(position - 1L), 0);
        return this.getLo(false).read(length);
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        LargeObject subLo = this.getLo(false).copy();
        this.addSubLO(subLo);
        subLo.seek(0, 0);
        return subLo.getInputStream();
    }

    public synchronized OutputStream setBinaryStream(long position) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.assertPosition(position);
        LargeObject subLo = this.getLo(true).copy();
        this.addSubLO(subLo);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        subLo.seek((int)(position - 1L));
        return subLo.getOutputStream();
    }

    public synchronized long position(byte[] pat, long start) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkPosition(start, pat.length);
        int position = 1;
        int patIdx = 0;
        long _result = -1L;
        int tmpPosition = 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOIterator i = new LOIterator(start - 1L);
        while (i.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte b = i.next();
            if (b == pat[patIdx]) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (patIdx == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpPosition = position;
                }
                if (++patIdx == pat.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _result = tmpPosition;
                    break;
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                patIdx = 0;
            }
            ++position;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public synchronized long position(Blob pat, long start) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.position(pat.getBytes(1L, (int)pat.length()), start);
    }

    protected void assertPosition(long position) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkPosition(position, 0L);
    }

    protected void checkPosition(long position, long leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        if (position < 1L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("LOB positioning _offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (position + leng - 1L > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only _index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkFreed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.subLosArray == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    protected synchronized LargeObject getLo(boolean forWrite) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.currentLoT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (forWrite && !this.currentLoIsWriteableT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int currentPos = this.currentLoT.tell();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LargeObjectManager largeObjm = this.baseConnection.getLargeObjectAPI();
                LargeObject newLo = largeObjm.open(this._oid, 393216);
                this.subLosArray.add(this.currentLoT);
                this.currentLoT = newLo;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (currentPos != 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.currentLoT.seek(currentPos);
                }
            }
            return this.currentLoT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LargeObjectManager largeObjm = this.baseConnection.getLargeObjectAPI();
        this.currentLoT = largeObjm.open(this._oid, forWrite ? 393216 : 262144);
        this.currentLoIsWriteableT = forWrite;
        return this.currentLoT;
    }

    protected void addSubLO(LargeObject subLo) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.subLosArray.add(subLo);
    }

    private class LOIterator {
        private static final int BUFFER_SIZE = 8096;
        private byte[] _buffer = new byte[8096];
        private int index = 8096;
        private int numBytes = 8096;

        LOIterator(long start) throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            AbstractBlobClob.this.getLo(false).seek((int)start);
        }

        public boolean hasNext() throws SQLException {
            boolean _result;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.index < this.numBytes) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _result = true;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.numBytes = AbstractBlobClob.this.getLo(false).read(this._buffer, 0, 8096);
                this.index = 0;
                _result = this.numBytes > 0;
            }
            return _result;
        }

        private byte next() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._buffer[this.index++];
        }
    }
}

