/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.postgresql.util.LOGGER;
import org.postgresql.util.TraceLogger;

public class SharedTimer {
    private final AtomicInteger refCountT = new AtomicInteger(0);
    private static final AtomicInteger timerCountT = new AtomicInteger(0);
    private volatile Timer timerT = null;

    public SharedTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public int getRefCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int refCount = this.refCountT.get();
        return refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Timer getTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.timerT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _index = timerCountT.incrementAndGet();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ClassLoader prevContextCL = Thread.currentThread().getContextClassLoader();
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Thread.currentThread().setContextClassLoader(null);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String timerName = "PostgreSQL-JDBC-SharedTimer-" + _index;
                boolean isDaemon = true;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.timerT = new Timer(timerName, isDaemon);
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Thread.currentThread().setContextClassLoader(prevContextCL);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.refCountT.incrementAndGet();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.timerT;
    }

    public synchronized void releaseTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int countT = this.refCountT.decrementAndGet();
        if (0 < countT) {
            String e1 = "Outstanding references still exist so not closing shared Timer";
            LOGGER.log(Level.FINEST, e1, new Object[0]);
        } else if (0 == countT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "No outstanding references to shared Timer, will cancel and close it";
            LOGGER.log(Level.FINEST, e1, new Object[0]);
            if (null != this.timerT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.timerT.cancel();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.timerT = null;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "releaseTimer() called too many times; there is probably a bug in the calling code";
            LOGGER.log(Level.WARNING, e1, new Object[0]);
            this.refCountT.set(0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }
}

