/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.BooleanTypeUtil;
import org.postgresql.jdbc.EsBlob;
import org.postgresql.jdbc.EsClob;
import org.postgresql.jdbc.PgArray;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgSQLXML;
import org.postgresql.jdbc.PrimitiveArraySupport;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;

public class PgStruct
implements Struct {
    private String typeName;
    private Object[] attributes;
    private BaseConnection conn;
    private String fieldString;

    public PgStruct(BaseConnection conn, String typeName, int oid, String contents) throws SQLException {
        this.conn = conn;
        this.typeName = typeName;
        this.fieldString = contents;
        this.attributes = this.getAttributesImpl(oid, contents);
    }

    public PgStruct(BaseConnection conn, String typeName, Object[] attributes) {
        this.conn = conn;
        this.typeName = typeName;
        this.attributes = attributes;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getAttributes(Map)");
        }
        return this.attributes;
    }

    private Object[] getAttributesImpl(int oid, String contents) throws SQLException {
        Integer[] oids = this.getElementTypeOfStruct(oid);
        Object[] attributes = new Object[oids.length];
        if (contents.startsWith("(") && contents.endsWith(")")) {
            contents = contents.substring(1, contents.length() - 1);
        }
        char[] aChars = contents.toCharArray();
        int start = 0;
        int j = 0;
        block4: for (int i = 0; i < aChars.length; ++i) {
            char aChar = aChars[i];
            switch (aChar) {
                case '\"': {
                    i = PgStruct.parseDoubleQuotes(aChars, i);
                    continue block4;
                }
                case ',': {
                    String content = new String(aChars, start, i - start);
                    attributes[j] = this.getValue(oids[j], content);
                    ++j;
                    start = i + 1;
                    continue block4;
                }
            }
        }
        if (start < aChars.length) {
            String content = new String(aChars, start, aChars.length - start);
            attributes[j] = this.getValue(oids[j], content);
        }
        return attributes;
    }

    private Integer[] getElementTypeOfStruct(int oid) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        PreparedStatement ps = this.conn.prepareStatement("select a.atttypid from pg_attribute a join pg_type t on a.attrelid = t.typrelid and oid = ? and a.attnum > 0");
        ps.setInt(1, oid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            list.add(rs.getInt(1));
        }
        return list.toArray(new Integer[0]);
    }

    private static int parseDoubleQuotes(char[] str, int offset) {
        int count = 1;
        while (++offset < str.length && str[offset] == '\"') {
            ++count;
        }
        int count2 = 0;
        while (++offset < str.length) {
            if (str[offset] == '\"') {
                if (++count2 != count || ++offset >= str.length || str[offset] == '\"') continue;
                break;
            }
            count2 = 0;
        }
        return offset - 1;
    }

    private Object getValue(int oid, String content) throws SQLException {
        if (content.startsWith("\"") && content.endsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        TypeInfo typeInfo = this.conn.getTypeInfo();
        String pgType = typeInfo.getPGType(oid);
        int type = typeInfo.getSQLType(oid);
        switch (type) {
            case -7: {
                if ("oracle".equals(this.conn.getCompatibleLevel()) || "mysql".equals(this.conn.getCompatibleLevel())) {
                    try {
                        return BooleanTypeUtil.castToBoolean(content, this.conn.getCompatibleLevel());
                    }
                    catch (Exception e) {
                        return content;
                    }
                }
            }
            case 16: {
                return BooleanTypeUtil.castToBoolean(content, this.conn.getCompatibleLevel());
            }
            case 2009: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new PgSQLXML(this.conn, content);
            }
            case -6: 
            case 4: 
            case 5: {
                return PgResultSet.toInt(content);
            }
            case -5: {
                return PgResultSet.toLong(content);
            }
            case 2: 
            case 3: {
                return PgResultSet.toBigDecimal(content);
            }
            case 7: {
                return Float.valueOf(PgResultSet.toFloat(content));
            }
            case 6: 
            case 8: {
                return PgResultSet.toDouble(content);
            }
            case -1: 
            case 1: 
            case 12: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return content;
            }
            case 91: {
                return this.conn.getTimestampUtils().toDate(null, content);
            }
            case 92: {
                return this.conn.getTimestampUtils().toTime(null, content);
            }
            case 93: {
                return this.conn.getTimestampUtils().toTimestamp(null, content);
            }
            case -4: 
            case -3: 
            case -2: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return PGbytea.toBytes(content.getBytes());
            }
            case 2003: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new PgArray(this.conn, oid, content);
            }
            case 2005: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new EsClob(content.toCharArray());
            }
            case 2004: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new EsBlob(PGbytea.toBytes(content.getBytes()));
            }
            case 2002: {
                while (content.startsWith("\"") && content.endsWith("\"")) {
                    content = content.substring(1, content.length() - 1);
                }
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new PgStruct(this.conn, pgType, oid, content);
            }
        }
        return content;
    }

    public String toString() {
        if (this.fieldString != null) {
            return this.fieldString;
        }
        this.fieldString = "(";
        for (Object x : this.attributes) {
            if (x == null) {
                this.fieldString = this.fieldString + ",";
                continue;
            }
            if (x instanceof SQLXML) {
                try {
                    this.fieldString = this.fieldString + ((SQLXML)x).getString().replace("\\", "\\\\").replace("\"", "\\\"") + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof byte[]) {
                this.fieldString = this.fieldString + PGbytea.toPGString((byte[])x) + ",";
                continue;
            }
            if (x instanceof Date) {
                this.fieldString = this.fieldString + this.conn.getTimestampUtils().toString(null, (Date)x) + ",";
                continue;
            }
            if (x instanceof Time) {
                this.fieldString = this.fieldString + this.conn.getTimestampUtils().toString(null, (Time)x) + ",";
                continue;
            }
            if (x instanceof Timestamp) {
                this.fieldString = this.fieldString + this.conn.getTimestampUtils().toString(null, (Timestamp)x) + ",";
                continue;
            }
            if (x instanceof Boolean) {
                this.fieldString = this.fieldString + ((Boolean)x != false ? "1" : "0") + ",";
                continue;
            }
            if (x instanceof Blob) {
                try {
                    this.fieldString = this.fieldString + PGbytea.toPGString(((Blob)x).getBytes(1L, (int)((Blob)x).length())) + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof Clob) {
                try {
                    this.fieldString = this.fieldString + ((Clob)x).getSubString(1L, (int)((Clob)x).length()).replace("\\", "\\\\").replace("\"", "\\\"") + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof Array) {
                this.fieldString = this.fieldString + "\"" + x.toString().replace("\"", "\"\"").replace("\\", "\\\\") + "\",";
                continue;
            }
            if (x instanceof PGobject) {
                this.fieldString = this.fieldString + ((PGobject)x).getValue() + ",";
                continue;
            }
            if (x instanceof Map) {
                this.fieldString = this.fieldString + HStoreConverter.toString((Map)x) + ",";
                continue;
            }
            if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
                PrimitiveArraySupport<Object> arrayToString = PrimitiveArraySupport.getArraySupport(x);
                TypeInfo typeInfo = this.conn.getTypeInfo();
                int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
                char delim = ',';
                try {
                    delim = typeInfo.getArrayDelimiter(oid);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.fieldString = this.fieldString + "\"" + arrayToString.toArrayString(delim, x).replace("\"", "\"\"").replace("\\", "\\\\") + "\",";
                continue;
            }
            this.fieldString = x instanceof Struct ? this.fieldString + "\"" + x.toString().replace("\"", "\"\"").replace("\\", "\\\\") + "\"," : this.fieldString + x.toString().replace("\\", "\\\\").replace("\"", "\\\"") + ",";
        }
        this.fieldString = (this.fieldString.endsWith(",") ? this.fieldString.substring(0, this.fieldString.length() - 1) : this.fieldString) + ")";
        return this.fieldString;
    }
}

