/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private final Reader readerT;
    private final CharsetEncoder _encoder;
    private final ByteBuffer b_buf;
    private final CharBuffer c_buf;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private boolean endOfInputT;
    private final byte[] oneByteT = new byte[1];

    public ReaderInputStream(Reader reader) {
        this(reader, 8192);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public ReaderInputStream(Reader reader, String _encoding) {
        this(reader, 8192, _encoding);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    ReaderInputStream(Reader reader, int charBufferSize) {
        this(reader, charBufferSize, "UTF-8");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    ReaderInputStream(Reader readerT, int charBufferSizeT, String _encoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (readerT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (charBufferSizeT < 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("charBufferSize must be at least 2 characters");
        }
        this.readerT = readerT;
        this._encoder = Charset.forName(_encoding).newEncoder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.b_buf = ByteBuffer.allocate(3 * charBufferSizeT);
        this.b_buf.flip();
        this.c_buf = CharBuffer.allocate(charBufferSizeT);
        this.c_buf.flip();
    }

    private void advance_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (!this.endOfInputT);
        assert (!this.b_buf.hasRemaining()) : "advance() should be called when output byte _buffer is empty. b_buf: " + this.b_buf + ", as string: " + this.b_buf.asCharBuffer().toString();
        assert (this.c_buf.remaining() < 2);
        if (this.c_buf.remaining() == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.c_buf.clear();
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.c_buf.compact();
        }
        int n = this.readerT.read(this.c_buf);
        this.c_buf.flip();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.endOfInputT = n == -1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.b_buf.clear();
        CoderResult _resultult = this._encoder.encode(this.c_buf, this.b_buf, this.endOfInputT);
        this.checkEncodeResult(_resultult);
        if (this.endOfInputT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _resultult = this._encoder.flush(this.b_buf);
            this.checkEncodeResult(_resultult);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.b_buf.flip();
    }

    private void checkEncodeResult(CoderResult _resultult) throws CharacterCodingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_resultult.isError()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _resultult.throwException();
        }
    }

    @Override
    public int read() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int result = 0;
        while (result != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            result = this.read(this.oneByteT);
            if (result <= 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.oneByteT[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bytes == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NullPointerException();
        }
        if (off < 0 || leng < 0 || leng > bytes.length - off) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IndexOutOfBoundsException();
        }
        if (leng == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        if (this.endOfInputT && !this.b_buf.hasRemaining()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return -1;
        }
        int totalOfReadT = 0;
        while (leng > 0 && !this.endOfInputT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.b_buf.hasRemaining()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int remaining = Math.min(leng, this.b_buf.remaining());
                this.b_buf.get(bytes, off, remaining);
                totalOfReadT += remaining;
                off += remaining;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((leng -= remaining) == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return totalOfReadT;
                }
            }
            this.advance_();
        }
        if (this.endOfInputT && !this.b_buf.hasRemaining() && totalOfReadT == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return -1;
        }
        return totalOfReadT;
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.endOfInputT = true;
        this.readerT.close();
    }
}

