/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.KBProperty;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.util.Properties;

public enum SslMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public static final SslMode[] VALUES;
    public final String value;

    private SslMode(String value) {
        this.value = value;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        return this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean verifyPeerName() {
        return this == VERIFY_FULL;
    }

    public static SslMode of(Properties info) throws KSQLException {
        String sslmode = KBProperty.SSL_MODE.get(info);
        if (sslmode == null) {
            if (KBProperty.SSL.getBoolean(info) || "".equals(KBProperty.SSL.get(info))) {
                return VERIFY_FULL;
            }
            return PREFER;
        }
        for (SslMode sslMode : VALUES) {
            if (!sslMode.value.equalsIgnoreCase(sslmode)) continue;
            return sslMode;
        }
        throw new KSQLException(GT.tr("Invalid sslmode value: {0}", sslmode), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = SslMode.values();
    }
}

