/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PgParameterMetaData
implements ParameterMetaData {
    private final BaseConnection _connection;
    private final int[] oids;

    public PgParameterMetaData(BaseConnection _connection, int[] oids) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = _connection;
        this.oids = oids;
    }

    @Override
    public String getParameterClassName(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return this._connection.getTypeInfo().getJavaClass(this.oids[_param - 1]);
    }

    @Override
    public int getParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.oids.length;
    }

    @Override
    public int getParameterMode(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return 1;
    }

    @Override
    public int getParameterType(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return this._connection.getTypeInfo().getSQLType(this.oids[_param - 1]);
    }

    @Override
    public String getParameterTypeName(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return this._connection.getTypeInfo().getPGType(this.oids[_param - 1]);
    }

    @Override
    public int getPrecision(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return 0;
    }

    @Override
    public int getScale(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return 0;
    }

    @Override
    public int isNullable(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return 2;
    }

    @Override
    public boolean isSigned(int _param) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkParamIndex(_param);
        return this._connection.getTypeInfo().isSigned(this.oids[_param - 1]);
    }

    private void checkParamIndex(int _param) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_param < 1 || _param > this.oids.length) {
            throw new PSQLException(GT.tr("The _parameter _index is out of range: {0}, number of _parameters: {1}.", _param, this.oids.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }
}

