/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.hostchooser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.util.HostSpec;

public class GlobalHostStatusTracker {
    private static final Map<HostSpec, HostSpecStatus> _hostStatusMap = new HashMap<HostSpec, HostSpecStatus>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportHostStatus(HostSpec _hostSpec, HostStatus _hostStatus) {
        long now = System.nanoTime() / 1000L;
        Map<HostSpec, HostSpecStatus> map = _hostStatusMap;
        synchronized (map) {
            HostSpecStatus _hostSpecStatus = _hostStatusMap.get(_hostSpec);
            if (_hostSpecStatus == null) {
                _hostSpecStatus = new HostSpecStatus(_hostSpec);
                _hostStatusMap.put(_hostSpec, _hostSpecStatus);
            }
            _hostSpecStatus.status = _hostStatus;
            _hostSpecStatus.lastUpdated = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HostSpec> getCandidateHosts(HostSpec[] _hostSpecs, HostRequirement targetServerType, long _hostRecheckMillis, boolean fastFailover) {
        ArrayList<HostSpec> candidates = new ArrayList<HostSpec>(_hostSpecs.length);
        long latestAllowedUpdate = System.nanoTime() / 1000L - _hostRecheckMillis;
        Map<HostSpec, HostSpecStatus> map = _hostStatusMap;
        synchronized (map) {
            for (HostSpec _hostSpec : _hostSpecs) {
                HostSpecStatus _hostInfo = _hostStatusMap.get(_hostSpec);
                if (fastFailover) {
                    if (_hostInfo != null && _hostInfo.status == HostStatus.First) {
                        candidates.add(0, _hostSpec);
                        continue;
                    }
                    candidates.add(_hostSpec);
                    continue;
                }
                if (_hostInfo != null && _hostInfo.lastUpdated >= latestAllowedUpdate && !targetServerType.allowConnectingTo(_hostInfo.status)) continue;
                candidates.add(_hostSpec);
            }
        }
        return candidates;
    }

    static class HostSpecStatus {
        final HostSpec _host;
        HostStatus status;
        long lastUpdated;

        HostSpecStatus(HostSpec _host) {
            this._host = _host;
        }

        public String toString() {
            return this._host.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

