/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobWriter
extends Writer {
    private StringBuffer buf;
    private Clob lo;
    private int bpos;
    private int clobpos;

    public ClobWriter(Clob lo, int pos) {
        this.lo = lo;
        this.clobpos = pos;
        this.buf = new StringBuffer();
        this.bpos = 0;
    }

    @Override
    public void write(int c) throws IOException {
        this.buf.append((char)c);
        this.write(this.buf.toString());
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
        this.write(this.buf.toString());
    }

    @Override
    public void write(String str) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            this.lo.setString(this.clobpos, str);
            this.clobpos += str.length();
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.buf.append(str.substring(off, off + len));
        this.write(this.buf.toString());
    }

    @Override
    public ClobWriter append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public ClobWriter append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public ClobWriter append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.lo.setString(this.clobpos, String.valueOf(this.buf).trim(), 0, this.bpos);
                this.clobpos += this.bpos;
            }
            this.bpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lo != null) {
            this.flush();
            this.lo = null;
        }
    }

    private void checkClosed() throws IOException {
        if (this.lo == null) {
            throw new IOException("ClobWriter is closed");
        }
    }
}

