/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.TraceLogger;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGpolygon() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new PGpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof PGpolygon) {
            PGpolygon pnt = (PGpolygon)objt;
            if (pnt.points.length != this.points.length) {
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(pnt.points[i])) continue;
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hashVal = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hashVal ^= this.points[i].hashCode();
        }
        return hashVal;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            newPGpolygon.points = (PGpoint[])newPGpolygon.points.clone();
            for (int i = 0; i < newPGpolygon.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (newPGpolygon.points[i] == null) continue;
                newPGpolygon.points[i] = (PGpoint)newPGpolygon.points[i].clone();
            }
        }
        return newPGpolygon;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                sb.append(",");
            }
            sb.append(this.points[p].toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

