/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ReleaseReferencesStrategy;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.IllegalTransactionStateException;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransactionImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPServerTransactionImpl
extends SIPTransactionImpl
implements SIPServerTransaction {
    private static StackLogger logger = CommonLogger.getLogger(SIPServerTransaction.class);
    private int rseqNumber = -1;
    private transient ServerRequestInterface requestOf;
    private SIPDialog dialog;
    protected String dialogId;
    private byte[] pendingReliableResponseAsBytes;
    private String pendingReliableResponseMethod;
    private long pendingReliableCSeqNumber;
    private long pendingReliableRSeqNumber;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;
    private static boolean interlockProvisionalResponses = true;
    private Semaphore provisionalResponseSem = new Semaphore(1);
    private Semaphore terminationSemaphore = new Semaphore(0);
    private byte[] lastResponseAsBytes;
    private String lastResponseHost;
    private int lastResponsePort;
    private String lastResponseTransport;
    private int lastResponseStatusCode;
    private HostPort originalRequestSentBy;
    private String originalRequestFromTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(SIPResponse transactionResponse) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipServerTransaction::sendResponse " + transactionResponse.getFirstLine());
        }
        try {
            if (this.isReliable() && !this.sipStack.isPatchReceivedRport()) {
                this.getMessageChannel().sendMessage(transactionResponse);
            } else {
                Via via = transactionResponse.getTopmostVia();
                String transport = via.getTransport();
                if (transport == null) {
                    throw new IOException("missing transport!");
                }
                int port = via.getRPort();
                if (port == -1) {
                    port = via.getPort();
                }
                if (port == -1) {
                    port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
                }
                String host = null;
                if (via.getMAddr() != null) {
                    host = via.getMAddr();
                } else {
                    host = via.getParameter("received");
                    if (host == null) {
                        host = via.getHost();
                    }
                }
                Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(host, port, transport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    messageChannel.sendMessage(transactionResponse);
                    this.lastResponseHost = host;
                    this.lastResponsePort = port;
                    this.lastResponseTransport = transport;
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
            this.lastResponseAsBytes = transactionResponse.encodeAsBytes(this.getTransport());
            this.lastResponse = null;
        }
        finally {
            this.startTransactionTimer();
        }
    }

    protected SIPServerTransactionImpl(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating Server Transaction" + this.getBranchId());
            logger.logStackTrace();
        }
    }

    @Override
    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    @Override
    public MessageChannel getResponseChannel() {
        return this.encapsulatedChannel;
    }

    @Override
    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        Via topViaHeader;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeq().getMethod();
        SIPRequest origRequest = this.getOriginalRequest();
        if ((this.isInviteTransaction() || !this.isTerminated()) && (topViaHeader = messageToTest.getTopmostVia()) != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy()) : (origRequest != null ? this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy()) : this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(this.originalRequestSentBy));
            } else {
                origRequest = (SIPRequest)this.getRequest();
                String originalFromTag = origRequest.getFromTag();
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = origRequest.getToTag();
                String thisToTag = messageToTest.getTo().getTag();
                boolean skipTo = originalToTag == null || thisToTag == null;
                boolean isResponse = messageToTest instanceof SIPResponse;
                if (messageToTest.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && !origRequest.getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    transactionMatches = false;
                } else if ((isResponse || origRequest.getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI())) && (skipFrom || originalFromTag != null && originalFromTag.equalsIgnoreCase(thisFromTag)) && (skipTo || originalToTag != null && originalToTag.equalsIgnoreCase(thisToTag)) && origRequest.getCallId().getCallId().equalsIgnoreCase(messageToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == messageToTest.getCSeq().getSeqNumber() && (!messageToTest.getCSeq().getMethod().equals("CANCEL") || this.getMethod().equals(messageToTest.getCSeq().getMethod())) && topViaHeader.equals(origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    @Override
    public void map() {
        int realState = this.getRealState();
        if (realState < 0 || realState == 1) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.getTimer() != null) {
                this.isMapped = true;
                this.sipStack.getTimer().schedule(new SendTrying(), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    @Override
    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        boolean toTu = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("processRequest: " + transactionRequest.getFirstLine());
            logger.logDebug("tx state = " + this.getRealState());
        }
        try {
            if (this.getRealState() < 0) {
                this.setOriginalRequest(transactionRequest);
                this.setState(1);
                toTu = true;
                this.setPassToListener();
                if (this.isInviteTransaction() && this.isMapped) {
                    this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                }
            } else {
                if (this.isInviteTransaction() && 3 == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                    this.setState(4);
                    this.disableRetransmissionTimer();
                    if (!this.isReliable()) {
                        this.enableTimeoutTimer(this.timerI);
                    } else {
                        this.setState(5);
                    }
                    if (this.sipStack.isNon2XXAckPassedToListener()) {
                        this.requestOf.processRequest(transactionRequest, this.encapsulatedChannel);
                    } else {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                        }
                        this.semRelease();
                    }
                    return;
                }
                if (transactionRequest.getMethod().equals(this.getMethod())) {
                    if (2 == this.getRealState() || 3 == this.getRealState()) {
                        this.semRelease();
                        this.resendLastResponseAsBytes();
                    } else if (transactionRequest.getMethod().equals("ACK")) {
                        if (this.requestOf != null) {
                            this.requestOf.processRequest(transactionRequest, this.encapsulatedChannel);
                        } else {
                            this.semRelease();
                        }
                    } else {
                        this.semRelease();
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("completed processing retransmitted request : " + transactionRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.lastResponseAsBytes);
                    }
                    return;
                }
            }
            if (3 != this.getRealState() && 5 != this.getRealState() && this.requestOf != null) {
                if (this.getMethod().equals(transactionRequest.getMethod())) {
                    if (toTu) {
                        this.requestOf.processRequest(transactionRequest, this.encapsulatedChannel);
                    } else {
                        this.semRelease();
                    }
                } else if (this.requestOf != null) {
                    this.requestOf.processRequest(transactionRequest, this.encapsulatedChannel);
                } else {
                    this.semRelease();
                }
            } else {
                if (SIPTransactionStack.isDialogCreated(this.getMethod()) && this.getRealState() == 5 && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = (SIPDialog)this.getDialog();
                    if (thisDialog == null || !thisDialog.ackProcessed) {
                        if (thisDialog != null) {
                            thisDialog.ackReceived(transactionRequest.getCSeq().getSeqNumber());
                            thisDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(transactionRequest, this.encapsulatedChannel);
                    } else {
                        this.semRelease();
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Too late to cancel Transaction");
                    }
                    this.semRelease();
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException thisDialog) {}
                } else {
                    this.semRelease();
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping request " + this.getRealState());
                }
            }
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logError("IOException ", e);
            }
            this.semRelease();
            this.raiseIOExceptionEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipServerTransaction::sendMessage " + messageToSend.getFirstLine());
        }
        SIPResponse transactionResponse = (SIPResponse)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        try {
            try {
                if (this.originalRequestBranch != null) {
                    transactionResponse.getTopmostVia().setBranch(this.getBranch());
                } else {
                    transactionResponse.getTopmostVia().removeParameter("branch");
                }
                if (!this.originalRequestHasPort) {
                    transactionResponse.getTopmostVia().removePort();
                }
            }
            catch (ParseException ex) {
                logger.logError("UnexpectedException", ex);
                throw new IOException("Unexpected exception");
            }
            if (!transactionResponse.getCSeq().getMethod().equals(this.getMethod())) {
                this.sendResponse(transactionResponse);
                return;
            }
            if (!this.checkStateTimers(statusCode)) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("checkStateTimers returned false -- not sending message");
                }
                return;
            }
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
                }
                this.lastResponse = transactionResponse;
                this.lastResponseStatusCode = transactionResponse.getStatusCode();
                this.sendResponse(transactionResponse);
            }
            catch (IOException e) {
                this.setState(5);
                this.collectionTime = 0;
                throw e;
            }
        }
        finally {
            this.startTransactionTimer();
        }
    }

    private boolean checkStateTimers(int statusCode) {
        if (this.getRealState() == 1) {
            if (statusCode / 100 == 1) {
                this.setState(2);
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isInviteTransaction()) {
                    if (!this.isReliable() && this.getInternalState() != 3) {
                        this.setState(3);
                        this.startTransactionTimerJ(64L);
                        this.cleanUpOnTimer();
                    } else {
                        this.cleanUpOnTimer();
                        this.setState(5);
                        this.startTransactionTimerJ(0L);
                    }
                } else if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            }
        } else if (this.getRealState() == 2) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(3);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.startTransactionTimerJ(64L);
                } else {
                    this.setState(5);
                    this.startTransactionTimerJ(0L);
                }
                this.cleanUpOnTimer();
            }
        } else if (3 == this.getRealState()) {
            return false;
        }
        return true;
    }

    @Override
    public String getViaHost() {
        return super.getViaHost();
    }

    @Override
    public int getViaPort() {
        return super.getViaPort();
    }

    @Override
    public void fireRetransmissionTimer() {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("fireRetransmissionTimer() -- " + this + " state " + this.getState());
            }
            if (this.isInviteTransaction() && (this.lastResponse != null || this.lastResponseAsBytes != null)) {
                if (!this.retransmissionAlertEnabled || this.sipStack.isTransactionPendingAck(this)) {
                    if (this.lastResponseStatusCode / 100 >= 2 && !this.isAckSeen) {
                        this.resendLastResponseAsBytes();
                    }
                } else {
                    SipProviderImpl sipProvider = this.getSipProvider();
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)sipProvider, this, Timeout.RETRANSMIT);
                    sipProvider.handleEvent(txTimeout, this);
                }
            }
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException(e);
            }
            this.raiseErrorEvent(2);
        }
    }

    @Override
    public void resendLastResponseAsBytes() throws IOException {
        if (this.lastResponse != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + this.lastResponse);
            }
            this.sendMessage(this.lastResponse);
        } else if (this.lastResponseAsBytes != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + new String(this.lastResponseAsBytes));
            }
            if (this.isReliable()) {
                block15: {
                    if (logger.isLoggingEnabled(16)) {
                        try {
                            SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                            lastReparsedResponse.setRemoteAddress(this.getPeerInetAddress());
                            lastReparsedResponse.setRemotePort(this.getPeerPort());
                            lastReparsedResponse.setLocalPort(this.getMessageChannel().getPort());
                            lastReparsedResponse.setLocalAddress(this.getMessageChannel().getMessageProcessor().getIpAddress());
                            this.getMessageChannel().logMessage(lastReparsedResponse, this.getPeerInetAddress(), this.getPeerPort(), System.currentTimeMillis());
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled(32)) break block15;
                            logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes), e);
                        }
                    }
                }
                this.getMessageChannel().sendMessage(this.lastResponseAsBytes, this.getPeerInetAddress(), this.getPeerPort(), false);
            } else {
                Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(this.lastResponseHost, this.lastResponsePort, this.lastResponseTransport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    block16: {
                        if (logger.isLoggingEnabled(16)) {
                            try {
                                SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                                lastReparsedResponse.setRemoteAddress(messageChannel.getPeerInetAddress());
                                lastReparsedResponse.setRemotePort(messageChannel.getPeerPort());
                                lastReparsedResponse.setLocalPort(messageChannel.getPort());
                                lastReparsedResponse.setLocalAddress(messageChannel.getMessageProcessor().getIpAddress());
                                messageChannel.logMessage(lastReparsedResponse, messageChannel.getPeerInetAddress(), messageChannel.getPeerPort(), System.currentTimeMillis());
                            }
                            catch (ParseException e) {
                                if (!logger.isLoggingEnabled(32)) break block16;
                                logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes), e);
                            }
                        }
                    }
                    messageChannel.sendMessage(this.lastResponseAsBytes, InetAddress.getByName(hop.getHost()), hop.getPort(), false);
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            this.resendLastResponseAsBytes();
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException(e);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
        }
    }

    @Override
    public void fireTimeoutTimer() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getMethod());
        }
        if (this.isInviteTransaction() && this.sipStack.removeTransactionPendingAck(this) && logger.isLoggingEnabled(32)) {
            logger.logDebug("Found tx pending ACK - timer H has kicked");
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (SIPTransactionStack.isDialogCreated(this.getMethod()) && (0 == this.getRealState() || 1 == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getMethod().equals("BYE") && dialog != null && dialog.isTerminatedOnBye()) {
            dialog.setState(3);
        }
        if (3 == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(5);
            this.sipStack.removeTransaction(this);
        } else if (3 == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(5);
            if (!this.getMethod().equals("CANCEL")) {
                this.cleanUp();
            } else {
                this.sipStack.removeTransaction(this);
            }
        } else if (4 == this.getRealState() && this.isInviteTransaction()) {
            this.setState(5);
            this.sipStack.removeTransaction(this);
        } else if (!(this.isInviteTransaction() || 3 != this.getRealState() && 4 != this.getRealState())) {
            this.setState(5);
        } else if (this.isInviteTransaction() && 5 == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    @Override
    public int getLastResponseStatusCode() {
        return this.lastResponseStatusCode;
    }

    @Override
    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
    }

    @Override
    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sipResponse.checkHeaders();
        }
        catch (ParseException ex) {
            throw new IllegalTransactionStateException(ex.getMessage(), IllegalTransactionStateException.Reason.MissingRequiredHeader);
        }
        String responseMethod = sipResponse.getCSeq().getMethod();
        if (!responseMethod.equals(this.getMethod())) {
            throw new IllegalTransactionStateException("CSeq method does not match Request method of request that created the tx.", IllegalTransactionStateException.Reason.UnmatchingCSeq);
        }
        int statusCode = response.getStatusCode();
        if (this.getMethod().equals("SUBSCRIBE") && statusCode / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new IllegalTransactionStateException("Expires header is mandatory in 2xx response of SUBSCRIBE", IllegalTransactionStateException.Reason.ExpiresHeaderMandatory);
            }
            Expires requestExpires = (Expires)this.getOriginalRequest().getExpires();
            Expires responseExpires = (Expires)response.getExpires();
            if (requestExpires != null && responseExpires.getExpires() > requestExpires.getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (statusCode == 200 && responseMethod.equals("INVITE") && sipResponse.getHeader("Contact") == null) {
            throw new IllegalTransactionStateException("Contact Header is mandatory for the OK to the INVITE", IllegalTransactionStateException.Reason.ContactHeaderMandatory);
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)((Object)response))) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            block39: {
                ContentType contentTypeHeader = ((SIPResponse)response).getContentTypeHeader();
                if (this.pendingReliableResponseAsBytes != null && this.getDialog() != null && this.getInternalState() != 5 && statusCode / 100 == 2 && contentTypeHeader != null && contentTypeHeader.getContentType().equalsIgnoreCase("application") && contentTypeHeader.getContentSubType().equalsIgnoreCase("sdp")) {
                    if (!interlockProvisionalResponses) {
                        throw new SipException("cannot send response -- unacked provisional");
                    }
                    try {
                        boolean acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS);
                        if (!acquired) {
                            throw new SipException("cannot send response -- unacked provisional");
                        }
                        break block39;
                    }
                    catch (InterruptedException ex) {
                        logger.logError("Interrupted acuqiring PRACK sem");
                        throw new SipException("Cannot aquire PRACK sem");
                    }
                }
                if (this.pendingReliableResponseAsBytes != null && sipResponse.isFinalResponse()) {
                    this.sipStack.getTimer().cancel(this.provisionalResponseTask);
                    this.provisionalResponseTask = null;
                }
            }
            if (dialog != null) {
                if (statusCode / 100 == 2 && SIPTransactionStack.isDialogCreated(responseMethod)) {
                    if (dialog.getLocalTag() == null && sipResponse.getToTag() == null) {
                        sipResponse.getTo().setTag(Utils.getInstance().generateTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("assigning toTag : serverTransaction = " + this + " dialog " + dialog + " tag = " + dialog.getLocalTag());
                        }
                        sipResponse.setToTag(dialog.getLocalTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() != null && !dialog.getLocalTag().equals(sipResponse.getToTag())) {
                        throw new SipException("Tag mismatch dialogTag is " + dialog.getLocalTag() + " responseTag is " + sipResponse.getToTag());
                    }
                }
                if (!sipResponse.getCallId().getCallId().equals(dialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            String fromTag = this.originalRequestFromTag;
            if (this.getRequest() != null) {
                fromTag = ((SIPRequest)this.getRequest()).getFromTag();
            }
            if (fromTag != null && sipResponse.getFromTag() != null && !sipResponse.getFromTag().equals(fromTag)) {
                throw new SipException("From tag of request does not match response from tag");
            }
            if (fromTag != null) {
                sipResponse.getFrom().setTag(fromTag);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("WARNING -- Null From tag in request!!");
            }
            if (dialog != null && statusCode != 100) {
                dialog.setResponseTags(sipResponse);
                DialogState oldState = dialog.getState();
                dialog.setLastResponse(this, (SIPResponse)response);
                if (oldState == null && dialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent event = new DialogTerminatedEvent(dialog.getSipProvider(), dialog);
                    dialog.getSipProvider().handleEvent(event, this);
                }
            } else if (dialog == null && this.isInviteTransaction() && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                String dialogId = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask(dialogId);
                this.sipStack.retransmissionAlertTransactions.put(dialogId, this);
                this.sipStack.getTimer().scheduleWithFixedDelay(this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPResponse)response);
            if (dialog != null) {
                dialog.startRetransmitTimer(this, (SIPResponse)response);
            }
        }
        catch (IOException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
            throw new SipException(ex.getMessage(), ex);
        }
        catch (ParseException ex1) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex1);
            }
            this.setState(5);
            throw new SipException(ex1.getMessage(), ex1);
        }
    }

    protected int getRealState() {
        return super.getInternalState();
    }

    @Override
    public TransactionState getState() {
        if (this.isInviteTransaction() && 1 == super.getInternalState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    @Override
    public void setState(int newState) {
        if (newState == 5 && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
            this.terminationSemaphore.release();
        }
        super.setState(newState);
    }

    @Override
    public void startTransactionTimer() {
        if ((this.getMethod().equalsIgnoreCase("INVITE") || this.getMethod().equalsIgnoreCase("CANCEL") || this.getMethod().equalsIgnoreCase("ACK")) && this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            TransactionTimer myTimer = new TransactionTimer();
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().scheduleWithFixedDelay(myTimer, this.baseTimerInterval, this.baseTimerInterval);
            }
            Object var1_1 = null;
        }
    }

    protected void startTransactionTimerJ(long time) {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("starting TransactionTimerJ() : " + this.getTransactionId() + " time " + time);
            }
            SIPStackTimerTask task = new SIPStackTimerTask(){

                @Override
                public void runTask() {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("executing TransactionTimerJ() : " + SIPServerTransactionImpl.this.getTransactionId());
                    }
                    SIPServerTransactionImpl.this.fireTimeoutTimer();
                    SIPServerTransactionImpl.this.cleanUp();
                    if (SIPServerTransactionImpl.this.originalRequest != null) {
                        SIPServerTransactionImpl.this.originalRequest.cleanUp();
                    }
                }

                @Override
                public Object getThreadHash() {
                    Request request = SIPServerTransactionImpl.this.getRequest();
                    if (request != null && request instanceof SIPRequest) {
                        return ((SIPRequest)request).getCallIdHeader().getCallId();
                    }
                    return null;
                }
            };
            if (time > 0L) {
                this.sipStack.getTimer().schedule(task, time * 1L * (long)this.baseTimerInterval);
            } else {
                task.runTask();
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sst = (SIPServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    @Override
    public Dialog getDialog() {
        if (this.dialog == null && this.dialogId != null) {
            return this.sipStack.getDialog(this.dialogId);
        }
        return this.dialog;
    }

    @Override
    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setDialog " + this + " dialog = " + sipDialog);
        }
        this.dialog = sipDialog;
        this.dialogId = dialogId;
        if (dialogId != null) {
            sipDialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        this.retransmissionAlertEnabled = false;
    }

    @Override
    public void terminate() throws ObjectInUseException {
        this.setState(5);
        if (this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        if (!this.transactionTimerStarted.get()) {
            this.testAndSetTransactionTerminatedEvent();
            this.sipStack.removeTransaction(this);
        }
    }

    @Override
    public void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (this.pendingReliableResponseAsBytes != null) {
            throw new SipException("Unacknowledged response");
        }
        SIPResponse reliableResponse = (SIPResponse)relResponse;
        this.pendingReliableResponseAsBytes = reliableResponse.encodeAsBytes(this.getTransport());
        this.pendingReliableResponseMethod = reliableResponse.getCSeq().getMethod();
        this.pendingReliableCSeqNumber = reliableResponse.getCSeq().getSeqNumber();
        RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
        if (relResponse.getHeader("RSeq") == null) {
            rseq = new RSeq();
            relResponse.setHeader(rseq);
        }
        try {
            boolean acquired;
            if (this.rseqNumber < 0) {
                this.rseqNumber = (int)(Math.random() * 1000.0);
            }
            ++this.rseqNumber;
            rseq.setSeqNumber(this.rseqNumber);
            this.pendingReliableRSeqNumber = rseq.getSeqNumber();
            this.lastResponse = (SIPResponse)relResponse;
            if (this.getDialog() != null && interlockProvisionalResponses && !(acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS))) {
                throw new SipException("Unacknowledged reliable response");
            }
            this.provisionalResponseTask = new ProvisionalResponseTask();
            this.sipStack.getTimer().scheduleWithFixedDelay(this.provisionalResponseTask, 0L, 500L);
            this.sendMessage((SIPMessage)((Object)relResponse));
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    @Override
    public byte[] getReliableProvisionalResponse() {
        return this.pendingReliableResponseAsBytes;
    }

    @Override
    public boolean prackRecieved() {
        if (this.pendingReliableResponseAsBytes == null) {
            return false;
        }
        if (this.provisionalResponseTask != null) {
            this.sipStack.getTimer().cancel(this.provisionalResponseTask);
            this.provisionalResponseTask = null;
        }
        this.pendingReliableResponseAsBytes = null;
        if (interlockProvisionalResponses && this.getDialog() != null) {
            this.provisionalResponseSem.release();
        }
        return true;
    }

    @Override
    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.isInviteTransaction()) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    @Override
    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    @Override
    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            this.retransmissionAlertEnabled = false;
            String dialogId = this.retransmissionAlertTimerTask.dialogId;
            if (dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
    }

    @Override
    public void setAckSeen() {
        this.isAckSeen = true;
    }

    @Override
    public boolean ackSeen() {
        return this.isAckSeen;
    }

    @Override
    public void setMapped(boolean b) {
        this.isMapped = true;
    }

    @Override
    public void setPendingSubscribe(SIPClientTransaction pendingSubscribeClientTx) {
        this.pendingSubscribeTransaction = pendingSubscribeClientTx;
    }

    @Override
    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            if (!this.sipStack.isDeliverUnsolicitedNotify()) {
                this.pendingSubscribeTransaction.releaseSem();
            }
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    @Override
    public void setInviteTransaction(SIPServerTransaction st) {
        this.inviteTransaction = st;
    }

    @Override
    public SIPServerTransaction getCanceledInviteTransaction() {
        return this.inviteTransaction;
    }

    @Override
    public void scheduleAckRemoval() throws IllegalStateException {
        if (this.getMethod() == null || !this.getMethod().equals("ACK")) {
            throw new IllegalStateException("Method is null[" + (this.getMethod() == null) + "] or method is not ACK[" + this.getMethod() + "]");
        }
        this.startTransactionTimer();
    }

    @Override
    public void cleanUp() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removing" + this);
        }
        if (this.getReleaseReferencesStrategy() != ReleaseReferencesStrategy.None) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup : " + this.getTransactionId());
            }
            if (this.originalRequest == null && this.originalRequestBytes != null && this.getReleaseReferencesStrategy() == ReleaseReferencesStrategy.Normal) {
                try {
                    this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
                }
                catch (ParseException e) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("message " + this.originalRequestBytes + "could not be reparsed !", e);
                    }
                }
            } else if (this.originalRequest != null && this.originalRequestBytes == null && this.getReleaseReferencesStrategy() == ReleaseReferencesStrategy.Normal) {
                this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
            }
            if (this.originalRequest != null && this.originalRequestBytes == null) {
                this.mergeId = this.originalRequest.getMergeId();
            }
            this.sipStack.removeTransaction(this);
            this.cleanUpOnTimer();
            this.originalRequestFromTag = null;
            this.originalRequestSentBy = null;
            if (this.originalRequest != null) {
                this.originalRequest = null;
            }
            if (!this.isReliable() && this.inviteTransaction != null) {
                this.inviteTransaction = null;
            }
            this.lastResponse = null;
        } else {
            this.sipStack.removeTransaction(this);
        }
        if (!this.sipStack.cacheServerConnections && this.isReliable() && --this.getMessageChannel().useCount <= 0) {
            this.close();
        } else if (logger.isLoggingEnabled(32) && !this.sipStack.cacheServerConnections && this.isReliable()) {
            int useCount = this.getMessageChannel().useCount;
            logger.logDebug("Use Count = " + useCount);
        }
    }

    protected void cleanUpOnTimer() {
        if (this.getReleaseReferencesStrategy() != ReleaseReferencesStrategy.None) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup on timer : " + this.getTransactionId());
            }
            if (this.dialog != null && this.getMethod().equals("CANCEL")) {
                this.dialogId = this.dialog.getDialogId();
            }
            this.dialog = null;
            if (this.inviteTransaction != null && !this.getMethod().equals("CANCEL")) {
                this.inviteTransaction.releaseSem();
                this.inviteTransaction = null;
            }
            if (this.originalRequest != null) {
                this.mergeId = this.originalRequest.getMergeId();
                this.originalRequest.setTransaction(null);
                this.originalRequest.setInviteTransaction(null);
                if (!this.getMethod().equalsIgnoreCase("INVITE")) {
                    if (this.originalRequestSentBy == null) {
                        this.originalRequestSentBy = this.originalRequest.getTopmostVia().getSentBy();
                    }
                    if (this.originalRequestFromTag == null) {
                        this.originalRequestFromTag = this.originalRequest.getFromTag();
                    }
                }
                if (this.originalRequestBytes == null && this.getReleaseReferencesStrategy() == ReleaseReferencesStrategy.Normal) {
                    this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
                }
                if (!this.getMethod().equalsIgnoreCase("INVITE") && !this.getMethod().equalsIgnoreCase("CANCEL")) {
                    this.originalRequest = null;
                }
            }
            if (this.lastResponse != null) {
                if (this.getReleaseReferencesStrategy() == ReleaseReferencesStrategy.Normal) {
                    this.lastResponseAsBytes = this.lastResponse.encodeAsBytes(this.getTransport());
                }
                this.lastResponse = null;
            }
            this.pendingReliableResponseAsBytes = null;
            this.pendingReliableResponseMethod = null;
            this.pendingSubscribeTransaction = null;
            this.provisionalResponseSem = null;
            this.retransmissionAlertTimerTask = null;
            this.requestOf = null;
        }
    }

    @Override
    public String getPendingReliableResponseMethod() {
        return this.pendingReliableResponseMethod;
    }

    @Override
    public long getPendingReliableCSeqNumber() {
        return this.pendingReliableCSeqNumber;
    }

    @Override
    public long getPendingReliableRSeqNumber() {
        return this.pendingReliableRSeqNumber;
    }

    @Override
    public void waitForTermination() {
        try {
            this.terminationSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class TransactionTimer
    extends SIPStackTimerTask {
        public TransactionTimer() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TransactionTimer() : " + SIPServerTransactionImpl.this.getTransactionId());
            }
        }

        @Override
        public void runTask() {
            if (SIPServerTransactionImpl.this.isTerminated()) {
                block7: {
                    try {
                        SIPServerTransactionImpl.this.sipStack.getTimer().cancel(this);
                    }
                    catch (IllegalStateException ex) {
                        if (SIPServerTransactionImpl.this.sipStack.isAlive()) break block7;
                        return;
                    }
                }
                SIPTransactionImpl.LingerTimer myTimer = new SIPTransactionImpl.LingerTimer(SIPServerTransactionImpl.this);
                if (SIPServerTransactionImpl.this.sipStack.getConnectionLingerTimer() != 0) {
                    SIPServerTransactionImpl.this.sipStack.getTimer().schedule(myTimer, SIPServerTransactionImpl.this.sipStack.getConnectionLingerTimer() * 1000);
                } else {
                    ((SIPStackTimerTask)myTimer).runTask();
                }
            } else {
                SIPServerTransactionImpl.this.fireTimer();
            }
            if (SIPServerTransactionImpl.this.originalRequest != null) {
                SIPServerTransactionImpl.this.originalRequest.cleanUp();
            }
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPServerTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }

    class SendTrying
    extends SIPStackTimerTask {
        protected SendTrying() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("scheduled timer for " + SIPServerTransactionImpl.this);
            }
        }

        @Override
        public void runTask() {
            block5: {
                SIPServerTransactionImpl serverTransaction = SIPServerTransactionImpl.this;
                int realState = serverTransaction.getRealState();
                if (realState < 0 || 1 == realState) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug(" sending Trying current state = " + serverTransaction.getRealState());
                    }
                    try {
                        serverTransaction.sendMessage(serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug(" trying sent " + serverTransaction.getRealState());
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggingEnabled()) break block5;
                        logger.logError("IO error sending  TRYING");
                    }
                }
            }
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPServerTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }

    class ProvisionalResponseTask
    extends SIPStackTimerTask {
        int ticks;
        int ticksLeft;

        public ProvisionalResponseTask() {
            this.ticksLeft = this.ticks = 1;
        }

        @Override
        public void runTask() {
            SIPServerTransactionImpl serverTransaction = SIPServerTransactionImpl.this;
            if (serverTransaction.isTerminated()) {
                SIPServerTransactionImpl.this.sipStack.getTimer().cancel(this);
            } else {
                --this.ticksLeft;
                if (this.ticksLeft == -1) {
                    serverTransaction.fireReliableResponseRetransmissionTimer();
                    this.ticks = this.ticksLeft = 2 * this.ticks;
                    if (this.ticksLeft >= 64) {
                        SIPServerTransactionImpl.this.sipStack.getTimer().cancel(this);
                        SIPServerTransactionImpl.this.setState(5);
                        SIPServerTransactionImpl.this.fireTimeoutTimer();
                    }
                }
            }
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPServerTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }

    class RetransmissionAlertTimerTask
    extends SIPStackTimerTask {
        String dialogId;
        int ticks;
        int ticksLeft;

        public RetransmissionAlertTimerTask(String dialogId) {
            this.ticksLeft = this.ticks = 1;
            this.dialogId = dialogId;
        }

        @Override
        public void runTask() {
            SIPServerTransactionImpl serverTransaction = SIPServerTransactionImpl.this;
            --this.ticksLeft;
            if (this.ticksLeft == -1) {
                serverTransaction.fireRetransmissionTimer();
                this.ticksLeft = 2 * this.ticks;
            }
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPServerTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }
}

