/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGbox
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGbox(double x1, double y1, double x2, double y2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = new PGpoint(x1, y1);
        this.point[1] = new PGpoint(x2, y2);
    }

    public PGbox(PGpoint p1, PGpoint p2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGbox(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
    }

    public PGbox() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("box");
    }

    @Override
    public void setValue(String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer t = new PGtokenizer(_value, ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, _value), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = new PGpoint();
        this.point[0].setByteValue(b, _offset);
        this.point[1] = new PGpoint();
        this.point[1].setByteValue(b, _offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof PGbox) {
            PGbox pnt = (PGbox)objt;
            if (pnt.point[0].equals(this.point[0]) && pnt.point[1].equals(this.point[1])) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].equals(this.point[1]) && pnt.point[1].equals(this.point[0])) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].x == this.point[0].x && pnt.point[0].y == this.point[1].y && pnt.point[1].x == this.point[1].x && pnt.point[1].y == this.point[0].y) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].x == this.point[1].x && pnt.point[0].y == this.point[0].y && pnt.point[1].x == this.point[0].x && pnt.point[1].y == this.point[1].y) {
                return true;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGbox newPGbox = (PGbox)super.clone();
        if (newPGbox.point != null) {
            newPGbox.point = (PGpoint[])newPGbox.point.clone();
            for (int i = 0; i < newPGbox.point.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (newPGbox.point[i] == null) continue;
                newPGbox.point[i] = (PGpoint)newPGbox.point[i].clone();
            }
        }
        return newPGbox;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] _bytes, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0].toBytes(_bytes, _offset);
        this.point[1].toBytes(_bytes, _offset + this.point[0].lengthInBytes());
    }
}

