/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication.fluent.logical;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.ReplicationSlotInfo;
import org.postgresql.replication.ReplicationType;
import org.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import org.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import org.postgresql.util.TraceLogger;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private String startLsnT;
    private String outputPluginT;

    public LogicalCreateSlotBuilder(BaseConnection _connection) {
        super(_connection);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder getSelf() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LogicalCreateSlotBuilder t = this;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return t;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String _outputPlugin) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.outputPluginT = _outputPlugin;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ChainedLogicalCreateSlotBuilder self = this.getSelf();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return self;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withStartLsn(String startLsn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.startLsnT = startLsn;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ChainedLogicalCreateSlotBuilder self = this.getSelf();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.outputPluginT == null || this.outputPluginT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("OutputPlugin required _parameter for logical replication slot");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.slotNameT == null || this.slotNameT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("Replication _slotName can't be null");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stmt = this.baseConnection.createStatement();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet rstSet = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ReplicationSlotInfo slotInfo = null;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String tmpStr = "CREATE_REPLICATION_SLOT %s %s LOGICAL %s %s";
            String tStr = "TEMPORARY";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stmt.execute(String.format(tmpStr, this.slotNameT, this.temporaryOptionT ? tStr : "", this.outputPluginT, this.startLsnT == null || this.startLsnT.isEmpty() ? "" : this.startLsnT));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rstSet = stmt.getResultSet();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (rstSet != null && rstSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String s1 = "slot_name";
                String s2 = "consistent_point";
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String s3 = "snapshot_name";
                String s4 = "output_plugin";
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                slotInfo = new ReplicationSlotInfo(rstSet.getString("slot_name"), ReplicationType.LOGICAL, LogSequenceNumber.valueOf(rstSet.getString("consistent_point")), rstSet.getString("snapshot_name"), rstSet.getString("output_plugin"));
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (rstSet != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                rstSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stmt.close();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return slotInfo;
    }
}

