/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack.timers;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AffinitityExecutorSipTimer
implements SipTimer {
    private static StackLogger logger = CommonLogger.getLogger(AffinitityExecutorSipTimer.class);
    protected SipStackImpl sipStackImpl;
    ScheduledExecutorService threadPoolExecutor;

    @Override
    public void stop() {
        this.threadPoolExecutor.shutdown();
        logger.logStackTrace(32);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    @Override
    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.schedule(new ScheduledSipTimerTask(task), delay, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    @Override
    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.scheduleWithFixedDelay(new ScheduledSipTimerTask(task), delay, period, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    @Override
    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.threadPoolExecutor = this.sipStackImpl.getSelfRoutingThreadpoolExecutor();
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    @Override
    public boolean cancel(SIPStackTimerTask task) {
        boolean cancelled = false;
        ScheduledFuture sipTimerTask = (ScheduledFuture)task.getSipTimerTask();
        if (sipTimerTask != null) {
            task.cleanUpBeforeCancel();
            task.setSipTimerTask(null);
            cancelled = sipTimerTask.cancel(false);
        }
        return cancelled;
    }

    @Override
    public boolean isStarted() {
        return !this.threadPoolExecutor.isShutdown();
    }

    private class ScheduledSipTimerTask
    implements Runnable {
        private SIPStackTimerTask task;

        public ScheduledSipTimerTask(SIPStackTimerTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.task != null) {
                    this.task.runTask();
                }
            }
            catch (Throwable e) {
                System.out.println("SIP stack timer task failed due to exception:");
                e.printStackTrace();
            }
        }
    }
}

