/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import org.postgresql.core.JavaVersion;
import org.postgresql.core.Provider;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class TimestampUtils {
    private static final int ONEDAY_T = 86400000;
    private static final char[] ZEROS_T;
    private static final int MAX_NANOS_BEFORE_WRAP_ON_ROUND_T = 999999500;
    private static final char[][] NUMBERS_T;
    private static final HashMap<String, TimeZone> GMT_ZONES_T;
    private TimeZone prevDefaultZoneFieldVal_T;
    private static final Field DEFAULT_TIME_ZONE_FIELD_T;
    private TimeZone defaultTimeZoneCache_T;
    private final Calendar calWithUserTz = new GregorianCalendar();
    private final StringBuilder s_buf = new StringBuilder();
    private Calendar calendarCache;
    private final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private final boolean usesDouble;
    private int calendarCacheZone;
    private final Provider<TimeZone> tzProvider;

    TimestampUtils(boolean usesDouble, Provider<TimeZone> tzProvider) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.usesDouble = usesDouble;
        this.tzProvider = tzProvider;
    }

    private Calendar getCalendar(int sign, int hr, int min, int sec) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int rawOffset = sign * (((hr * 60 + min) * 60 + sec) * 1000);
        if (this.calendarCache != null && this.calendarCacheZone == rawOffset) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.calendarCache;
        }
        StringBuilder timeZoneID = new StringBuilder("GMT");
        timeZoneID.append(sign < 0 ? (char)'-' : '+');
        if (hr < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        timeZoneID.append(hr);
        if (min < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timeZoneID.append(min);
        if (sec < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        timeZoneID.append(sec);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleTimeZone syntheticTZ = new SimpleTimeZone(rawOffset, timeZoneID.toString());
        this.calendarCache = new GregorianCalendar(syntheticTZ);
        this.calendarCacheZone = rawOffset;
        return this.calendarCache;
    }

    private ParsedTimestamp parseBackendTimestamp_(String strT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] sT = strT.toCharArray();
        int slengT = sT.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedTimestamp resultT = new ParsedTimestamp();
        try {
            char sep_T;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int startT = TimestampUtils.skipWhitespace(sT, 0);
            int endT = TimestampUtils.firstNonDigit(sT, startT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (TimestampUtils.charAt(sT, endT) == '-') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.hasDate = true;
                resultT.beginYear = TimestampUtils.number(sT, startT, endT);
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.beginMonth = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != '-') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.day = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = TimestampUtils.skipWhitespace(sT, endT);
            }
            if (Character.isDigit(TimestampUtils.charAt(sT, startT))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.hasTimeVal = true;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.hour = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected time to be _colon-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.minute = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected time to be _colon-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.second = TimestampUtils.number(sT, startT, endT);
                startT = endT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (TimestampUtils.charAt(sT, startT) == '.') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    int numT = TimestampUtils.number(sT, startT + 1, endT);
                    for (int numlength = endT - (startT + 1); numlength < 9; ++numlength) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        numT *= 10;
                    }
                    resultT.nanos = numT;
                    startT = endT;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = TimestampUtils.skipWhitespace(sT, startT);
            }
            if ((sep_T = TimestampUtils.charAt(sT, startT)) == '-' || sep_T == '+') {
                int timezoneminT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int timezonesignT = sep_T == '-' ? -1 : 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                int timezonehrT = TimestampUtils.number(sT, startT + 1, endT);
                startT = endT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, startT);
                if (sep_T == ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    timezoneminT = TimestampUtils.number(sT, startT + 1, endT);
                    startT = endT;
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    timezoneminT = 0;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int timezonesecT = 0;
                sep_T = TimestampUtils.charAt(sT, startT);
                if (sep_T == ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    timezonesecT = TimestampUtils.number(sT, startT + 1, endT);
                    startT = endT;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.timezone = this.getCalendar(timezonesignT, timezonehrT, timezoneminT, timezonesecT);
                startT = TimestampUtils.skipWhitespace(sT, startT);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultT.hasDate && startT < slengT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String eraString = new String(sT, startT, slengT - startT);
                if (eraString.startsWith("AD")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultT.era = 1;
                    startT += 2;
                } else if (eraString.startsWith("BC")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultT.era = 0;
                    startT += 2;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (startT < slengT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(sT, startT, slengT - startT) + "'");
            }
            if (!resultT.hasTimeVal && !resultT.hasDate) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
        }
        catch (NumberFormatException numberFormatException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Bad _value for type timestamp/date/time: {1}";
            throw new PSQLException(GT.tr("Bad _value for type timestamp/date/time: {1}", strT), PSQLState.BAD_DATETIME_FORMAT, (Throwable)numberFormatException);
        }
        return resultT;
    }

    public synchronized Timestamp toTimestamp(Calendar calendar, String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 8 && s.equals("infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(9223372036825200000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 9 && s.equals("-infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(-9223372036832400000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(s);
        Calendar useCalendarT = timestamp.timezone != null ? timestamp.timezone : this.setupCalendar(calendar);
        useCalendarT.set(13, timestamp.second);
        useCalendarT.set(1, timestamp.beginYear);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(5, timestamp.day);
        useCalendarT.set(12, timestamp.minute);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(11, timestamp.hour);
        useCalendarT.set(2, timestamp.beginMonth - 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(14, 0);
        useCalendarT.set(0, timestamp.era);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp _result = new Timestamp(useCalendarT.getTimeInMillis());
        _result.setNanos(timestamp.nanos);
        return _result;
    }

    public synchronized Time toTime(Calendar calendar, String s) throws SQLException {
        Calendar useCalendarT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(s);
        Calendar calendar2 = useCalendarT = timestamp.timezone != null ? timestamp.timezone : this.setupCalendar(calendar);
        if (timestamp.timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(5, timestamp.day);
            useCalendarT.set(2, timestamp.beginMonth - 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(0, timestamp.era);
            useCalendarT.set(1, timestamp.beginYear);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(5, 1);
            useCalendarT.set(2, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(0, 1);
            useCalendarT.set(1, 1970);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(14, 0);
        useCalendarT.set(12, timestamp.minute);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(13, timestamp.second);
        useCalendarT.set(11, timestamp.hour);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long timeMillis = useCalendarT.getTimeInMillis() + (long)(timestamp.nanos / 1000000);
        if (timestamp.timezone != null || timestamp.beginYear == 1970 && timestamp.era == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Time(timeMillis);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.convertToTime(timeMillis, useCalendarT.getTimeZone());
    }

    public synchronized Date toDate(Calendar calendar, String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp timestamp = this.toTimestamp(calendar, s);
        if (timestamp == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.convertToDate(timestamp.getTime(), calendar == null ? null : calendar.getTimeZone());
    }

    private Calendar setupCalendar(Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimeZone tz = calendar == null ? null : calendar.getTimeZone();
        return this.getSharedCalendar(tz);
    }

    public Calendar getSharedCalendar(TimeZone tz) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (tz == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            tz = this.getDefaultTz_();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar tmp = this.calWithUserTz;
        tmp.setTimeZone(tz);
        return tmp;
    }

    private static boolean nanosExceed499(int nanosT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return nanosT % 1000 > 499;
    }

    public synchronized String toString(Calendar calendar, Timestamp x) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendar, x, true);
    }

    public synchronized String toString(Calendar calendarT, Timestamp timestamp, boolean withTimeZoneT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timestamp.getTime() == 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (timestamp.getTime() == -9223372036832400000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT = this.setupCalendar(calendarT);
        long timeMillis = timestamp.getTime();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int nanosT = timestamp.getNanos();
        if (nanosT >= 999999500) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanosT = 0;
            ++timeMillis;
        } else if (TimestampUtils.nanosExceed499(nanosT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanosT += 1000 - nanosT % 1000;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT.setTimeInMillis(timeMillis);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(this.s_buf, calendarT);
        this.s_buf.append(' ');
        TimestampUtils.appendTime(this.s_buf, calendarT, nanosT);
        if (withTimeZoneT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendarT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendEra(this.s_buf, calendarT);
        return this.s_buf.toString();
    }

    public synchronized String toString(Calendar calendarT, Date date) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendarT, date, true);
    }

    public synchronized String toString(Calendar calendarT, Date date, boolean withTimeZoneT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (date.getTime() == 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (date.getTime() == -9223372036832400000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT = this.setupCalendar(calendarT);
        calendarT.setTime(date);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(this.s_buf, calendarT);
        TimestampUtils.appendEra(this.s_buf, calendarT);
        if (withTimeZoneT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.s_buf.append(' ');
            this.appendTimeZone(this.s_buf, calendarT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.s_buf.toString();
    }

    public synchronized String toString(Calendar calendar, Time x) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendar, x, true);
    }

    public synchronized String toString(Calendar calendar, Time x, boolean withTimeZone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar = this.setupCalendar(calendar);
        calendar.setTime(x);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendTime(this.s_buf, calendar, calendar.get(14) * 1000000);
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendar);
        }
        return this.s_buf.toString();
    }

    public synchronized String toString(Calendar calendar, Time x, boolean withTimeZone, long nanoSeconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar = this.setupCalendar(calendar);
        calendar.setTime(x);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendTime(this.s_buf, calendar, calendar.get(14) * 1000000 + (int)nanoSeconds);
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendar);
        }
        return this.s_buf.toString();
    }

    public long getTimeNanoSecond(byte[] bytes) {
        long nanoSecond = 0L;
        if (this.usesDouble) {
            double time = ByteConverter.float8(bytes, 0);
            nanoSecond = (long)((time * 1000.0 - (double)((long)(time * 1000.0))) * 1000000.0);
        } else {
            long time = ByteConverter.int8(bytes, 0);
            nanoSecond = time % 1000L * 1000L;
        }
        return nanoSecond;
    }

    private static void appendDate(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dayNum = calendar.get(5);
        int monthNum = calendar.get(2) + 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int yearNum = calendar.get(1);
        TimestampUtils.appendDate(sbu, yearNum, monthNum, dayNum);
    }

    private static void appendDate(StringBuilder sbu, int year, int month, int day) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int prevLength = sbu.length();
        sbu.append(year);
        int leadingZerosForYear = 4 - (sbu.length() - prevLength);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (leadingZerosForYear > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.insert(prevLength, ZEROS_T, 0, leadingZerosForYear);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append('-');
        sbu.append(NUMBERS_T[month]);
        sbu.append('-');
        sbu.append(NUMBERS_T[day]);
    }

    private static void appendTime(StringBuilder sbu, Calendar calendar, int nanos) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int seconds = calendar.get(13);
        TimestampUtils.appendTime(sbu, hours, minutes, seconds, nanos);
    }

    private static void appendTime(StringBuilder stringBuilder, int hours, int minutes, int seconds, int nanosT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(NUMBERS_T[hours]);
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS_T[minutes]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS_T[seconds]);
        if (nanosT < 1000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append('.');
        int leng = stringBuilder.length();
        stringBuilder.append(nanosT / 1000);
        int needZerosT = 6 - (stringBuilder.length() - leng);
        if (needZerosT > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.insert(leng, ZEROS_T, 0, needZerosT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int endT = stringBuilder.length() - 1;
        while (stringBuilder.charAt(endT) == '0') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.deleteCharAt(endT);
            --endT;
        }
    }

    private void appendTimeZone(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _offset = (calendar.get(15) + calendar.get(16)) / 1000;
        this.appendTimeZone(sbu, _offset);
    }

    private void appendTimeZone(StringBuilder sbu, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int absoff = Math.abs(_offset);
        int hours = absoff / 60 / 60;
        int mins = (absoff - hours * 60 * 60) / 60;
        int seconds = absoff - hours * 60 * 60 - mins * 60;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(_offset >= 0 ? "+" : "-");
        sbu.append(NUMBERS_T[hours]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mins == 0 && seconds == 0) {
            return;
        }
        sbu.append(':');
        sbu.append(NUMBERS_T[mins]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (seconds != 0) {
            sbu.append(':');
            sbu.append(NUMBERS_T[seconds]);
        }
    }

    private static void appendEra(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar.get(0) == 0) {
            sbu.append(" BC");
        }
    }

    private static int skipWhitespace(char[] s, int _start) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length;
        for (int i = _start; i < sleng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (Character.isSpace(s[i])) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return i;
        }
        return sleng;
    }

    private static int firstNonDigit(char[] s, int _start) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length;
        for (int i = _start; i < sleng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (Character.isDigit(s[i])) continue;
            return i;
        }
        return sleng;
    }

    private static int number(char[] s, int _start, int end) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_start >= end) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException();
        }
        int n = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = _start; i < end; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            n = 10 * n + (s[i] - 48);
        }
        return n;
    }

    private static char charAt(char[] s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (position >= 0 && position < s.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return s[position];
        }
        return '\u0000';
    }

    public Date toDateBin(TimeZone timezone, byte[] _bytes) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unsupported binary _encoding of {0}.";
            throw new PSQLException(GT.tr("Unsupported binary _encoding of {0}.", "date"), PSQLState.BAD_DATETIME_FORMAT);
        }
        int days = ByteConverter.int4(_bytes, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        long seconds = TimestampUtils.toJavaSecs((long)days * 86400L);
        long milliseconds = seconds * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (milliseconds <= -185543533774800000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = -9223372036832400000L;
        } else if (milliseconds >= 185543533774800000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = 9223372036825200000L;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = this.guessTimestamp(milliseconds, timezone);
        }
        return new Date(milliseconds);
    }

    private TimeZone getDefaultTz_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (DEFAULT_TIME_ZONE_FIELD_T != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TimeZone defaultTimeZoneT = (TimeZone)DEFAULT_TIME_ZONE_FIELD_T.get(null);
                if (defaultTimeZoneT == this.prevDefaultZoneFieldVal_T) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return this.defaultTimeZoneCache_T;
                }
                this.prevDefaultZoneFieldVal_T = defaultTimeZoneT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            catch (Exception exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TimeZone timezoneT = TimeZone.getDefault();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.defaultTimeZoneCache_T = timezoneT;
        return timezoneT;
    }

    public boolean hasFastDefaultTimeZone() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return DEFAULT_TIME_ZONE_FIELD_T != null;
    }

    public Time toTimeBin(TimeZone timezone, byte[] _bytes) throws PSQLException {
        long milliseconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 8 && _bytes.length != 12) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unsupported binary _encoding of {0}.";
            throw new PSQLException(GT.tr("Unsupported binary _encoding of {0}.", "time"), PSQLState.BAD_DATETIME_FORMAT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double time = ByteConverter.float8(_bytes, 0);
            milliseconds = (long)(time * 1000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long time = ByteConverter.int8(_bytes, 0);
            milliseconds = time / 1000L;
        }
        if (_bytes.length == 12) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int timeOffset = ByteConverter.int4(_bytes, 8);
            return new Time(milliseconds -= (long)(timeOffset *= -1000));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        milliseconds = this.guessTimestamp(milliseconds, timezone);
        return this.convertToTime(milliseconds, timezone);
    }

    public Timestamp toTimestampBin(TimeZone timezone, byte[] _bytes, boolean timestamptz) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT parsedtimestamp = this.toParsedTimestampBin(timezone, _bytes, timestamptz);
        if (parsedtimestamp.infinity == EInfinity.POSITIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(9223372036825200000L);
        }
        if (parsedtimestamp.infinity == EInfinity.NEGATIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(-9223372036832400000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp timestamp = new Timestamp(parsedtimestamp.milliseconds);
        timestamp.setNanos(parsedtimestamp.nanos);
        return timestamp;
    }

    private ParsedBinaryTimestampT toParsedTimestampBinPlain(byte[] _bytes) throws PSQLException {
        int nanos;
        long seconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Unsupported binary _encoding of {0}.", "timestamp"), PSQLState.BAD_DATETIME_FORMAT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double time = ByteConverter.float8(_bytes, 0);
            if (time == Double.POSITIVE_INFINITY) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.POSITIVE;
                return timestamp;
            }
            if (time == Double.NEGATIVE_INFINITY) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.NEGATIVE;
                return timestamp;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            seconds = (long)time;
            nanos = (int)((time - (double)seconds) * 1000000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long time = ByteConverter.int8(_bytes, 0);
            if (time == Long.MAX_VALUE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.POSITIVE;
                return timestamp;
            }
            if (time == Long.MIN_VALUE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.NEGATIVE;
                return timestamp;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            seconds = time / 1000000L;
            nanos = (int)(time - seconds * 1000000L);
        }
        if (nanos < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            --seconds;
            nanos += 1000000;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = seconds * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
        timestamp.milliseconds = milliseconds;
        timestamp.nanos = nanos *= 1000;
        return timestamp;
    }

    private ParsedBinaryTimestampT toParsedTimestampBin(TimeZone timezone, byte[] _bytes, boolean timestamptz) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = this.toParsedTimestampBinPlain(_bytes);
        if (timestamp.infinity != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timestamp;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = timestamp.milliseconds / 1000L;
        seconds = TimestampUtils.toJavaSecs(seconds);
        long milliseconds = seconds * 1000L;
        if (!timestamptz) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = this.guessTimestamp(milliseconds, timezone);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.milliseconds = milliseconds;
        return timestamp;
    }

    private ParsedBinaryTimestampT toProlepticParsedTimestampBin(byte[] _bytes) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = this.toParsedTimestampBinPlain(_bytes);
        if (timestamp.infinity != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timestamp;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = timestamp.milliseconds / 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = (seconds += 946684800L) * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.milliseconds = milliseconds;
        return timestamp;
    }

    private long guessTimestamp(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return millisecondsT - (long)timezone.getRawOffset();
        }
        Calendar userCalendarT = this.calWithUserTz;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeZone(this.utcTimeZone);
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int msT = userCalendarT.get(14);
        int minT = userCalendarT.get(12);
        int secT = userCalendarT.get(13);
        int yearT = userCalendarT.get(1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int monthT = userCalendarT.get(2);
        int dayT = userCalendarT.get(5);
        int eraT = userCalendarT.get(0);
        int hourT = userCalendarT.get(11);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeZone(timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(14, msT);
        userCalendarT.set(13, secT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(11, hourT);
        userCalendarT.set(1, yearT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(2, monthT);
        userCalendarT.set(5, dayT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(0, eraT);
        userCalendarT.set(12, minT);
        return userCalendarT.getTimeInMillis();
    }

    private static boolean isSimpleTimeZone_(String id) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return id.startsWith("GMT") || id.startsWith("UTC");
    }

    public Date convertToDate(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (millisecondsT <= -9223372036832400000L || millisecondsT >= 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Date(millisecondsT);
        }
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _offset = timezone.getRawOffset();
            millisecondsT += (long)_offset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            millisecondsT = TimestampUtils.floorDiv_(millisecondsT, 86400000L) * 86400000L;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Date(millisecondsT -= (long)_offset);
        }
        Calendar userCalendarT = this.calWithUserTz;
        userCalendarT.setTimeZone(timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(14, 0);
        userCalendarT.set(12, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(13, 0);
        userCalendarT.set(11, 0);
        return new Date(userCalendarT.getTimeInMillis());
    }

    public Time convertToTime(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _offset = timezone.getRawOffset();
            millisecondsT += (long)_offset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            millisecondsT = TimestampUtils.floorMod(millisecondsT, 86400000L);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Time(millisecondsT -= (long)_offset);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar userCalendarT = this.calWithUserTz;
        userCalendarT.setTimeZone(timezone);
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(5, 1);
        userCalendarT.set(2, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(1, 1970);
        userCalendarT.set(0, 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new Time(userCalendarT.getTimeInMillis());
    }

    public String timeToString(java.util.Date time, boolean withTimeZone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar calendar = null;
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.calWithUserTz;
            calendar.setTimeZone(this.tzProvider.get());
        }
        if (time instanceof Timestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Timestamp)time, withTimeZone);
        }
        if (time instanceof Time) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Time)time, withTimeZone);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendar, (Date)time, withTimeZone);
    }

    public String timeToString(java.util.Date time, boolean withTimeZone, long nanoSecond) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar calendar = null;
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.calWithUserTz;
            calendar.setTimeZone(this.tzProvider.get());
        }
        if (time instanceof Timestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Timestamp)time, withTimeZone);
        }
        if (time instanceof Time) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Time)time, withTimeZone, nanoSecond);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendar, (Date)time, withTimeZone);
    }

    private static long toJavaSecs(long seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((seconds += 946684800L) < -12219292800L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ((seconds += 864000L) < -14825808000L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int extraLeapst = (int)((seconds + 14825808000L) / 3155760000L);
                --extraLeapst;
                extraLeapst -= extraLeapst / 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                seconds += (long)extraLeapst * 86400L;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return seconds;
    }

    private static long toPgSecs(long seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((seconds -= 946684800L) < -13165977600L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ((seconds -= 864000L) < -15773356800L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int years = (int)((seconds + 15773356800L) / -3155823050L);
                ++years;
                years -= years / 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                seconds += (long)years * 86400L;
            }
        }
        return seconds;
    }

    public void toBinDate(TimeZone timezone, byte[] _bytes, Date _value) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = _value.getTime();
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        milliseconds += (long)timezone.getOffset(milliseconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = TimestampUtils.toPgSecs(milliseconds / 1000L);
        ByteConverter.int4(_bytes, 0, (int)(seconds / 86400L));
    }

    public static TimeZone parseBackendTimeZone(String tz) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (tz.startsWith("GMT")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TimeZone timezone = GMT_ZONES_T.get(tz);
            if (timezone != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return timezone;
            }
        }
        return TimeZone.getTimeZone(tz);
    }

    private static long floorDiv_(long xT, long yT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long rT = xT / yT;
        if ((xT ^ yT) < 0L && rT * yT != xT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            --rT;
        }
        return rT;
    }

    private static long floorMod(long xT, long yT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return xT - TimestampUtils.floorDiv_(xT, yT) * yT;
    }

    static {
        Field timezoneFieldT;
        int i;
        ZEROS_T = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        GMT_ZONES_T = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        NUMBERS_T = new char[64][];
        for (i = 0; i < NUMBERS_T.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TimestampUtils.NUMBERS_T[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = -12; i <= 14; ++i) {
            String pgZoneNameT;
            TimeZone tzT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i == 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                tzT = TimeZone.getTimeZone("GMT");
                pgZoneNameT = "GMT";
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String tStr = "GMT" + (i <= 0 ? "+" : "-") + Math.abs(i);
                tzT = TimeZone.getTimeZone(tStr);
                pgZoneNameT = "GMT" + (i >= 0 ? "+" : "-");
            }
            if (i == 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                GMT_ZONES_T.put(pgZoneNameT, tzT);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            GMT_ZONES_T.put(pgZoneNameT + Math.abs(i), tzT);
            GMT_ZONES_T.put(pgZoneNameT + new String(NUMBERS_T[Math.abs(i)]), tzT);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezoneFieldT = null;
            if (JavaVersion.getRuntimeVersion().compareTo(JavaVersion.version_1_8) <= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                timezoneFieldT = TimeZone.class.getDeclaredField("defaultTimeZone");
                timezoneFieldT.setAccessible(true);
                TimeZone defaultTz = TimeZone.getDefault();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object timezoneFromField = timezoneFieldT.get(null);
                if (defaultTz == null || !defaultTz.equals(timezoneFromField)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    timezoneFieldT = null;
                }
            }
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezoneFieldT = null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        DEFAULT_TIME_ZONE_FIELD_T = timezoneFieldT;
    }

    static enum EInfinity {
        POSITIVE,
        NEGATIVE;

    }

    private static class ParsedBinaryTimestampT {
        long milliseconds = 0L;
        int nanos = 0;
        EInfinity infinity = null;

        private ParsedBinaryTimestampT() {
        }
    }

    private static class ParsedTimestamp {
        int day = 1;
        boolean hasTimeVal = false;
        int minute = 0;
        int hour = 0;
        int nanos = 0;
        int second = 0;
        int era = 1;
        boolean hasDate = false;
        int beginMonth = 1;
        int beginYear = 1970;
        Calendar timezone = null;

        private ParsedTimestamp() {
        }
    }
}

