/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.Field;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ResultCursor;
import com.kingbase8.core.ResultHandlerBase;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.jdbc.BatchResultHandler;
import com.kingbase8.jdbc.KSQLWarningWrapper;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.ResultWrapper;
import com.kingbase8.jdbc.StatementCancelState;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;

public class KbStatement
implements Statement,
BaseStatement {
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS_T = Boolean.getBoolean("com.kingbase8.forceBinary");
    private static final String[] NO_RETURNING_COLUMNS = new String[0];
    protected ArrayList<Query> batchStatementsList = null;
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS_T;
    protected int resultsettypeT;
    protected ArrayList<ParameterList> batchParametersList = null;
    private int resultSetHoldabilityT;
    protected int concurrencyT;
    private boolean closeOnCompletionT = false;
    private boolean poolableT;
    private volatile TimerTask cancelTimerTask = null;
    protected boolean reWriteBind = false;
    protected int fetchdirectionT = 1000;
    private static final AtomicReferenceFieldUpdater<KbStatement, TimerTask> CANCEL_TIMER_UPDATER_T = AtomicReferenceFieldUpdater.newUpdater(KbStatement.class, TimerTask.class, "cancelTimerTask");
    private static final AtomicReferenceFieldUpdater<KbStatement, StatementCancelState> STATE_UPDATER_T = AtomicReferenceFieldUpdater.newUpdater(KbStatement.class, StatementCancelState.class, "stmtState");
    public boolean wantsGeneratedKeysAlwaysT = false;
    protected boolean wantsGeneratedKeysOnceT = false;
    private volatile StatementCancelState stmtState = StatementCancelState.IDLE;
    protected volatile KSQLWarningWrapper _warnings = null;
    protected final BaseConnection baseConnection;
    protected int fetchSize = 0;
    protected int maxrows = 0;
    protected boolean replaceProcessingEnabled = true;
    protected long timeoutT = 0L;
    protected volatile ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper resultT = null;
    protected int mPrepareThreshold;
    protected int maxFieldSize = 0;
    protected ResultWrapper _generatedKeys = null;
    private volatile boolean isClosedT = false;

    KbStatement(KbConnection c, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection = c;
        this.forceBinaryTransfers |= c.getForceBinary();
        this.resultsettypeT = resultSetType;
        this.concurrencyT = resultSetConcurrency;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setFetchSize(c.getDefaultFetchSize());
        this.setPrepareThreshold(c.getPrepareThreshold());
        this.resultSetHoldabilityT = resultSetHoldability;
    }

    @Override
    public ResultSet createResultSet(Query originalQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbResultSet newResult = new KbResultSet(originalQuery, this, _fields, _tuples, cursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        newResult.setFetchSize(this.getFetchSize());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        newResult.setFetchDirection(this.getFetchDirection());
        return newResult;
    }

    public void copyStatementInfo(KbStatement stnew) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.forceBinaryTransfers = stnew.forceBinaryTransfers;
        this.batchStatementsList = stnew.batchStatementsList;
        this.batchParametersList = stnew.batchParametersList;
        this.resultsettypeT = stnew.resultsettypeT;
        this.concurrencyT = stnew.concurrencyT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultSetHoldabilityT = stnew.resultSetHoldabilityT;
        this.poolableT = stnew.poolableT;
        this.closeOnCompletionT = stnew.closeOnCompletionT;
        this.fetchdirectionT = stnew.fetchdirectionT;
        this.wantsGeneratedKeysOnceT = stnew.wantsGeneratedKeysOnceT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wantsGeneratedKeysAlwaysT = stnew.wantsGeneratedKeysAlwaysT;
        this.maxrows = stnew.maxrows;
        this.fetchSize = stnew.fetchSize;
        this.timeoutT = stnew.timeoutT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.replaceProcessingEnabled = stnew.replaceProcessingEnabled;
        this.mPrepareThreshold = stnew.mPrepareThreshold;
        this.maxFieldSize = stnew.maxFieldSize;
    }

    public BaseConnection getKBConnection() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.baseConnection;
    }

    @Override
    public int getFetchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fetchSize;
    }

    public String getFetchingCursorName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    protected boolean wantsScrollableResultSet() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.resultsettypeT != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.resultSetHoldabilityT == 1;
    }

    @Override
    public ResultSet executeQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.executeWithFlags(_sql, 0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSingleResultSetT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getSingleResultSetT() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this.resultT.getNext() != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Multiple ResultSets were returned by the query.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultT.getResultSet();
        }
    }

    @Override
    public int executeUpdate(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.executeWithFlags(_sql, 4);
        this.checkNoResultUpdate_();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkNoResultUpdate_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            for (ResultWrapper iter = this.resultT; iter != null; iter = iter.getNext()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (iter.getResultSet() != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("A _result was returned when none was expected.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
    }

    @Override
    public boolean execute(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.executeWithFlags(_sql, 0);
    }

    @Override
    public boolean executeWithFlags(String _sql, int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.executeCachedSql(_sql, _flags, NO_RETURNING_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCachedSql(String _sql, int _flags, String[] _columnNames) throws SQLException {
        boolean res;
        CachedQuery _cachedQuery;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PreferQueryMode preferQueryMode = this.baseConnection.getPreferQueryMode();
        boolean shouldUseParameterized = false;
        QueryExecutor queryExecutorImpl = this.baseConnection.getQueryExecutor();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object _key = queryExecutorImpl.createQueryKey(_sql, this.replaceProcessingEnabled, shouldUseParameterized, _columnNames);
        boolean shouldCache = preferQueryMode == PreferQueryMode.EXTENDED_CACHE_EVERYTHING;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (shouldCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _cachedQuery = queryExecutorImpl.borrowQueryByKey(_key);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _cachedQuery = queryExecutorImpl.createQueryByKey(_key);
        }
        if (this.wantsGeneratedKeysOnceT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SqlCommand _sqlCommand = _cachedQuery.query.getSqlCommand();
            this.wantsGeneratedKeysOnceT = _sqlCommand != null && _sqlCommand.isReturningKeywordPresent();
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            res = this.executeWithFlags(_cachedQuery, _flags);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (shouldCache) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                queryExecutorImpl.releaseQuery(_cachedQuery);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(CachedQuery simpleQuery, int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (this.baseConnection.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 0x400;
        }
        this.execute(simpleQuery, null, _flags);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            return this.resultT != null && this.resultT.getResultSet() != null;
        }
    }

    @Override
    public boolean executeWithFlags(int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        throw new KSQLException(GT.tr("Can''t use executeWithFlags(int) on a Statement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeForNextExecution_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.clearWarnings();
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (this.firstUnclosedResult != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KbResultSet resultSet = (KbResultSet)this.firstUnclosedResult.getResultSet();
                if (resultSet != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultSet.closeInternally();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultT = null;
            if (this._generatedKeys != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this._generatedKeys.getResultSet() != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._generatedKeys.getResultSet().close();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._generatedKeys = null;
            }
        }
    }

    protected boolean isOneShotQuery(CachedQuery _cachedQuery) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_cachedQuery == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        _cachedQuery.increaseExecuteCount();
        if (!(this.mPrepareThreshold != 0 && _cachedQuery.getExecuteCount() >= this.mPrepareThreshold || this.getForceBinaryTransfer_())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    protected final void execute(CachedQuery cachedQueryT, ParameterList queryParametersList, int flagsT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.executeInternal_(cachedQueryT, queryParametersList, flagsT);
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cachedQueryT.query.getSubqueries() != null || !this.baseConnection.getQueryExecutor().willHealOnRetry(sqlException)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw sqlException;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            cachedQueryT.query.close();
            this.executeInternal_(cachedQueryT, queryParametersList, flagsT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal_(CachedQuery _cachedQuery, ParameterList queryParameters, int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.closeForNextExecution_();
        if (this.fetchSize > 0 && !this.wantsScrollableResultSet() && (!((KbConnection)this.baseConnection).getAutoCommit() || this.baseConnection.getAutoCommit() && ((KbConnection)this.baseConnection).useFetchSizeInAutoCommit()) && !this.wantsHoldableResultSet()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 8;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.wantsGeneratedKeysOnceT || this.wantsGeneratedKeysAlwaysT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (((_flags |= 0x40) & 4) != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _flags &= 0xFFFFFFFB;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isOneShotQuery(_cachedQuery)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 1;
        }
        if (this.baseConnection.getAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 0x10;
        }
        if (this.baseConnection.hintReadOnly()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 0x800;
        }
        if (this.concurrencyT != 1007) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 0x100;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Query queryToExecute = _cachedQuery.query;
        if (queryToExecute.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flags |= 0x10;
        }
        if (!queryToExecute.isStatementDescribed() && this.forceBinaryTransfers && (_flags & 0x400) == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _flags2 = _flags | 0x20;
            StatementResultHandler _handler2 = new StatementResultHandler();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.baseConnection.getQueryExecutor().execute(queryToExecute, queryParameters, _handler2, 0, 0, _flags2);
            ResultWrapper _result2 = _handler2.getResults();
            if (_result2 != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _result2.getResultSet().close();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StatementResultHandler _handler = new StatementResultHandler();
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultT = null;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.startTimer();
            this.baseConnection.getQueryExecutor().execute(queryToExecute, queryParameters, _handler, this.maxrows, this.fetchSize, _flags);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.killTimerTask();
        }
        kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            this.resultT = this.firstUnclosedResult = _handler.getResults();
            if (this.wantsGeneratedKeysOnceT || this.wantsGeneratedKeysAlwaysT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._generatedKeys = this.resultT;
                this.resultT = this.resultT.getNext();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.wantsGeneratedKeysOnceT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.wantsGeneratedKeysOnceT = false;
                }
            }
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this.resultT == null || this.resultT.getResultSet() != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return -1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long _count = this.resultT.getUpdateCount();
            int tmpInt = _count > Integer.MAX_VALUE ? -2 : (int)_count;
            return tmpInt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this.resultT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            this.resultT = this.resultT.getNext();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (this.firstUnclosedResult != this.resultT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.firstUnclosedResult.getResultSet() != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.firstUnclosedResult.getResultSet().close();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            if (this.resultT != null && this.resultT.isLast()) {
                this.resultT.getResultSet().close();
                this.resultT = null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultT != null && this.resultT.getResultSet() != null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (max < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Maximum number of rows must be a _value grater than or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getMaxRows() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        return this.maxrows;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        long secs = this.timeoutT / 1000L;
        if (secs >= Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Integer.MAX_VALUE;
        }
        return (int)secs;
    }

    public long getQueryTimeoutMs() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        return this.timeoutT;
    }

    @Override
    public void setQueryTimeout(int secs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setQueryTimeoutMs((long)secs * 1000L);
    }

    public void setQueryTimeoutMs(long millisecs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (millisecs < 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Query _timeout must be a _value greater than or equals to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.timeoutT = millisecs;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.maxFieldSize;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        KSQLWarningWrapper warnWrapT = this._warnings;
        return warnWrapT != null ? warnWrapT.getFirstWarning() : null;
    }

    public void addWarning(SQLWarning warn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KSQLWarningWrapper warnWrap = this._warnings;
        if (warnWrap == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._warnings = new KSQLWarningWrapper(warn);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            warnWrap.addWarning(warn);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            this.checkIsClosed_();
            if (this.resultT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultT.getResultSet();
        }
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (maxFieldSize < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The maximum _field size must be a _value greater than or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.maxFieldSize = maxFieldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.isClosedT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return;
            }
            this.isClosedT = true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.cancel();
        this.closeForNextExecution_();
        this.closeImpl_();
    }

    protected void closeImpl_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastOID() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this.resultT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 0L;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultT.getInsertOID();
        }
    }

    @Override
    public void setPrepareThreshold(int newPrepareThreshold) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (newPrepareThreshold < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.forceBinaryTransfers = true;
            newPrepareThreshold = 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.mPrepareThreshold = newPrepareThreshold;
    }

    @Override
    public int getPrepareThreshold() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.mPrepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean _flag) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setPrepareThreshold(_flag ? 1 : 0);
    }

    @Override
    public boolean isUseServerPrepare() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    protected void checkIsClosed_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isClosed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("This stmt has been closed.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (this.batchStatementsList == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.batchParametersList = new ArrayList();
            this.batchStatementsList = new ArrayList();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean shouldUseParameterized = false;
        CachedQuery _cachedQuery = this.baseConnection.createQuery(_sql, this.replaceProcessingEnabled, shouldUseParameterized, new String[0]);
        this.batchParametersList.add(null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.batchStatementsList.add(_cachedQuery.query);
    }

    @Override
    public void clearBatch() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.batchStatementsList != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.batchStatementsList.clear();
            this.batchParametersList.clear();
        }
    }

    protected BatchResultHandler createBatchHandler(Query[] queriesT, ParameterList[] parameterListsT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new BatchResultHandler(this, queriesT, parameterListsT, this.wantsGeneratedKeysAlwaysT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchResultHandler internalExecuteBatch_() throws SQLException {
        boolean sameQueryAheadT;
        int flagsT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.transformQueriesAndParameters();
        Query[] queriesT = this.batchStatementsList.toArray(new Query[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParameterList[] _parameterLists = this.batchParametersList.toArray(new ParameterList[0]);
        this.batchStatementsList.clear();
        this.batchParametersList.clear();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean preDescribe = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.wantsGeneratedKeysAlwaysT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT = 320;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT = 4;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PreferQueryMode preferQueryMode = this.baseConnection.getPreferQueryMode();
        if (preferQueryMode == PreferQueryMode.SIMPLE || preferQueryMode == PreferQueryMode.EXTENDED_FOR_PREPARED && _parameterLists[0] == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT |= 0x400;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean bl = sameQueryAheadT = queriesT.length > 1 && queriesT[0] == queriesT[1];
        if (!sameQueryAheadT || this.isOneShotQuery(null)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT |= 1;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            preDescribe = (this.wantsGeneratedKeysAlwaysT || sameQueryAheadT) && !queriesT[0].isStatementDescribed();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT |= 0x200;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.getAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT |= 0x10;
        }
        if (this.baseConnection.hintReadOnly()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            flagsT |= 0x800;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BatchResultHandler _handler = this.createBatchHandler(queriesT, _parameterLists);
        if ((preDescribe || this.forceBinaryTransfers) && (flagsT & 0x400) == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _flags2 = flagsT | 0x20;
            StatementResultHandler _handler2 = new StatementResultHandler();
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.baseConnection.getQueryExecutor().execute(queriesT[0], _parameterLists[0], _handler2, 0, 0, _flags2);
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _handler.handleError(e);
                _handler.handleCompletion();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ResultWrapper _result2 = _handler2.getResults();
            if (_result2 != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _result2.getResultSet().close();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultT = null;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.startTimer();
            this.baseConnection.getQueryExecutor().execute(queriesT, _parameterLists, _handler, this.maxrows, this.fetchSize, flagsT, this.reWriteBind);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.killTimerTask();
            kbStatement = this;
            synchronized (kbStatement) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.checkIsClosed_();
                if (this.wantsGeneratedKeysAlwaysT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._generatedKeys = new ResultWrapper(_handler.getGeneratedKeys());
                }
            }
        }
        return _handler;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        this.closeForNextExecution_();
        if (this.batchStatementsList == null || this.batchStatementsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new int[0];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.internalExecuteBatch_().getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.stmtState == StatementCancelState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (!STATE_UPDATER_T.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        BaseConnection baseConnection = this.baseConnection;
        synchronized (baseConnection) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.baseConnection.cancelQuery();
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                STATE_UPDATER_T.set(this, StatementCancelState.CANCELLED);
                this.baseConnection.notifyAll();
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.baseConnection;
    }

    @Override
    public int getFetchDirection() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fetchdirectionT;
    }

    @Override
    public int getResultSetConcurrency() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.concurrencyT;
    }

    @Override
    public int getResultSetType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.resultsettypeT;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.fetchdirectionT = direction;
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Invalid fetch direction constant: {0}.", direction), KSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    private void startTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.cleanupTimer_();
        STATE_UPDATER_T.set(this, StatementCancelState.IN_QUERY);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.timeoutT == 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TimerTask cancelTaskT = new TimerTask(){

            @Override
            public void run() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!CANCEL_TIMER_UPDATER_T.compareAndSet(KbStatement.this, this, null)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return;
                    }
                    KbStatement.this.cancel();
                }
                catch (SQLException sqlException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        };
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CANCEL_TIMER_UPDATER_T.set(this, cancelTaskT);
        this.baseConnection.addTimerTask(cancelTaskT, this.timeoutT);
    }

    private boolean cleanupTimer_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimerTask __timerTask = CANCEL_TIMER_UPDATER_T.get(this);
        if (__timerTask == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.timeoutT == 0L;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!CANCEL_TIMER_UPDATER_T.compareAndSet(this, __timerTask, null)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        __timerTask.cancel();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection.purgeTimerTas_keyStore();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean timerTaskIsClearT = this.cleanupTimer_();
        if (timerTaskIsClearT && STATE_UPDATER_T.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean interruptedT = false;
        BaseConnection baseConnection = this.baseConnection;
        synchronized (baseConnection) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (!STATE_UPDATER_T.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    this.baseConnection.wait(10L);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                catch (InterruptedException interruptedException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    interruptedT = true;
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (interruptedT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Thread.currentThread().interrupt();
        }
    }

    protected boolean getForceBinaryTransfer_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.forceBinaryTransfers;
    }

    @Override
    public boolean isClosed() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.isClosedT;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        this.poolableT = poolable;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (fetchSize < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Fetch size must be a _value greater to or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchSize = fetchSize;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        return this.poolableT;
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.closeOnCompletionT = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.closeOnCompletionT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.closeOnCompletionT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (ResultWrapper _result = this.firstUnclosedResult; _result != null; _result = _result.getNext()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_result.getResultSet() != null && !_result.getResultSet().isClosed()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.closeOnCompletionT = false;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.close();
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.closeOnCompletionT = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (current == 1 && this.resultT != null && this.resultT.getResultSet() != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.resultT.getResultSet().close();
            }
            if (this.resultT != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.resultT = this.resultT.getNext();
            }
            if (current == 3) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (this.firstUnclosedResult != this.resultT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.firstUnclosedResult.getResultSet() != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.firstUnclosedResult.getResultSet().close();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.firstUnclosedResult = this.firstUnclosedResult.getNext();
                }
            }
            if (this.resultT != null && this.resultT.isLast()) {
                this.resultT.getResultSet().close();
                this.resultT = null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultT != null && this.resultT.getResultSet() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbStatement kbStatement = this;
        synchronized (kbStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this._generatedKeys == null || this._generatedKeys.getResultSet() == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.createDriverResultSet(new Field[0], new ArrayList<byte[][]>());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._generatedKeys.getResultSet();
        }
    }

    @Override
    public int executeUpdate(String _sql, int autoGeneratedKeys) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (autoGeneratedKeys == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.executeUpdate(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.executeUpdate(_sql, (String[])null);
    }

    @Override
    public int executeUpdate(String _sql, int[] _columnIndexes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnIndexes == null || _columnIndexes.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.executeUpdate(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Returning autogenerated keys by _column _index is not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String _sql, String[] _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnNames != null && _columnNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.executeUpdate(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wantsGeneratedKeysOnceT = true;
        if (!this.executeCachedSql(_sql, 0, _columnNames)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String _sql, int autoGeneratedKeys) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (autoGeneratedKeys == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.execute(_sql);
        }
        return this.execute(_sql, (String[])null);
    }

    @Override
    public boolean execute(String _sql, int[] _columnIndexes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnIndexes != null && _columnIndexes.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.execute(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Returning autogenerated keys by _column _index is not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String _sql, String[] _columnNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnNames != null && _columnNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.execute(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.wantsGeneratedKeysOnceT = true;
        return this.executeCachedSql(_sql, 0, _columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.resultSetHoldabilityT;
    }

    @Override
    public ResultSet createDriverResultSet(Field[] _fields, List<byte[][]> _tuples) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.createResultSet(null, _fields, _tuples, null);
    }

    protected void transformQueriesAndParameters() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public class StatementResultHandler
    extends ResultHandlerBase {
        private ResultWrapper lastResultT;
        private ResultWrapper resultsT;

        ResultWrapper getResults() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.resultsT;
        }

        private void append(ResultWrapper newResultT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.resultsT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.lastResultT = this.resultsT = newResultT;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.lastResultT.append(newResultT);
            }
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ResultSet resultSet = KbStatement.this.createResultSet(fromQuery, _fields, _tuples, cursor);
                this.append(new ResultWrapper(resultSet));
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.handleError(e);
            }
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, boolean isLast) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                ResultSet rs = KbStatement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs, isLast));
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.handleError(e);
            }
        }

        @Override
        public void handleCommandStatus(String status, long updateNum, long insertOID) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.append(new ResultWrapper(updateNum, insertOID));
        }

        @Override
        public void handleWarning(SQLWarning _warning) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbStatement.this.addWarning(_warning);
        }
    }
}

