/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.EncodingPredictor;
import org.postgresql.core.PGBindException;
import org.postgresql.core.VisibleBufferedInputStream;
import org.postgresql.dispatcher.core.ConnectionMangerV2;
import org.postgresql.util.DataCompress;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.KBByteBuffer;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec hostSpec;
    private final byte[] int4Buf;
    private final byte[] int2Buf;
    private Socket connection;
    private VisibleBufferedInputStream pgInput;
    private OutputStream pgOutput;
    private byte[] streamBuffer;
    private long nextStreamAvailableCheckTime;
    private int minStreamAvailableCheckDelay = 1000;
    private Encoding encoding;
    private Writer encodingWriter;
    private boolean useDispatch;
    private int version;
    private int zipLevel = 0;
    private byte[] input_cache;
    private int receivePos = 0;
    private KBByteBuffer output_cache = new KBByteBuffer();

    public PGStream(SocketFactory socketFactory, HostSpec hostSpec, int timeout, boolean useDispatch, int version) throws IOException {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        this.useDispatch = useDispatch;
        this.version = version;
        Socket socket = socketFactory.createSocket();
        if (!socket.isConnected()) {
            InetSocketAddress address = hostSpec.shouldResolve() != false ? new InetSocketAddress(hostSpec.getHost(), hostSpec.getPort()) : InetSocketAddress.createUnresolved(hostSpec.getHost(), hostSpec.getPort());
            socket.connect(address, timeout);
        }
        this.changeSocket(socket);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        this.int2Buf = new byte[2];
        this.int4Buf = new byte[4];
    }

    @Deprecated
    public PGStream(SocketFactory socketFactory, HostSpec hostSpec) throws IOException {
        this(socketFactory, hostSpec, 0, false, -1);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public boolean isUseDispatch() {
        return this.useDispatch;
    }

    public int getVersion() {
        return this.version;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() throws IOException {
        boolean available = false;
        if (this.pgInput.available() > 0) {
            return true;
        }
        long now = System.nanoTime() / 1000000L;
        if (now < this.nextStreamAvailableCheckTime && this.minStreamAvailableCheckDelay != 0) {
            return false;
        }
        int soTimeout = this.getNetworkTimeout();
        this.setNetworkTimeout(1);
        try {
            available = this.pgInput.peek() != -1;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.setNetworkTimeout(soTimeout);
        }
        if (!available) {
            this.nextStreamAvailableCheckTime = now + (long)this.minStreamAvailableCheckDelay;
        }
        return available;
    }

    public void setMinStreamAvailableCheckDelay(int delay) {
        this.minStreamAvailableCheckDelay = delay;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        try {
            this.connection.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            LOGGER.log(Level.FINEST, "Ignoring exception on unix domain socket:", e);
        }
        this.pgInput = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192, ConnectionMangerV2.nodeMap.get(this.hostSpec.getHost() + ":" + this.hostSpec.getPort()), this.useDispatch, this.version);
        this.pgOutput = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public void setSocketTimeout(int socketTimeout) {
        this.pgInput.setSocketTimeout(socketTimeout);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encoding != null && this.encoding.name().equals(encoding.name())) {
            return;
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.pgOutput){

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void sendChar(int val) throws IOException {
        if (this.zipLevel > 0) {
            byte[] temp = new byte[]{(byte)val};
            this.writeCache(temp, 0, 1);
        } else {
            this.pgOutput.write(val);
        }
    }

    public void sendInteger4(int val) throws IOException {
        this.int4Buf[0] = (byte)(val >>> 24);
        this.int4Buf[1] = (byte)(val >>> 16);
        this.int4Buf[2] = (byte)(val >>> 8);
        this.int4Buf[3] = (byte)val;
        if (this.zipLevel > 0) {
            this.writeCache(this.int4Buf, 0, 4);
        } else {
            this.pgOutput.write(this.int4Buf);
        }
    }

    public void sendInteger2(int val) throws IOException {
        if (val < 0 || val > 65535) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + val);
        }
        this.int2Buf[0] = (byte)(val >>> 8);
        this.int2Buf[1] = (byte)val;
        if (this.zipLevel > 0) {
            this.writeCache(this.int2Buf, 0, 2);
        } else {
            this.pgOutput.write(this.int2Buf);
        }
    }

    public void send(byte[] buf) throws IOException {
        if (this.zipLevel > 0) {
            int len = 0;
            while (buf.length - len >= 8192) {
                this.writeCache(buf, len, 8192);
                len += 8192;
            }
            this.writeCache(buf, len, buf.length - len);
        } else {
            this.pgOutput.write(buf);
        }
    }

    public void send(byte[] buf, int siz) throws IOException {
        this.send(buf, 0, siz);
    }

    public void send(byte[] buf, int off, int siz) throws IOException {
        if (this.zipLevel > 0) {
            int len = 0;
            while (siz - len >= 8192) {
                this.writeCache(buf, off + len, 8192);
                len += 8192;
            }
            this.writeCache(buf, off + len, siz - len);
        } else {
            int bufamt = buf.length - off;
            this.pgOutput.write(buf, off, bufamt < siz ? bufamt : siz);
            for (int i = bufamt; i < siz; ++i) {
                this.pgOutput.write(0);
            }
        }
    }

    public int peekChar() throws IOException {
        if (this.zipLevel > 0) {
            byte c = 0;
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                this.receiveData();
            }
            c = this.input_cache[this.receivePos];
            return c;
        }
        int c = this.pgInput.peek();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int receiveChar() throws IOException {
        if (this.zipLevel > 0) {
            byte c = 0;
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                this.receiveData();
            }
            c = this.input_cache[this.receivePos++];
            return c;
        }
        int c = this.pgInput.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int receiveInteger4() throws IOException {
        if (this.zipLevel > 0) {
            int i = 0;
            while (i < 4) {
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    this.receiveData();
                }
                this.int4Buf[i++] = this.input_cache[this.receivePos++];
            }
        } else if (this.pgInput.read(this.int4Buf) != 4) {
            throw new EOFException();
        }
        return (this.int4Buf[0] & 0xFF) << 24 | (this.int4Buf[1] & 0xFF) << 16 | (this.int4Buf[2] & 0xFF) << 8 | this.int4Buf[3] & 0xFF;
    }

    public int receiveInteger2() throws IOException {
        if (this.zipLevel > 0) {
            int i = 0;
            while (i < 2) {
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    this.receiveData();
                }
                this.int2Buf[i++] = this.input_cache[this.receivePos++];
            }
        } else if (this.pgInput.read(this.int2Buf) != 2) {
            throw new EOFException();
        }
        return (this.int2Buf[0] & 0xFF) << 8 | this.int2Buf[1] & 0xFF;
    }

    public String receiveString(int len) throws IOException {
        if (this.zipLevel > 0) {
            byte[] result = this.receive(len);
            String res = this.encoding.decode(result, 0, len);
            return res;
        }
        if (!this.pgInput.ensureBytes(len)) {
            throw new EOFException();
        }
        String res = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
        this.pgInput.skip(len);
        return res;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int len) throws IOException {
        EncodingPredictor.DecodeResult res;
        block7: {
            if (this.zipLevel > 0) {
                EncodingPredictor.DecodeResult res2;
                block6: {
                    byte[] result = this.receive(len);
                    try {
                        String value = this.encoding.decode(result, 0, len);
                        res2 = new EncodingPredictor.DecodeResult(value, null);
                    }
                    catch (IOException e) {
                        res2 = EncodingPredictor.decode(result, 0, len);
                        if (res2 != null) break block6;
                        Encoding enc = Encoding.defaultEncoding();
                        String value = enc.decode(result, 0, len);
                        res2 = new EncodingPredictor.DecodeResult(value, enc.name());
                    }
                }
                return res2;
            }
            if (!this.pgInput.ensureBytes(len)) {
                throw new EOFException();
            }
            try {
                String value = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, null);
            }
            catch (IOException e) {
                res = EncodingPredictor.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
                if (res != null) break block7;
                Encoding enc = Encoding.defaultEncoding();
                String value = enc.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, enc.name());
            }
        }
        this.pgInput.skip(len);
        return res;
    }

    public String receiveString() throws IOException {
        if (this.zipLevel > 0) {
            int strLen = 8192;
            byte[] strValue = new byte[strLen];
            int i = 0;
            byte c = 1;
            while (c != 0) {
                if (i == strLen + 1) {
                    byte[] newValue = new byte[strLen *= 2];
                    System.arraycopy(strValue, 0, newValue, 0, strValue.length);
                    strValue = newValue;
                }
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    this.receiveData();
                }
                int n = i++;
                byte by = this.input_cache[this.receivePos++];
                strValue[n] = by;
                c = by;
            }
            return this.encoding.decode(strValue, 0, i - 1);
        }
        int len = this.pgInput.scanCStringLength();
        String res = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len - 1);
        this.pgInput.skip(len);
        return res;
    }

    public byte[][] receiveTupleV3() throws IOException, OutOfMemoryError {
        this.receiveInteger4();
        int nf = this.receiveInteger2();
        byte[][] answer = new byte[nf][];
        OutOfMemoryError oom = null;
        for (int i = 0; i < nf; ++i) {
            int size = this.receiveInteger4();
            if (size == -1) continue;
            try {
                answer[i] = new byte[size];
                this.receive(answer[i], 0, size);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.skip(size);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[] receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.receive(answer, 0, siz);
        return answer;
    }

    public void receive(byte[] buf, int off, int siz) throws IOException {
        int w;
        if (this.zipLevel > 0) {
            int i = 0;
            while (i++ < siz) {
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    this.receiveData();
                }
                buf[off++] = this.input_cache[this.receivePos++];
            }
            return;
        }
        for (int s = 0; s < siz; s += w) {
            w = this.pgInput.read(buf, off + s, siz - s);
            if (w >= 0) continue;
            throw new EOFException();
        }
    }

    public void skip(int size) throws IOException {
        if (this.zipLevel > 0) {
            this.skipCache(size);
            return;
        }
        for (long s = 0L; s < (long)size; s += this.pgInput.skip((long)size - s)) {
        }
    }

    public void sendStream(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            int readCount;
            int count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
            try {
                readCount = inStream.read(this.streamBuffer, 0, count);
                if (readCount < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", expectedLength, expectedLength - remaining));
                }
            }
            catch (IOException ioe) {
                while (remaining > 0) {
                    this.send(this.streamBuffer, count);
                    count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                }
                throw new PGBindException(ioe);
            }
            this.send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.zipLevel > 0) {
            this.flushCache();
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pgOutput.flush();
    }

    public void receiveEOF() throws SQLException, IOException {
        int c = 0;
        if (this.zipLevel > 0) {
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                try {
                    this.receiveData();
                }
                catch (EOFException e) {
                    return;
                }
            }
            c = this.input_cache[this.receivePos++];
        } else {
            c = this.pgInput.read();
            if (c < 0) {
                return;
            }
        }
        throw new PSQLException(GT.tr("Expected an EOF from server, got: {0}", c), PSQLState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pgOutput.close();
        this.pgInput.close();
        this.connection.close();
    }

    public void setNetworkTimeout(int milliseconds) throws IOException {
        if (this.isUseDispatch()) {
            this.connection.setSoTimeout(milliseconds);
            this.setSocketTimeout(1);
            LOGGER.log(Level.INFO, "socketTimeout is " + milliseconds, new Object[0]);
        } else {
            this.connection.setSoTimeout(milliseconds);
        }
    }

    public int getNetworkTimeout() throws IOException {
        return this.connection.getSoTimeout();
    }

    public void sendData(byte[] data) throws IOException {
        byte[] zip = DataCompress.packMessage(data, this.zipLevel);
        int zipLen = zip.length;
        int siz = 4;
        byte[] buf = new byte[siz];
        while (siz-- > 0) {
            buf[siz] = (byte)(zipLen & 0xFF);
            zipLen >>= 8;
        }
        this.pgOutput.write(buf);
        this.pgOutput.write(zip);
    }

    public void receiveData() throws IOException {
        int w;
        int size = 0;
        for (int i = 0; i < 4; ++i) {
            int b = this.pgInput.read();
            if (b < 0) {
                throw new EOFException();
            }
            size = b | size << 8;
        }
        byte[] temp = new byte[size];
        for (int s = 0; s < size; s += w) {
            w = this.pgInput.read(temp, s, size - s);
            if (w >= 0) continue;
            throw new EOFException();
        }
        this.input_cache = DataCompress.unPackMessage(temp);
        this.receivePos = 0;
    }

    public void flushCache() throws IOException {
        if (this.output_cache.getEndPos() > 0) {
            this.sendData(this.output_cache.getBuffer());
            this.output_cache.clear();
        }
    }

    public void skipCache(int len) throws IOException {
        int i = 0;
        while (i < len) {
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                this.receiveData();
                continue;
            }
            int l = this.input_cache.length - this.receivePos;
            if (l >= len) {
                this.receivePos += len;
                i += len;
                continue;
            }
            this.receivePos = this.input_cache.length;
            i += l;
        }
    }

    public void writeCache(byte[] buf, int off, int siz) throws IOException {
        if (this.output_cache.getEndPos() + siz > 8192) {
            this.flushCache();
        }
        if (buf.length - off >= siz) {
            this.output_cache.copy(buf, off, siz);
        } else {
            byte[] temp = new byte[siz + off - buf.length];
            this.output_cache.copy(buf, off, buf.length - off);
            this.output_cache.copy(temp, 0, temp.length);
        }
    }

    public void setZipLevel(int zipLevel) {
        this.zipLevel = zipLevel;
    }
}

