/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication.fluent.physical;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.ReplicationSlotInfo;
import org.postgresql.replication.ReplicationType;
import org.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import org.postgresql.replication.fluent.physical.ChainedPhysicalCreateSlotBuilder;
import org.postgresql.util.TraceLogger;

public class PhysicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedPhysicalCreateSlotBuilder>
implements ChainedPhysicalCreateSlotBuilder {
    public PhysicalCreateSlotBuilder(BaseConnection _connection) {
        super(_connection);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    protected ChainedPhysicalCreateSlotBuilder getSelf() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PhysicalCreateSlotBuilder t = this;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.slotNameT == null || this.slotNameT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("Replication _slotName can't be null");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stmt = this.baseConnection.createStatement();
        ResultSet rst = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ReplicationSlotInfo slotInfo = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s1 = "CREATE_REPLICATION_SLOT %s %s PHYSICAL";
            String s2 = "TEMPORARY";
            stmt.execute(String.format(s1, this.slotNameT, this.temporaryOptionT ? s2 : ""));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rst = stmt.getResultSet();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (rst != null && rst.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String t1 = "slot_name";
                String t2 = "consistent_point";
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String t3 = "snapshot_name";
                String t4 = "output_plugin";
                slotInfo = new ReplicationSlotInfo(rst.getString("slot_name"), ReplicationType.PHYSICAL, LogSequenceNumber.valueOf(rst.getString("consistent_point")), rst.getString("snapshot_name"), rst.getString("output_plugin"));
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (rst != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                rst.close();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stmt.close();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return slotInfo;
    }
}

